/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.ColumnForComputation;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureContainer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.server.recipes.GroupingQueryGenerator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import java.util.List;
import java.util.Map;

public class AutoFeatureGroupByQueryGenerator {
    private final Map<String, Dataset> datasetsMap;
    private final Map<String, SQLUtils.SQLTable> sqlTablesMap;
    private final Map<Integer, String> viewNameByDataset;
    private final SQLDialect dialect;
    private final Integer identifierMaxLength;

    public AutoFeatureGroupByQueryGenerator(Map<String, Dataset> datasetsMap, Map<String, SQLUtils.SQLTable> sqlTablesMap, Map<Integer, String> viewNameByDataset, SQLDialect dialect, Integer identifierMaxLength) {
        this.datasetsMap = datasetsMap;
        this.sqlTablesMap = sqlTablesMap;
        this.viewNameByDataset = viewNameByDataset;
        this.dialect = dialect;
        this.identifierMaxLength = identifierMaxLength;
    }

    public static Dataset createGroupByDataset(List<GroupingRecipePayloadParams.GroupingKey> groupingKeys, List<FeatureContainer> outputColumnsFromGroupBy) {
        Schema backwardDatasetSchema = new Schema();
        Dataset groupingDataset = new Dataset();
        for (FeatureContainer featureContainer : outputColumnsFromGroupBy) {
            backwardDatasetSchema.addColumn(featureContainer.inputColumn, featureContainer.schemaType);
        }
        for (GroupingRecipePayloadParams.GroupingKey groupKey : groupingKeys) {
            backwardDatasetSchema.addColumn(groupKey.column, groupKey.type);
        }
        groupingDataset.setSchema(backwardDatasetSchema);
        return groupingDataset;
    }

    public static GroupingRecipePayloadParams generateParams(RelationshipGraph.BackwardEdge edge, AutoFeatureGenerationRecipePayloadParams params) {
        GroupingRecipePayloadParams groupParams = new GroupingRecipePayloadParams();
        groupParams.setGroupingKeys(edge.getGroupingKeys());
        for (ColumnForComputation column : edge.getColumnsToAggregate()) {
            List<AutoFeatureGenerationRecipePayloadParams.Feature> features = params.getRelationalFeaturesForType(column.variableType);
            groupParams.values.add(AutoFeatureGroupByQueryGenerator.initGroupValues(column, features));
        }
        groupParams.globalCount = params.features.stream().anyMatch(feature -> feature.equals((Object)AutoFeatureGenerationRecipePayloadParams.Feature.COUNT));
        return groupParams;
    }

    public String generateQuery(RelationshipGraph.BackwardEdge edge, GroupingRecipePayloadParams groupParams) {
        String groupingDatasetName = this.viewNameByDataset.containsKey(edge.relatedNode) ? this.viewNameByDataset.get(edge.relatedNode) : edge.getRelatedNodeName();
        Dataset groupingDataset = this.datasetsMap.get(groupingDatasetName);
        GroupingQueryGenerator groupingQueryGenerator = new GroupingQueryGenerator(groupParams, groupingDataset, groupingDataset.getParams(), this.sqlTablesMap.get(groupingDatasetName), null);
        return groupingQueryGenerator.generateQuery(this.dialect, this.identifierMaxLength, true).toSQL(this.dialect);
    }

    private static GroupingRecipePayloadParams.GroupingValue initGroupValues(ColumnForComputation column, List<AutoFeatureGenerationRecipePayloadParams.Feature> relationalFeatures) {
        GroupingRecipePayloadParams.GroupingValue groupingValue = new GroupingRecipePayloadParams.GroupingValue();
        groupingValue.column = column.name;
        groupingValue.min = relationalFeatures.contains((Object)AutoFeatureGenerationRecipePayloadParams.Feature.MIN);
        groupingValue.max = relationalFeatures.contains((Object)AutoFeatureGenerationRecipePayloadParams.Feature.MAX);
        groupingValue.sum = relationalFeatures.contains((Object)AutoFeatureGenerationRecipePayloadParams.Feature.SUM);
        groupingValue.avg = relationalFeatures.contains((Object)AutoFeatureGenerationRecipePayloadParams.Feature.AVG);
        groupingValue.countDistinct = relationalFeatures.contains((Object)AutoFeatureGenerationRecipePayloadParams.Feature.DISTINCT);
        return groupingValue;
    }
}

