/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.common.VirtualInputBasedRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class JoinLikeRecipePayloadParams<I extends JoinInputDescBase, M extends MatchingConditionBase, J extends JoinDescBase<M>>
extends VirtualInputBasedRecipePayloadParams<I> {
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.dataflow.exec.joinlike");
    public static final int MAX_SUGGESTED_JOIN_CONDITIONS = 5;
    public List<J> joins = new ArrayList<J>();
    public List<ColumnDesc> selectedColumns = new ArrayList<ColumnDesc>();
    private List<ColumnDesc> resolvedSelectedColumns = new ArrayList<ColumnDesc>();

    protected static boolean nullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    @Override
    public void validate() {
        this.validateTableDefinition();
        this.validateJoins();
        this.validateSelectedColumns();
    }

    public void resolveSelectedColumns(Map<String, Dataset> datasetsMap, boolean caseInsensitive) {
        logger.info((Object)"Resolve selected columns");
        ArrayList selectedColumnsByIndex = new ArrayList();
        for (int i = 0; i < this.virtualInputs.size(); ++i) {
            selectedColumnsByIndex.add(new ArrayList());
        }
        if (this.selectedColumns != null) {
            for (ColumnDesc sc : this.selectedColumns) {
                ((ArrayList)selectedColumnsByIndex.get(sc.table)).add(sc);
            }
        }
        HashSet<String> alreadyAddedNames = new HashSet<String>();
        this.resolvedSelectedColumns = new ArrayList<ColumnDesc>();
        block7: for (int i = 0; i < this.virtualInputs.size(); ++i) {
            JoinInputDescBase vi = (JoinInputDescBase)this.virtualInputs.get(i);
            if (!this.areInputColumnsSelectable(i)) continue;
            switch (vi.outputColumnsSelectionMode) {
                case MANUAL: {
                    for (ColumnDesc col : (ArrayList)selectedColumnsByIndex.get(i)) {
                        this.resolvedSelectedColumns.add(col);
                        String fullyResolvedName = StringUtils.isBlank((String)col.alias) ? (StringUtils.isBlank((String)vi.prefix) ? col.name : vi.prefix + "_" + col.name) : col.alias;
                        alreadyAddedNames.add(caseInsensitive ? fullyResolvedName.toLowerCase() : fullyResolvedName);
                    }
                    continue block7;
                }
                case ALL: {
                    ColumnDesc colDesc;
                    String nameWithPrefix;
                    Dataset dataset = datasetsMap.get(vi.name);
                    Schema schema = dataset.getSchema();
                    if (schema == null || schema.columns.isEmpty()) {
                        throw ErrorContext.iaef((String)"Dataset has no schema: %s", (Object)dataset.getFullName(), (Object[])new Object[0]);
                    }
                    for (SchemaColumn col : schema.columns) {
                        nameWithPrefix = StringUtils.isBlank((String)vi.prefix) ? col.getName() : vi.prefix + "_" + col.getName();
                        colDesc = new ColumnDesc();
                        colDesc.table = i;
                        colDesc.name = col.getName();
                        this.resolvedSelectedColumns.add(colDesc);
                        alreadyAddedNames.add(caseInsensitive ? nameWithPrefix.toLowerCase() : nameWithPrefix);
                    }
                    for (ComputedColumn cc : ((JoinInputDescBase)this.virtualInputs.get(i)).getComputedColumns()) {
                        nameWithPrefix = StringUtils.isBlank((String)vi.prefix) ? cc.name : vi.prefix + "_" + cc.name;
                        colDesc = new ColumnDesc();
                        colDesc.table = i;
                        colDesc.name = cc.name;
                        this.resolvedSelectedColumns.add(colDesc);
                        alreadyAddedNames.add(caseInsensitive ? nameWithPrefix.toLowerCase() : nameWithPrefix);
                    }
                    continue block7;
                }
                case AUTO_NON_CONFLICTING: {
                    ColumnDesc colDesc;
                    String nameWithPrefix;
                    Dataset dataset = datasetsMap.get(vi.name);
                    Schema schema = dataset.getSchema();
                    if (schema == null || schema.columns.isEmpty()) {
                        throw ErrorContext.iaef((String)"Dataset has no schema: %s", (Object)dataset.getFullName(), (Object[])new Object[0]);
                    }
                    for (SchemaColumn col : schema.columns) {
                        nameWithPrefix = StringUtils.isBlank((String)vi.prefix) ? col.getName() : vi.prefix + "_" + col.getName();
                        logger.trace(() -> "Check append of " + nameWithPrefix);
                        if (alreadyAddedNames.contains(caseInsensitive ? nameWithPrefix.toLowerCase() : nameWithPrefix)) {
                            logger.trace(() -> "Not adding column " + nameWithPrefix + " from dataset " + dataset.getName() + ", since this column name is already in join output");
                            continue;
                        }
                        colDesc = new ColumnDesc();
                        colDesc.table = i;
                        colDesc.name = col.getName();
                        this.resolvedSelectedColumns.add(colDesc);
                        alreadyAddedNames.add(caseInsensitive ? nameWithPrefix.toLowerCase() : nameWithPrefix);
                    }
                    for (ComputedColumn cc : ((JoinInputDescBase)this.virtualInputs.get(i)).getComputedColumns()) {
                        ColumnDesc colDesc2 = new ColumnDesc();
                        colDesc2.table = i;
                        colDesc2.name = cc.name;
                        this.resolvedSelectedColumns.add(colDesc2);
                    }
                    continue block7;
                }
            }
        }
    }

    public boolean isAntiJoin() {
        return this.joins.size() == 1 && (((JoinDescBase)this.joins.get((int)0)).type == JoinType.LEFT_ANTI || ((JoinDescBase)this.joins.get((int)0)).type == JoinType.RIGHT_ANTI);
    }

    public boolean areInputColumnsSelectable(int virtualTableIndex) {
        if (!this.isAntiJoin()) {
            return true;
        }
        JoinType joinType = ((JoinDescBase)this.joins.get((int)0)).type;
        return joinType == JoinType.LEFT_ANTI && virtualTableIndex == 0 || joinType == JoinType.RIGHT_ANTI && virtualTableIndex == 1;
    }

    public List<ColumnDesc> getSelectedColumns() {
        assert (this.resolvedSelectedColumns != null);
        logger.trace(() -> "getSelectedColumns" + JSON.pretty(this.resolvedSelectedColumns));
        return this.resolvedSelectedColumns;
    }

    public void setSelectedColumns(List<ColumnDesc> s) {
        this.selectedColumns = s;
    }

    public void addSelectedColumn(ColumnDesc c2) {
        this.selectedColumns.add(c2);
    }

    protected abstract J newJoinDesc();

    public void initializeJoinDesc() {
        J join = this.newJoinDesc();
        ((JoinDescBase)join).table1 = 0;
        ((JoinDescBase)join).table2 = 1;
        this.joins = Lists.newArrayList((Object[])new JoinDescBase[]{join});
    }

    public void validateSelectedColumns() {
        if (JoinLikeRecipePayloadParams.nullOrEmpty(this.getSelectedColumns())) {
            throw ErrorContext.iae((String)"No column is selected for output.");
        }
        for (ColumnDesc cd : this.getSelectedColumns()) {
            if (this.isValidColumnDesc(cd)) continue;
            throw ErrorContext.iae((String)"Invalid selected column.");
        }
    }

    protected boolean isValidColumnDesc(ColumnDesc cd) {
        return cd != null && !StringUtils.isBlank((String)cd.name) && this.isValidTableIndex(cd.table);
    }

    public void validateJoins() {
        if (JoinLikeRecipePayloadParams.nullOrEmpty(this.joins)) {
            throw ErrorContext.iae((String)"Empty join list.");
        }
        for (JoinDescBase join : this.joins) {
            if (!this.isValidTableIndex(join.table1) || !this.isValidTableIndex(join.table2)) {
                throw ErrorContext.iae((String)"Invalid table index in join.");
            }
            if (join.type == null) {
                throw ErrorContext.iae((String)"Invalid join type.");
            }
            if (join.requiresJoinConditions() && JoinLikeRecipePayloadParams.nullOrEmpty(join.getJoinConditions())) {
                throw ErrorContext.iae((String)"Empty join conditions list.");
            }
            if (this.joins.size() > 1 && (join.type == JoinType.LEFT_ANTI || join.type == JoinType.RIGHT_ANTI)) {
                throw ErrorContext.iae((String)"Cannot use anti join type if there is more than one join.");
            }
            for (MatchingConditionBase joinCondition : join.getJoinConditions()) {
                this.validateJoinCondition(joinCondition);
            }
        }
    }

    public abstract void validateJoinCondition(M var1);
}

