/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementSQLGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementSchemaGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.recipes.GroupingQueryGenerator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PivotSQLGenerator {
    protected final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    protected final PivotRecipePayloadParams params;
    protected final SQLUtils.SQLTable sqlTable;
    protected final SelectQueryBuilder sqlTableQuery;
    protected final String sqlTableQueryName;
    protected final Dataset sourceDataset;
    protected final Dataset outputDataset;
    protected PartitioningScheme sourcePartitionScheme;
    protected List<Partition> sourcePartitions;
    protected PartitioningScheme targetPartitionScheme;

    public PivotSQLGenerator(PivotRecipePayloadParams params, Dataset sourceDataset, SQLUtils.SQLTable sqlTable, Dataset outputDataset) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)sourceDataset.getSchema(), (Object)"Input dataset has no schema");
        this.sourceDataset = sourceDataset;
        this.outputDataset = outputDataset;
        this.params = params;
        this.sqlTable = sqlTable;
        this.sqlTableQuery = null;
        this.sqlTableQueryName = null;
    }

    public PivotSQLGenerator(PivotRecipePayloadParams params, Dataset sourceDataset, SelectQueryBuilder sqlTableQuery, String sqlTableQueryName, Dataset outputDataset) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)sourceDataset.getSchema(), (Object)"Input dataset has no schema");
        this.sourceDataset = sourceDataset;
        this.outputDataset = outputDataset;
        this.params = params;
        this.sqlTable = null;
        this.sqlTableQuery = sqlTableQuery;
        this.sqlTableQueryName = sqlTableQueryName;
    }

    public void setPartitioning(PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme) {
        this.sourcePartitionScheme = sourcePartitionScheme;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
    }

    public QueryGenerationUtils.SelectQueryBuilderAndSchema generateQueryForPivot(SQLDialect dialect) {
        if (this.sqlTableQuery != null) {
            return QueryGenerationUtils.prepareInput(this.sqlTableQuery, this.sqlTableQueryName, dialect, this.sourceDataset, this.params.preFilter, this.params.computedColumns, this.sourcePartitionScheme, this.sourcePartitions);
        }
        return QueryGenerationUtils.prepareInput(this.sqlTable, dialect, this.sourceDataset, this.params.preFilter, this.params.computedColumns, this.sourcePartitionScheme, this.sourcePartitions);
    }

    public SelectQueryBuilder generateQuery(List<String> identifiers, List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities, SQLDialect dialect, boolean forceOutputColumnNameOverride) {
        QueryGenerationUtils.SelectQueryBuilderAndSchema preparedInput = this.generateQueryForPivot(dialect);
        Schema schemaToPivot = preparedInput.schema;
        Dataset datasetToPivot = preparedInput.dataset;
        SelectQueryBuilder filteredQB = preparedInput.selectQueryBuilder;
        HashSet keyColumns = Sets.newHashSet();
        Schema filteredSchema = new Schema();
        for (String key : identifiers) {
            if (keyColumns.contains(key)) continue;
            keyColumns.add(key);
            filteredSchema.addColumn(schemaToPivot.getColumn(key));
            filteredQB.select(this.ef.col(key));
        }
        for (GroupingRecipePayloadParams.GroupingValue otherColumn : this.params.otherColumns) {
            if (keyColumns.contains(otherColumn.column)) continue;
            keyColumns.add(otherColumn.column);
            filteredSchema.addColumn(schemaToPivot.getColumn(otherColumn.column));
            filteredQB.select(this.ef.col(otherColumn.column));
        }
        for (PivotElement pivot : this.params.pivots) {
            this.generateForPivot(schemaToPivot, filteredQB, keyColumns, filteredSchema, pivot);
        }
        for (PivotElementsModalitiesSnapshot.PivotElementsModalities pivotElementModalities : pivotElementsModalities) {
            PivotElementSQLGenerator pivotElementSQLGenerator = new PivotElementSQLGenerator(pivotElementModalities.pivotElement, schemaToPivot);
            pivotElementSQLGenerator.generatePivotedQuery(pivotElementModalities.pivotedModalities, filteredQB, dialect);
            filteredSchema = new PivotElementSchemaGenerator(schemaToPivot).generate(filteredSchema, pivotElementModalities.pivotedModalities);
        }
        GroupingRecipePayloadParams groupingParams = this.params.generateGroupingRecipeParams(identifiers, pivotElementsModalities, filteredSchema);
        Dataset filteredDataset = ((Dataset)JSON.deepCopy((Object)datasetToPivot)).withSchema(filteredSchema);
        GroupingQueryGenerator subQueryGenerator = new GroupingQueryGenerator(groupingParams, filteredDataset, datasetToPivot.getParams(), filteredQB, "dku_filtered_query", this.outputDataset);
        subQueryGenerator.setPartitioning(null, null, this.targetPartitionScheme);
        return subQueryGenerator.generateQuery(dialect, this.params.getModalityMaxLength(dialect), forceOutputColumnNameOverride, true);
    }

    private void generateForPivot(Schema schemaToPivot, SelectQueryBuilder filteredQB, Set<String> keyColumns, Schema filteredSchema, PivotElement pivot) {
        for (String key : pivot.keyColumns) {
            if (keyColumns.contains(key)) continue;
            keyColumns.add(key);
            filteredSchema.addColumn(schemaToPivot.getColumn(key));
            filteredQB.select(this.ef.col(key));
        }
        for (GroupingRecipePayloadParams.GroupingValue value : pivot.valueColumns) {
            if (!value.first && !value.last || keyColumns.contains(value.orderColumn)) continue;
            keyColumns.add(value.orderColumn);
            filteredSchema.addColumn(schemaToPivot.getColumn(value.orderColumn));
            filteredQB.select(this.ef.col(value.orderColumn));
        }
    }
}

