/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.update;

import com.dataiku.dip.dataflow.exec.update.UpdateRecipeParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.RowNumberAwareOutput;
import com.dataiku.dip.output.RowNumberAwareOutputWriter;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UpdateOutputProcessor
implements ProcessorOutput {
    private RowNumberAwareOutputWriter mainOutputWriter;
    private RowNumberAwareOutputWriter changesOutputWriter;
    private MemTable oldContent;
    private MemTable oldChanges;
    private ColumnFactory cf;
    private RowFactory rf;
    private UpdateRecipeParams params;
    private HashMap<String, Integer> index = new HashMap();
    private Set<Integer> emmitedRowsIndexes;
    private Set<String> emmitedKeys;
    static final DKULogger logger = DKULogger.getLogger((String)"dku.output.update");

    public UpdateOutputProcessor(RowNumberAwareOutput dataOut, RowNumberAwareOutput changesOut, MemTable previousContent, MemTable previousChanges, ColumnFactory cf, RowFactory rf, UpdateRecipeParams params) throws Exception {
        this.oldContent = previousContent;
        this.oldChanges = previousChanges;
        this.cf = cf;
        this.rf = rf;
        this.params = params;
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull(params.uniqueKey);
        if (params.uniqueKey == null || params.uniqueKey.size() == 0) {
            throw new IllegalArgumentException("Recipe requires a unique key");
        }
        if (!params.deleteMissingRows) {
            this.emmitedRowsIndexes = new HashSet<Integer>();
        }
        this.emmitedKeys = new HashSet<String>();
        this.mainOutputWriter = dataOut.getWriter(Output.WriteMode.OVERWRITE);
        this.mainOutputWriter.init(cf);
        this.changesOutputWriter = changesOut.getWriter(Output.WriteMode.OVERWRITE);
        this.changesOutputWriter.init(cf);
        this.buildIndex();
    }

    private void buildIndex() {
        for (int i = 0; i < this.oldContent.nrows(); ++i) {
            String key = this.getKey(this.oldContent.rows.get(i), this.oldContent);
            this.index.put(key, i);
        }
    }

    private List<String> getKeyParts(Row row, ColumnFactory cf) {
        ArrayList<String> keyParts = new ArrayList<String>();
        for (String subKeyName : this.params.uniqueKey) {
            String keyPart = row.get(cf.column(subKeyName));
            if (keyPart == null) continue;
            keyParts.add(row.get(cf.column(subKeyName)));
        }
        return keyParts;
    }

    private String getKey(Row row, ColumnFactory cf) {
        List<String> keyParts = this.getKeyParts(row, cf);
        return Joiner.on((String)"_DKU_KEY_SEP_").join(keyParts);
    }

    private Row copyOldRow(Row oldRow) {
        Row newRow = this.rf.row();
        for (Column newCol : this.cf.columns()) {
            MemColumn oldCol = this.oldContent.column(newCol.getName());
            newRow.put(newCol, oldRow.get((Column)oldCol));
        }
        return newRow;
    }

    private boolean hasKey(Row row, ColumnFactory cf) {
        for (String keyPart : this.getKeyParts(row, cf)) {
            if (!StringUtils.isNotBlank((String)keyPart)) continue;
            return true;
        }
        return false;
    }

    public void emitRow(Row row) throws Exception {
        Row changesRow;
        if (!this.hasKey(row, this.cf)) {
            logger.warn((Object)"Drop row with empty key");
            return;
        }
        String key = this.getKey(row, this.cf);
        if (this.emmitedKeys.contains(key)) {
            logger.warn((Object)"Row with duplicate key dropped");
            return;
        }
        int idx = -1;
        if (this.index.containsKey(key)) {
            idx = this.index.get(key);
            Row newRow = row;
            Row oldRow = this.oldContent.rows.get(idx);
            row = this.copyOldRow(oldRow);
            changesRow = this.oldChanges == null || this.oldChanges.rows.size() <= idx ? this.rf.row() : this.copyOldRow(this.oldChanges.rows.get(idx));
            for (Column newCol : this.cf.columns()) {
                if (StringUtils.equals((String)changesRow.get(newCol), (String)"true")) continue;
                row.put(newCol, newRow.get(newCol));
            }
            if (!this.params.deleteMissingRows) {
                this.emmitedRowsIndexes.add(idx);
            }
        } else {
            if (!this.params.addMissingRows) {
                logger.warn((Object)"New row dropped");
                return;
            }
            changesRow = this.rf.row();
        }
        this.emmitedKeys.add(key);
        this.mainOutputWriter.emitRow(row, idx);
        this.changesOutputWriter.emitRow(changesRow);
    }

    public void lastRowEmitted() throws Exception {
        if (!this.params.deleteMissingRows) {
            for (int idx = 0; idx < this.oldContent.nrows(); ++idx) {
                Row row = this.oldContent.rows.get(idx);
                String key = this.getKey(row, this.oldContent);
                if (!StringUtils.isNotBlank((String)key) || this.emmitedKeys.contains(key)) continue;
                row = this.copyOldRow(row);
                this.emitRow(row);
            }
        }
        this.mainOutputWriter.lastRowEmitted();
        this.changesOutputWriter.lastRowEmitted();
    }

    public void cancel() throws Exception {
        this.mainOutputWriter.cancel();
        this.changesOutputWriter.cancel();
    }

    public void setMaxMemoryUsed(long size) {
        this.mainOutputWriter.setMaxMemoryUsed(size);
        this.changesOutputWriter.setMaxMemoryUsed(size);
    }
}

