/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph;

import com.dataiku.dip.util.AnyLoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class GraphNode {
    protected List<AnchoredTypedGraphEdge> predecessors = new ArrayList<AnchoredTypedGraphEdge>();
    protected List<AnchoredTypedGraphEdge> successors = new ArrayList<AnchoredTypedGraphEdge>();

    public abstract String getFullId();

    public String getRef(String contextProjectKey) {
        return AnyLoc.resolveFull(this.getFullId()).getSmartName(contextProjectKey);
    }

    public List<? extends GraphNode> getPredecessors() {
        return Collections.unmodifiableList(this.predecessors.stream().map(x -> x.node).collect(Collectors.toList()));
    }

    public List<? extends GraphNode> getSuccessors() {
        return Collections.unmodifiableList(this.successors.stream().map(x -> x.node).collect(Collectors.toList()));
    }

    public <N extends GraphNode> void addPredecessor(N p, String role) {
        this.predecessors.add(new AnchoredTypedGraphEdge(p, role));
    }

    public void clearPredecessors() {
        this.predecessors = new ArrayList<AnchoredTypedGraphEdge>();
    }

    public void addSuccessor(GraphNode s, String role) {
        this.successors.add(new AnchoredTypedGraphEdge(s, role));
    }

    public void clearSuccessors() {
        this.successors = new ArrayList<AnchoredTypedGraphEdge>();
    }

    public abstract String getGraphId();

    public static class AnchoredTypedGraphEdge {
        GraphNode node;
        String role;

        public AnchoredTypedGraphEdge() {
        }

        public AnchoredTypedGraphEdge(GraphNode node, String role) {
            this.node = node;
            this.role = role;
        }
    }
}

