/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming.slave;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.dataflow.JobKernelUtils;
import com.dataiku.dip.dataflow.streaming.slave.CAKServlet;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DSSCAKernelMain {
    private static int port = 0;
    private static String host = "127.0.0.1";
    private static Logger logger = Logger.getLogger((String)"dku.streaming.kernel");

    public static void main(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.CAK);
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.CAK);
        ClusterSelector.setContext(MainLoggingConfigurator.ProcessType.CAK);
        System.setProperty("h2.bindAddress", "127.0.0.1");
        String id = args[0];
        logger.info((Object)("CA kernel " + id + " starting, process: " + ManagementFactory.getRuntimeMXBean().getName()));
        BuiltinsLoader.load();
        CLISetup.doCAKSetup();
        logger.info((Object)"Classes loaded, starting server");
        MainLoggingConfigurator.configureLimits();
        HadoopLoader.initializeSecurity(ApplicationConfigurator.getGeneralSettings().hadoopSettings, true, false);
        ScriptStep.loadClass();
        new Thread("stdin-watcher"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        if (System.in.read() != -1) {
                            continue;
                        }
                        logger.warn((Object)"Standard input closed, exiting");
                        System.exit(0);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Error reading standard input, exiting", (Throwable)e);
                    System.exit(1);
                    return;
                }
            }
        }.start();
        Supplier<HttpServlet> servletProducer = () -> {
            CAKServlet ks = new CAKServlet(SharedSecretUtils.getSharedSecret((boolean)false));
            SpringUtils.getInstance().autowire((Object)ks);
            return ks;
        };
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        Server server = null;
        if (!dssPortRange.enabled) {
            server = JobKernelUtils.createServerWithServlet(0, servletProducer, "/cak/*");
            server.start();
        } else {
            assert (dssPortRange.isValid()) : "Port range not defined properly";
            boolean portFound = false;
            Iterator iterator = dssPortRange.getRange().iterator();
            while (iterator.hasNext()) {
                int portCandidate = (Integer)iterator.next();
                server = JobKernelUtils.createServerWithServlet(portCandidate, servletProducer, "/cak/*");
                try {
                    server.start();
                    portFound = true;
                    break;
                }
                catch (IOException e) {
                    logger.info((Object)String.format("Task can't use port %d", portCandidate), (Throwable)e);
                }
            }
            if (!portFound) {
                throw new BindException(String.format("Task failed to find usable port in range [%d, %d]", dssPortRange.start, dssPortRange.end));
            }
        }
        port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
        host = RemoteRunNetworkingUtils.getBackendHost();
        RemoteRunNetworkingUtils.setServer(MainLoggingConfigurator.ProcessType.CAK, port);
        logger.info((Object)("Kernel started on port " + port + ", registering it"));
        try {
            LocalBackendPrivilegedIntercomAPIClient apiClient = new LocalBackendPrivilegedIntercomAPIClient();
            apiClient.postFormToJSON("/dip/api/pintercom/jobs/continuous-kernel-register", Void.class, new Object[]{"kernelId", id, "port", port});
            apiClient.close();
            logger.info((Object)"Registration OK, kernel is now ready");
        }
        catch (Exception e) {
            logger.info((Object)"Registration failed, aborting", (Throwable)e);
            System.exit(1);
        }
        server.join();
    }

    public static int getKernelPort() {
        if (port == 0) {
            throw new RuntimeException("You're not in a CAK, or the CAK has not been correctly initialized");
        }
        return port;
    }

    public static void setPortDEBUGONLY(int _port) {
        port = _port;
    }

    public static String getKernelHost() {
        if (StringUtils.isBlank((String)host)) {
            throw new RuntimeException("You're not in a CAK, or the CAK has not been correctly initialized");
        }
        return host;
    }

    public static void setHostDEBUGONLY(String _host) {
        host = _host;
    }
}

