/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.SortingRow;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class SimpleRowsFileWriter
implements AutoCloseable {
    private final List<Column> columns;
    private final ByteBuffer lengthBuffer;
    private final ByteBuffer writeBuffer;
    private final FileChannel fc;
    private boolean closed = false;
    private long writeStartPosition;

    public SimpleRowsFileWriter(FileChannel fc, List<Column> columns) {
        this.fc = fc;
        this.columns = columns;
        this.lengthBuffer = ByteBuffer.allocate(4 * (columns.size() + 1));
        this.writeBuffer = ByteBuffer.allocateDirect(0x100000);
    }

    public long position() throws IOException {
        this.flush();
        return this.fc.position();
    }

    private void flush() throws IOException {
        this.writeBuffer.flip();
        this.fc.write(this.writeBuffer);
        this.writeBuffer.clear();
    }

    private void writeBuffer(ByteBuffer buffer) throws IOException {
        this.writeStartPosition += (long)buffer.array().length;
        while (buffer.hasRemaining()) {
            if (!this.writeBuffer.hasRemaining()) {
                this.flush();
            }
            int toWrite = Math.min(buffer.remaining(), this.writeBuffer.remaining());
            this.writeBuffer.put(buffer.array(), buffer.position(), toWrite);
            buffer.position(buffer.position() + toWrite);
        }
    }

    public long write(Row row) throws IOException {
        long startPosition = this.writeStartPosition;
        ArrayList values = Lists.newArrayList();
        if (row instanceof SortingRow) {
            for (String value : ((SortingRow)row).getValues()) {
                if (value == null) {
                    values.add(new byte[0]);
                    continue;
                }
                values.add(value.getBytes(StandardCharsets.UTF_8));
            }
        } else {
            for (Column column : this.columns) {
                if (row.empty(column)) {
                    values.add(new byte[0]);
                    continue;
                }
                values.add(row.get(column).getBytes(StandardCharsets.UTF_8));
            }
        }
        int totalSize = this.lengthBuffer.capacity();
        for (byte[] value : values) {
            totalSize += value.length;
        }
        this.lengthBuffer.clear();
        this.lengthBuffer.putInt(totalSize);
        for (byte[] value : values) {
            this.lengthBuffer.putInt(value.length);
        }
        this.lengthBuffer.flip();
        this.writeBuffer(this.lengthBuffer);
        for (byte[] value : values) {
            ByteBuffer wrappedValue = ByteBuffer.wrap(value);
            this.writeBuffer(wrappedValue);
        }
        return startPosition;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.fc.force(true);
            this.fc.close();
            this.closed = true;
        }
    }
}

