/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;

public class DynamoDBDatasetMeta
extends DatasetHandler.NonFSMeta<DynamoDBDatasetHandler, DynamoDBDatasetHandler.Config> {
    @Override
    public String getType() {
        return "DynamoDB";
    }

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return DynamoDBDatasetHandler.Config.class;
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        return new DynamoDBDatasetHandler(authCtx, dataset);
    }

    @Override
    public boolean isFSLike() {
        return false;
    }

    @Override
    public boolean isFS() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isParallelWritable() {
        return false;
    }

    @Override
    public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) throws CodedException {
        dataset.setType(this.getType());
        dataset.setManaged(true);
        DynamoDBDatasetHandler.Config config = new DynamoDBDatasetHandler.Config();
        config.table = dataset.getName();
        config.connection = targetConnection.name;
        dataset.setParams(config);
    }
}

