/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DynamoDBTypeConverter {
    private final StorageTypeVerifier storageTypeVerifier = new StorageTypeVerifier();
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.dynamodb.dynamodbutils");

    public void addValueToDynamoDBItemAttributes(Map<String, AttributeValue> itemAttributes, String colName, String v, SchemaColumn sc, StorageTypeVerifier.DataTypeMismatchBehavior writeMismatchBehavior, WarningsContext wc) {
        if (StringUtils.isBlank((String)(v = this.storageTypeVerifier.verify(v, sc, writeMismatchBehavior, wc, null)))) {
            return;
        }
        itemAttributes.put(colName, this.toAttributeValue(sc, v));
    }

    private AttributeValue toAttributeValue(SchemaColumn schemaColumn, String value) {
        Type type = schemaColumn.getType();
        switch (type) {
            case ARRAY: {
                try {
                    JSONArray jsonArray = new JSONArray(value);
                    ArrayList<AttributeValue> values = new ArrayList<AttributeValue>();
                    for (Object v : jsonArray) {
                        if (v == null || v == JSONObject.NULL) {
                            values.add(AttributeValue.fromNul((Boolean)true));
                            continue;
                        }
                        values.add(this.toAttributeValue(schemaColumn.arrayContent, v.toString()));
                    }
                    return AttributeValue.fromL(values);
                }
                catch (JSONException e) {
                    logger.info((Object)("Failed to parse String to JSON Array : " + String.valueOf((Object)e)));
                    return AttributeValue.fromS((String)value);
                }
            }
            case BOOLEAN: {
                return AttributeValue.fromBool((Boolean)Boolean.valueOf(value));
            }
            case OBJECT: {
                try {
                    JSONObject jsonObject = new JSONObject(value);
                    LinkedHashMap<String, AttributeValue> values = new LinkedHashMap<String, AttributeValue>();
                    for (SchemaColumn objectColumn : schemaColumn.objectFields) {
                        if (!jsonObject.has(objectColumn.getName())) continue;
                        Object o = jsonObject.get(objectColumn.getName());
                        if (o == null || o == JSONObject.NULL) {
                            values.put(objectColumn.getName(), AttributeValue.fromNul((Boolean)true));
                            continue;
                        }
                        values.put(objectColumn.getName(), this.toAttributeValue(objectColumn, o.toString()));
                    }
                    return AttributeValue.fromM(values);
                }
                catch (JSONException e) {
                    logger.info((Object)("Failed to parse String to JSON Object : " + String.valueOf((Object)e)));
                    return AttributeValue.fromS((String)value);
                }
            }
            case MAP: {
                try {
                    JSONObject jsonObject = new JSONObject(value);
                    LinkedHashMap<String, AttributeValue> values = new LinkedHashMap<String, AttributeValue>();
                    for (Map.Entry entry : jsonObject.toMap().entrySet()) {
                        if (entry.getValue() == null || entry.getValue() == JSONObject.NULL) {
                            values.put((String)entry.getKey(), AttributeValue.fromNul((Boolean)true));
                            continue;
                        }
                        values.put((String)entry.getKey(), this.toAttributeValue(schemaColumn.mapValues, entry.getValue().toString()));
                    }
                    return AttributeValue.fromM(values);
                }
                catch (JSONException e) {
                    logger.info((Object)("Failed to parse String to JSON Object : " + String.valueOf((Object)e)));
                    return AttributeValue.fromS((String)value);
                }
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new IllegalArgumentException("Geometry columns are not supported for DynamoDB mapping");
            }
            case DOUBLE: 
            case FLOAT: 
            case BIGINT: 
            case INT: 
            case TINYINT: 
            case SMALLINT: {
                return AttributeValue.fromN((String)value);
            }
        }
        return AttributeValue.fromS((String)value);
    }

    public String toDynamoType(Type t) {
        switch (t) {
            case DATE: 
            case DATEONLY: 
            case DATETIMENOTZ: 
            case STRING: {
                return "S";
            }
            case ARRAY: {
                return "L";
            }
            case BOOLEAN: {
                return "BOOL";
            }
            case OBJECT: 
            case MAP: {
                return "M";
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new IllegalArgumentException("Geometry column are not supported for DynamoDB mapping");
            }
            case DOUBLE: 
            case FLOAT: 
            case BIGINT: 
            case INT: 
            case TINYINT: 
            case SMALLINT: {
                return "N";
            }
        }
        return "S";
    }

    public JsonElement getDynamoValue(AttributeValue v, SchemaColumn schemaColumn, StorageTypeVerifier.DataTypeMismatchBehavior behav, WarningsContext wc) {
        JsonPrimitive ret = null;
        if (v == null || v.nul() != null || v.b() != null || v.hasBs()) {
            return JsonNull.INSTANCE;
        }
        if (v.s() != null) {
            ret = new JsonPrimitive(v.s());
        } else if (v.n() != null) {
            try {
                ret = new JsonPrimitive((Number)new BigInteger(v.n()));
            }
            catch (NumberFormatException e) {
                ret = new JsonPrimitive((Number)Float.valueOf(v.n()));
            }
        } else if (v.bool() != null) {
            ret = new JsonPrimitive(v.bool());
        } else if (v.hasNs()) {
            ret = new JsonArray();
            for (String str : v.ns()) {
                Number val;
                try {
                    val = new BigInteger(str);
                }
                catch (NumberFormatException e) {
                    val = Float.valueOf(str);
                }
                ret.getAsJsonArray().add((JsonElement)new JsonPrimitive(val));
            }
        } else if (v.hasSs()) {
            ret = new JsonArray();
            for (String str : v.ss()) {
                ret.getAsJsonArray().add((JsonElement)new JsonPrimitive(str));
            }
        } else if (v.hasL()) {
            ret = new JsonArray();
            for (AttributeValue value : v.l()) {
                ret.getAsJsonArray().add(this.getDynamoValue(value, null, null, null));
            }
        } else if (v.hasM()) {
            Map map = v.m();
            ret = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                ret.getAsJsonObject().add((String)entry.getKey(), this.getDynamoValue((AttributeValue)entry.getValue(), null, null, null));
            }
        }
        if (schemaColumn != null && wc != null && ret instanceof JsonPrimitive) {
            String newVal = this.storageTypeVerifier.verify(ret.getAsJsonPrimitive().getAsString(), schemaColumn, behav, wc, null);
            if (StringUtils.isBlank((String)newVal)) {
                return JsonNull.INSTANCE;
            }
            return new JsonPrimitive(newVal);
        }
        return ret;
    }
}

