/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.formats.delta.DeltaReader;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.IsolatedClassLoaderBuilder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;

public abstract class AbstractHDFSableDatasetHandler
extends AbstractFSDatasetHandler
implements HDFSableDatasetHandler {
    private URLClassLoader deltaClassLoader = null;

    public AbstractHDFSableDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    public void close() throws IOException {
        if (this.deltaClassLoader != null) {
            this.deltaClassLoader.close();
            this.deltaClassLoader = null;
        }
        super.close();
    }

    @Override
    public boolean isParallelReadable() {
        return !DeltaFormat.META.getType().equals(this.dataset.getFormatType());
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.throwNotSupportedIfRepeating();
        if (DeltaFormat.META.getType().equals(this.dataset.getFormatType())) {
            return this.buildDeltaSplit(partition, true);
        }
        return super.getPartitionSplit(partition);
    }

    @Override
    public InputSplit getSampleSplit() throws Exception {
        if (DeltaFormat.META.getType().equals(this.dataset.getFormatType())) {
            this.throwNotSupportedIfRepeating();
            if (this.useSparkBasedDeltaRead()) {
                return new DeltaReader.SampleSplit(this.authCtx, this);
            }
            return this.buildDeltaSplit(Partition.newNP(), false);
        }
        return super.getSampleSplit();
    }

    @Override
    public InputSplit getSingleSplit() throws Exception {
        if (DeltaFormat.META.getType().equals(this.dataset.getFormatType())) {
            this.throwNotSupportedIfRepeating();
            if (this.useSparkBasedDeltaRead()) {
                return new DeltaReader.GlobalSplit(this.authCtx, this);
            }
            return this.buildDeltaSplit(Partition.newNP(), true);
        }
        return super.getSingleSplit();
    }

    private boolean useSparkBasedDeltaRead() {
        return this.dataset.getDkuPropertiesAsParams().getBoolParam("spark.based.delta.read", false);
    }

    private InputSplit buildDeltaSplit(Partition p, boolean useDatasetSchema) throws IOException {
        this.builDeltaClassLoaderIfNeeded();
        try {
            Class<?> clazz = this.deltaClassLoader.loadClass("com.dataiku.dip.formats.delta.DeltaSplit");
            Object split = clazz.getConstructor(HDFSableDatasetHandler.class, Partition.class, Boolean.TYPE).newInstance(this, p, useDatasetSchema);
            return (InputSplit)split;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException("Unable to load delta reader", e);
        }
    }

    private void builDeltaClassLoaderIfNeeded() throws IOException {
        if (this.deltaClassLoader == null) {
            this.deltaClassLoader = new IsolatedClassLoaderBuilder().withFallThroughPackages(Lists.newArrayList((Object[])new String[]{"org.apache.hadoop", "com.dataiku", "org.slf4j"})).withNonFallThroughPackages(Lists.newArrayList((Object[])new String[]{"com.dataiku.dip.formats.delta"})).withJarsInRecursiveDir(ApplicationConfigurator.getInstallFile((String[])new String[]{"lib", "ivy", "delta-run"})).withJarFile(ApplicationConfigurator.getInstallFile((String[])new String[]{"dist", "dataiku-delta.jar"})).build();
        }
    }

    public PartitioningScheme getDeltaPartitioning() throws IOException {
        this.builDeltaClassLoaderIfNeeded();
        try {
            Class<?> clazz = this.deltaClassLoader.loadClass("com.dataiku.dip.formats.delta.DeltaPartitioning");
            Object partitioning = clazz.getConstructor(HDFSableDatasetHandler.class).newInstance(this);
            Method readPartitioningScheme = clazz.getMethod("readPartitioningScheme", new Class[0]);
            return (PartitioningScheme)readPartitioningScheme.invoke(partitioning, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException("Unable to load delta metadata", e);
        }
    }
}

