/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractHDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.BlobLikeResplitOutput;
import com.dataiku.dip.datasets.fs.BlobLikeSingleFileOutputWriter;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.input.formats.CompressibleFormatParams;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileOutput;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileOutput;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatConfig;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatMeta;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileOutput;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetOutput;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public abstract class BlobLikeDatasetHandler<Config extends AbstractFSDatasetHandler.AbstractFSConfig>
extends AbstractHDFSableDatasetHandler
implements FSDatasetBrowseService.BrowsableHandler {
    protected final Config config;
    protected final Config resolvedConfig;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.bloblike");

    public BlobLikeDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        this.config = (AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParams();
        this.resolvedConfig = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.deepCopy(this.config);
        ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).path = VariablesUtils.expand(dataset.getProjectKey(), ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).path, authCtx);
    }

    public BlobLikeFSProvider getTypedProvider() throws IOException, DKUSecurityException, CodedException {
        return (BlobLikeFSProvider)this.getProvider();
    }

    @Override
    public String getFullyQualifiedPartitionPath(Partition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getFullyQualifiedRootPath() + this.getPartitionRelPath(partition);
    }

    @Override
    public String getEffectiveDatasetRootWithinAuthority() throws IOException, DKUSecurityException, CodedException {
        return this.getTypedProvider().getRootWithinBucket();
    }

    @Override
    public void addExtraConf(Configuration config, boolean keepDefaultFS) throws IOException, DKUSecurityException {
        for (AbstractSQLConnection.CustomDatabaseProperty kv : this.getHDFSExtraConf()) {
            config.set(kv.name, kv.value);
        }
    }

    protected abstract List<AbstractSQLConnection.CustomDatabaseProperty> getHDFSExtraConf() throws IOException, DKUSecurityException;

    @Override
    public List<SimpleKeyValue> getFSExtraConf() throws IOException, DKUSecurityException {
        ArrayList ret = Lists.newArrayList();
        for (AbstractSQLConnection.CustomDatabaseProperty cdp : this.getHDFSExtraConf()) {
            ret.add(new SimpleKeyValue(cdp.name, cdp.value));
        }
        return ret;
    }

    protected HDFSProvider getAsHDFSProvider() throws IOException, DKUSecurityException, CodedException, InterruptedException {
        HDFSConnection connection = new HDFSConnection();
        connection.params.aclSynchronizationMode = HDFSConnection.ACLSynchronizationMode.NONE;
        connection.params.clearMode = HDFSConnection.ClearMode.DSS_USER;
        connection.params.setRoot(this.getFullyQualifiedRootPath());
        connection.params.setExtraConf(this.getHDFSExtraConf());
        return new HDFSProvider(this.authCtx, connection, "/", this.dataset.getProjectKey());
    }

    public abstract DSSConnection getConnection();

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException, CodedException {
        this.getProvider();
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
        if (this.isSingleFile()) {
            throw new IOException(" Blob already exists !");
        }
    }

    @Override
    public void clearAllData() throws Exception {
        logger.info((Object)"Clear all data");
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).connection);
        this.checkClearIsNotDangerous();
        BlobLikeFSProvider provider = this.getTypedProvider();
        if (this.isManaged()) {
            if (provider.stat("/") != null) {
                this.getProvider().deleteRecursive("/");
            }
        } else if (this.isSingleFile()) {
            this.getProvider().write(this.getSingleFile()).close();
        } else if (provider.stat("/") != null) {
            this.getProvider().deleteRecursive("/");
        }
        this.invalidateRootEnumerationCache();
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"Clear partitions");
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).connection);
        BlobLikeFSProvider provider = this.getTypedProvider();
        PartitioningScheme scheme = this.dataset.getPartitioningSchema();
        if (scheme != null && (!scheme.isPartitioned() || FilePartitioner.isSchemeRepresentableAsFolder(scheme))) {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as a folder : '" + p.id() + "'"));
                String partitionPath = FilePartitioner.computePartitionRelPathAsFolder(p, this.dataset.getPartitioningSchema());
                this.clearPartitionPath(provider, partitionPath);
                logger.info((Object)("Done clearing partition '" + p.id() + "'"));
            }
        } else {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as set of paths : '" + p.id() + "'"));
                List<FSPath> paths = this.enumeratePartition(p, this.getEnumerationSettings());
                this.clearPartitionPaths(provider, paths);
                logger.info((Object)("Done clearing partition '" + p.id() + "'"));
            }
        }
        this.invalidateRootEnumerationCache();
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, final WarningsContext warningsContext) throws Exception {
        String compress;
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).connection);
        if (this.dataset.getFormatType().equals(DeltaFormat.META.getType())) {
            throw new UnsupportedOperationException("Delta format can only be written with the Spark engine");
        }
        if (this.dataset.getFormatType().equals(ParquetFormatMeta.META.getType())) {
            return new ParquetOutput(this.getAsHDFSProvider(), this.getDataset(), targetPartition, targetSplit, warningsContext, this.dataset.getFormatParamsAs(ParquetFormatConfig.class));
        }
        if (this.dataset.getFormatType().equals(SequenceFileFormatMeta.META.getType())) {
            return new SequenceFileOutput(this.getAsHDFSProvider(), this.getDataset(), targetPartition, targetSplit, this.dataset.getFormatParamsAs(SequenceFileFormatConfig.class), warningsContext);
        }
        if (this.dataset.getFormatType().equals(RCFileFormatMeta.META.getType())) {
            return new RCFileOutput(this.getAsHDFSProvider(), this.getDataset(), targetPartition, targetSplit, this.dataset.getFormatParamsAs(RCFileFormatConfig.class), warningsContext);
        }
        if (this.dataset.getFormatType().equals(ORCFileFormatMeta.META.getType())) {
            return new ORCFileOutput(this.getAsHDFSProvider(), this.getDataset(), targetPartition, targetSplit, this.dataset.getFormatParamsAs(ORCFileFormatConfig.class), warningsContext);
        }
        String string = compress = this.dataset.getFormatParams() instanceof CompressibleFormatParams ? ((CompressibleFormatParams)this.dataset.getFormatParams()).compress : "";
        if (this.isSingleFile()) {
            final String path = this.getSingleFile();
            return new Output(){

                public OutputWriter getWriter(Output.WriteMode mode) throws IOException, CodedException, DKUSecurityException {
                    return new BlobLikeSingleFileOutputWriter(BlobLikeDatasetHandler.this.authCtx, BlobLikeDatasetHandler.this.dataset.getProjectKey(), BlobLikeDatasetHandler.this.getTypedProvider(), path, BlobLikeDatasetHandler.this.dataset.getFormatType(), BlobLikeDatasetHandler.this.dataset.getFormatParams(), BlobLikeDatasetHandler.this.dataset.getSchema(), warningsContext, mode, compress);
                }
            };
        }
        String prefix = targetPartition == null ? "/" : FilePartitioner.computePartitionRelPathAsFolder(targetPartition, this.dataset.getPartitioningSchema());
        return new BlobLikeResplitOutput(this.authCtx, this.dataset.getProjectKey(), this.getTypedProvider(), prefix, targetSplit, resplitFactor, this.dataset.getFormatType(), this.dataset.getFormatParams(), this.dataset.getSchema(), warningsContext, compress, this.dataset.getModel().readWriteOptions);
    }

    @Override
    public FSEnumerationSettings getEnumerationSettings() {
        FSEnumerationSettings enumerationSettings = new FSEnumerationSettings();
        enumerationSettings.selectionRules = (FilesSelectionRules)JSON.deepCopy((Object)((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).filesSelectionRules);
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForProjectAndUser(this.authCtx, this.dataset.getProjectKey());
        FSEnumerationSettings.expandSelectionRulesInPlace((FilesSelectionRules)enumerationSettings.selectionRules, (VariablesContext)vc);
        logger.trace(() -> "Variable-expanded selection rules: " + JSON.json((Object)enumerationSettings.selectionRules));
        return enumerationSettings;
    }

    @Override
    public FSPath getFirstNonEmptyPath() throws Exception {
        logger.info((Object)"Finding first non empty path in dataset");
        if (this.isSingleFile()) {
            FSPathOrDirectory status = this.getProvider().stat("/" + this.getSingleFile());
            return status != null && status.getSize() > 0L ? status : null;
        }
        JsonObject jo = VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(this.authCtx, this.dataset.getProjectKey(), this.dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).variablesExpansionLoopConfig, "Driving dataset is empty, cannot find file for preview");
        try (AutoCloseable ignored = DynamicLevelsStack.withLevel(jo);){
            FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
            enumerationSettings.firstNonEmpty = true;
            FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive("/", enumerationSettings);
            if (!enumerationResult.isSuccessful() || !enumerationResult.enumerationPrefixExists()) {
                FSPath fSPath = null;
                return fSPath;
            }
            Iterator paths = enumerationResult.getPaths().iterator();
            FSPath fSPath = paths.hasNext() ? (FSPath)paths.next() : null;
            return fSPath;
        }
    }

    @Override
    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        logger.info((Object)("Enumerating blob-like dataset " + this.dataset.getFullName() + " prefix=" + prefix + " settings=" + JSON.json((Object)enumerationSettings)));
        if (this.isSingleFile()) {
            FSPathOrDirectory file = this.getProvider().stat(this.getSingleFile());
            return file == null ? null : Lists.newArrayList((Object[])new FSPath[]{file});
        }
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive(prefix, enumerationSettings);
        if (!enumerationResult.isSuccessful()) {
            throw new DataStoreIOException("Failed to list files", enumerationResult.getError());
        }
        if (!enumerationResult.enumerationPrefixExists()) {
            if (StringUtils.isBlank((String)prefix)) {
                throw new DataStoreIOException("Root path of the dataset does not exist").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_ROOT_PATH_DOES_NOT_EXIST);
            }
            throw new DataStoreIOException("Path does not exist in the dataset: '" + prefix + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_PATH_DOES_NOT_EXIST);
        }
        return Lists.newArrayList((Iterable)enumerationResult.getPaths());
    }

    @Override
    public EnrichedInputStream getStream(FSPath path, FilePartition partition) throws IOException, DKUSecurityException, CodedException, InterruptedException {
        EnrichedInputStream ret = null;
        String formatType = StringUtils.defaultIfBlank((String)this.dataset.getFormatType(), (String)"");
        ret = formatType.equals(ParquetFormatMeta.META.getType()) || formatType.equals(SequenceFileFormatMeta.META.getType()) || formatType.equals(RCFileFormatMeta.META.getType()) || formatType.equals(ORCFileFormatMeta.META.getType()) ? (this.isSingleFile() ? this.getAsHDFSProvider().read(this.getSingleFile()) : this.getAsHDFSProvider().read(path.path())) : (this.isSingleFile() ? this.getProvider().read(this.getSingleFile()) : this.getProvider().read(path.path()));
        if (ret != null) {
            ret.setPartition((Partition)partition);
        }
        return ret;
    }

    @Override
    public FSBrowsePath browse(String prefix) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (this.isSingleFile()) {
            return this.getProvider().browse("/" + this.getSingleFile(), FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
        }
        return this.getProvider().browse(prefix, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
    }
}

