/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomFSProviderDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private static Logger logger = Logger.getLogger((String)"dku.datasets.customfsprovider.test");

    public CustomFSProviderDatasetTestHandler(AuthCtx authCtx, Dataset dataset, CustomFSProviderDatasetHandler<?> handler) {
        super(authCtx, handler, handler, dataset);
    }

    public StreamsInputSplit getMultiFileSampleSplit() throws Exception {
        return this.handlerForData.getGlobalSplit();
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws Exception {
        CustomFSProviderDatasetParams config = this.dataset.getParamsAs(CustomFSProviderDatasetParams.class);
        try {
            if (StringUtils.isBlank((String)config.path)) {
                throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Path not specified");
            }
            InputSplit sampleSplit = this.handlerForData.getSampleSplit();
            if (sampleSplit instanceof StreamsInputSplit) {
                ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
            }
            ret.connectionOK = true;
            return sampleSplit;
        }
        catch (Exception e) {
            logger.info((Object)"Failed to open dataset", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return FSDatasetUtils.checkDatasetName(newDatasetName);
    }
}

