/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.streamwrite.CurrentTimestampTargetPartitionComputer;
import com.dataiku.dip.datasets.streamwrite.FSBasedStreamWriter;
import com.dataiku.dip.datasets.streamwrite.TargetPartitionComputer;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiPartitionsFSBasedStreamWriter
extends FSBasedStreamWriter {
    private Map<String, FSBasedStreamWriter.FSBasedOpenOutputPartition> openPartitions = new HashMap<String, FSBasedStreamWriter.FSBasedOpenOutputPartition>();
    private final TargetPartitionComputer targetPartitionComputer;
    private final CurrentTimestampTargetPartitionComputer.ComputationTimezone computationTimezone = CurrentTimestampTargetPartitionComputer.ComputationTimezone.LOCAL;
    private static Logger logger = Logger.getLogger((String)"dip.stream.multipartition.fs.writer");

    public MultiPartitionsFSBasedStreamWriter(AuthCtx authCtx, AbstractFSDatasetHandler outputDH, String sourceId, int splitId) throws Exception {
        super(authCtx, outputDH, sourceId, splitId);
        this.targetPartitionComputer = new CurrentTimestampTargetPartitionComputer(outputDH.getDataset().getPartitioningSchema(), this.computationTimezone);
        this.detectFailureAndRecover(sourceId);
    }

    private FSBasedStreamWriter.FSBasedOpenOutputPartition getOrOpenPartition(String partitionId) throws Exception {
        FSBasedStreamWriter.FSBasedOpenOutputPartition oop = this.openPartitions.get(partitionId);
        if (oop != null) {
            return oop;
        }
        oop = new FSBasedStreamWriter.FSBasedOpenOutputPartition();
        oop.setupNewOpenOutputPartition(partitionId);
        this.openPartitions.put(partitionId, oop);
        return oop;
    }

    @VisibleForTesting
    void append(Row row, final String ts) throws Exception {
        CurrentTimestampTargetPartitionComputer.nowProvider = new CurrentTimestampTargetPartitionComputer.NowProvider(){

            @Override
            public long now() {
                return DKUDateUtils.parseISOLocal((String)ts);
            }
        };
        this.append(row);
    }

    @Override
    public void append(Row row) throws Exception {
        String partitionId = this.targetPartitionComputer.compute(row);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will write row to " + partitionId));
        }
        FSBasedStreamWriter.FSBasedOpenOutputPartition oop = this.getOrOpenPartition(partitionId);
        oop.writer.emitRow(row);
    }

    @Override
    protected void closeOpenPartitions() throws Exception {
        for (FSBasedStreamWriter.FSBasedOpenOutputPartition oop : this.openPartitions.values()) {
            oop.lastRowEmitted();
        }
        this.openPartitions.clear();
    }

    @Override
    protected void cancelOpenPartitions() throws Exception {
        for (FSBasedStreamWriter.FSBasedOpenOutputPartition oop : this.openPartitions.values()) {
            oop.cancel();
        }
        this.openPartitions.clear();
    }

    @Override
    protected JsonElement gatherWritesInProgress() throws IOException, InterruptedException {
        ArrayList paths = Lists.newArrayList();
        for (FSBasedStreamWriter.FSBasedOpenOutputPartition oop : this.openPartitions.values()) {
            if (oop == null || !(oop.output instanceof CanListFilesWrittenTo)) continue;
            paths.addAll(((CanListFilesWrittenTo)oop.output).list(oop.writer));
        }
        return JSON.toJsonElement((Object)paths);
    }

    @Override
    protected void clearTempWriteFiles() throws Exception {
        Output output;
        ArrayList paths = Lists.newArrayList();
        if (this.outputDH instanceof AbstractFSDatasetHandler && (output = this.outputDH.buildOutput(Partition.newNP(), this.splitId, 1, new WarningsContext())) instanceof CanListFilesWrittenTo) {
            paths.addAll(((CanListFilesWrittenTo)output).recoverList());
        }
        this.clearTempWriteFiles(paths);
    }
}

