/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.labeling;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.managedfolder.ManagedFolder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class LabelingTaskInputsOutputsIterable<O>
implements FlowPlaceholder.IterablePlaceholder<LabelingTask, O> {
    private final Class<O> outputClazz;
    private final String replacement;
    private final boolean isOutput;

    LabelingTaskInputsOutputsIterable(Class<O> outputClazz, String replacement, boolean isOutput) {
        this.outputClazz = outputClazz;
        this.replacement = replacement;
        this.isOutput = isOutput;
    }

    @Override
    public IterableDescription<LabelingTask, O> getDescription() {
        return IterableDescription.iterablePlaceholder(LabelingTask.class, this.outputClazz, this.replacement);
    }

    protected <T extends FlowComputable> Stream<T> getFlowItemStream(FlowDocumentContext context, LabelingTask labelingTask, Class<T> flowItemClazz) throws PlaceholderExpectedException {
        FlowLabelingTask flt = context.getProjectFlowGraph().getLabelingTask(labelingTask.getProjectKey(), labelingTask.getId());
        List<? extends GraphNode> resultAsNodes = this.isOutput ? flt.getSuccessors() : flt.getPredecessors();
        return resultAsNodes.stream().filter(flowItemClazz::isInstance).map(flowItemClazz::cast);
    }

    public static class Folders
    extends LabelingTaskInputsOutputsIterable<ManagedFolder> {
        public Folders(boolean isOutput) {
            super(ManagedFolder.class, "$folder", isOutput);
        }

        @Override
        public Collection<ManagedFolder> resolve(FlowDocumentContext context, LabelingTask labelingTask) throws PlaceholderExpectedException {
            return this.getFlowItemStream(context, labelingTask, FlowManagedFolder.class).map(FlowManagedFolder::getManagedFolder).collect(Collectors.toList());
        }
    }

    public static class Datasets
    extends LabelingTaskInputsOutputsIterable<SerializedDataset> {
        public Datasets(boolean isOutput) {
            super(SerializedDataset.class, "$dataset", isOutput);
        }

        @Override
        public Collection<SerializedDataset> resolve(FlowDocumentContext context, LabelingTask labelingTask) throws PlaceholderExpectedException {
            return context.getSerializedDatasets(this.getFlowItemStream(context, labelingTask, FlowDataset.class).collect(Collectors.toList()));
        }
    }
}

