/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.sampling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.signature.DatasetSignatures;
import com.dataiku.dip.eda.compute.sampling.DataSpec;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public class SampleRequest {
    public final DSSAuthCtx authCtx;
    public final String projectKey;
    public final Dataset dataset;
    public final DataSpec dataSpec;
    public final String containerConfName;
    public final String basicSignature;

    public SampleRequest(DSSAuthCtx authCtx, String projectKey, Dataset dataset, DataSpec dataSpec, String containerConfName) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.dataset = dataset;
        this.dataSpec = dataSpec;
        this.containerConfName = containerConfName;
        this.basicSignature = DatasetSignatures.computeBasicSignature(dataset, (List<String>)dataSpec.datasetSelection.selectedPartitions);
        Preconditions.checkArgument((boolean)Objects.equals(dataset.getLoc(), DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, dataSpec.inputDatasetSmartName)), (Object)"Dataset does not match dataspec");
    }
}

