/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.common.fixers;

import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractHeaderCard;
import com.dataiku.dip.eda.worksheets.cards.common.ColumnCard;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.Fixer;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HeaderCardFixer
extends Fixer {
    private final List<ColumnWithFixer> fixers = new ArrayList<ColumnWithFixer>();

    public void addColumn(Variable column, Fixer fixer) {
        this.fixers.add(new ColumnWithFixer(column, fixer));
    }

    @Override
    public AbstractHeaderCard fix(Card card) {
        AbstractHeaderCard headerCard = (AbstractHeaderCard)card;
        ArrayList<Card> newColumnCards = new ArrayList<Card>();
        for (ColumnWithFixer columnFixer : this.fixers) {
            ColumnCard fixedColumnCard = null;
            if (headerCard.cards != null) {
                for (Card existingColumnCard : headerCard.cards) {
                    if (!(existingColumnCard instanceof ColumnCard)) continue;
                    ColumnCard castedColumnCard = existingColumnCard.as(ColumnCard.class);
                    if (!Objects.equals((Object)castedColumnCard.column, (Object)columnFixer.column)) continue;
                    fixedColumnCard = (ColumnCard)columnFixer.fixer.fix(castedColumnCard);
                }
            }
            if (fixedColumnCard == null) {
                fixedColumnCard = (ColumnCard)columnFixer.fixer.fix(new ColumnCard(columnFixer.column));
            }
            newColumnCards.add(fixedColumnCard);
        }
        return (AbstractHeaderCard)headerCard.withCards(newColumnCards);
    }

    @Override
    public Fixer thenRecursive(Fixer otherFixer) {
        HeaderCardFixer copy = new HeaderCardFixer();
        for (ColumnWithFixer fixer : this.fixers) {
            copy.addColumn(fixer.column, fixer.fixer.thenRecursive(otherFixer));
        }
        return copy.then(otherFixer);
    }

    public static class ColumnWithFixer {
        public final Variable column;
        public final Fixer fixer;

        public ColumnWithFixer(Variable column, Fixer fixer) {
            this.column = column;
            this.fixer = fixer;
        }
    }
}

