/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.queries;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.transformers.Factorizer;
import com.dataiku.dip.eda.compute.computations.transformers.Flattener;
import com.dataiku.dip.eda.compute.computations.transformers.TransformedComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.queries.InteractiveQuery;

public class DebugCard
extends InteractiveQuery {
    public static final String TYPE = "debug_card";
    public Card card;

    @Override
    public InteractiveQuery.InteractiveQueryResult run(Schema schema, ComputationRunner runner) throws Exception {
        CardResult cardResult;
        ComputationResult flattenedComputationResult;
        ComputationResult humanFriendlyComputationResults;
        Card fixedCard = this.card.fixup();
        CompiledCard compiledCard = fixedCard.compile();
        Computation computation = compiledCard.getComputationPlan();
        TransformedComputation flattenedTransformation = new Flattener().transform(computation);
        TransformedComputation humanFriendlyTransformation = new Factorizer().transform(flattenedTransformation.computation);
        Computation humanFriendlyComputation = humanFriendlyTransformation.computation;
        try (ComputationResultSession session = runner.computeAndOpenSession(humanFriendlyComputation);){
            humanFriendlyComputationResults = session.getComputationResult();
            flattenedComputationResult = humanFriendlyTransformation.reconstruct(humanFriendlyComputationResults);
            ComputationResult computationResult = flattenedTransformation.reconstruct(flattenedComputationResult);
            ComputationResultDataStreamer dataStreamer = session.getDataStreamer();
            cardResult = compiledCard.buildResult(computationResult, dataStreamer);
        }
        DebugCardResult queryResult = new DebugCardResult();
        queryResult.computation = humanFriendlyComputation;
        queryResult.computationResult = humanFriendlyComputationResults;
        queryResult.card = fixedCard;
        queryResult.cardResult = cardResult;
        queryResult.estimatedCacheUsageFlattened = flattenedComputationResult.getEstimatedMemoryUsageBytes();
        queryResult.estimatedCacheUsageFactorized = humanFriendlyComputationResults.getEstimatedMemoryUsageBytes();
        return queryResult;
    }

    public static class DebugCardResult
    extends InteractiveQuery.InteractiveQueryResult {
        public long estimatedCacheUsageFlattened;
        public long estimatedCacheUsageFactorized;
        Computation computation;
        ComputationResult computationResult;
        Card card;
        CardResult cardResult;
    }
}

