/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.CustomLoadedExporter;
import com.dataiku.dip.export.ExportDAO;
import com.dataiku.dip.export.ExportFutureThreadBase;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.LocalExportFutureThread;
import com.dataiku.dip.export.RemoteExportFutureThread;
import com.dataiku.dip.export.input.BindableExportInput;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.ExportShaker;
import com.dataiku.dip.export.input.ExportUIDataInput;
import com.dataiku.dip.export.input.RemotableExportInput;
import com.dataiku.dip.export.output.BindableExportOutput;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.export.output.ExportToDataset;
import com.dataiku.dip.export.output.ExportToFile;
import com.dataiku.dip.export.output.ExportToStream;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ExportStateChangedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportService {
    @Autowired
    private ExportDAO exportDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ExportUtils exportUtils;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private APITicketService apiTicketService;
    private Map<String, LocalExportFutureThread> runningLocalExports = new HashMap<String, LocalExportFutureThread>();
    private Set<String> runningExports = new HashSet<String>();
    private static final Logger logger = Logger.getLogger(ExportService.class);

    @PostConstruct
    private void registerHandlers() {
        this.pubSub.subscribe("export-state-change", (DSSEventListener)new DSSEventListener<ExportStateChangedEvent>(){

            public void on(ExportStateChangedEvent evt) {
                switch (evt.status.state) {
                    case COMPUTING_DEPS: 
                    case PENDING: 
                    case NOT_STARTED: 
                    case STARTING: 
                    case PAUSED: 
                    case RUNNING: 
                    case WAITING_CONFIRMATION: {
                        return;
                    }
                }
                logger.info((Object)("Registering export state change final status= " + String.valueOf((Object)evt.status.state)));
                ExportService.this.runningExports.remove(evt.status.exportId);
                ExportService.this.runningLocalExports.remove(evt.status.exportId);
            }
        });
    }

    public synchronized ExportStatus newExport(AuthCtx user, ExportInput input, ExportParams params) throws Exception {
        if (params.destinationType != ExportParams.ExportDestinationType.DATASET) {
            if ((input instanceof ExportDataset || input instanceof ExportShaker) && ApplicationConfigurator.getParams().getBoolParam("dku.exports.disableAllDatasetExports", false)) {
                throw new UnauthorizedException("Dataset exports have been forbidden by your administrator", "dataset-export-forbidden");
            }
            if (!(input instanceof ExportUIDataInput) && ApplicationConfigurator.getParams().getBoolParam("dku.exports.disableAllDataExports", false)) {
                throw new UnauthorizedException("Data exports have been forbidden by your administrator", "dataset-export-forbidden");
            }
            if (ApplicationConfigurator.getParams().getBoolParam("dku.exports.disableAllExports", false)) {
                throw new UnauthorizedException("Exports have been forbidden by your administrator", "dataset-export-forbidden");
            }
        }
        if (params.destinationType == ExportParams.ExportDestinationType.DOWNLOAD && params.filenameBase != null && params.filenameBase.contains("/")) {
            throw new SecurityException("Illegal filename: " + params.filenameBase);
        }
        params.user = user;
        String exportId = ExportDAO.generateExportId(user.getIdentifier());
        ExportStatus status = new ExportStatus();
        ExportStatus.ExportMethod exportMethod = ExportUtils.computeExportMethod(input, params);
        this.customPolicyHooksRegistry.onPreDataExport(user, input, params, exportMethod);
        FutureResponse<ExportFutureThreadBase.ExportResult> realResponse = null;
        boolean inputIsRemoteCompatible = input instanceof ExportDataset || input instanceof ExportShaker;
        boolean outputIsRemoteCompatible = exportMethod == ExportStatus.ExportMethod.CUSTOM_MANAGED || exportMethod == ExportStatus.ExportMethod.CUSTOM_TO_FILE || exportMethod == ExportStatus.ExportMethod.FORMATTER_TO_FILE;
        status.exportId = exportId;
        status.state = JobState.NOT_STARTED;
        status.userId = user.getIdentifier();
        status.inputDescription = input.describe();
        status.params = params;
        status.exportMethod = exportMethod;
        ExportStatus initialStatus = new ExportStatus();
        initialStatus.exportId = exportId;
        initialStatus.state = JobState.NOT_STARTED;
        initialStatus.userId = user.getIdentifier();
        initialStatus.inputDescription = input.describe();
        initialStatus.params = params;
        initialStatus.exportMethod = status.exportMethod;
        this.exportDAO.writeStatus(status);
        this.pubSub.publish(new ExportStateChangedEvent((ExportStatus)JSON.deepCopy((Object)status)));
        if (inputIsRemoteCompatible && outputIsRemoteCompatible) {
            logger.info((Object)("New export (REMOTE): name=" + input.describe().name + " dest=" + String.valueOf((Object)params.destinationType) + " id=" + exportId + " method=" + String.valueOf((Object)exportMethod)));
            RemoteExportJob job = new RemoteExportJob();
            job.input = (RemotableExportInput)input;
            job.params = params;
            job.exportId = exportId;
            job.status = status;
            RemoteExportFutureThread exportThread = new RemoteExportFutureThread(user, job);
            realResponse = this.futureService.runFuture(exportThread, 0L, new TypeToken<FutureResponse<ExportFutureThreadBase.ExportResult>>(){});
        } else {
            logger.info((Object)("New export (LOCAL): name=" + input.describe().name + " dest=" + String.valueOf((Object)params.destinationType) + " id=" + exportId + " method=" + String.valueOf((Object)exportMethod)));
            ExportOutput output = ExportService.buildExportOutput(user, params, exportMethod, status, exportId);
            LocalExportJob job = new LocalExportJob();
            job.status = status;
            job.input = input;
            job.output = output;
            job.ticket = this.apiTicketService.createTicket(user, "export-" + exportId, null);
            logger.info((Object)"Starting LOCAL export thread");
            LocalExportFutureThread exportThread = new LocalExportFutureThread(user, job);
            if (status.exportMethod == ExportStatus.ExportMethod.FORMATTER_STREAM) {
                exportThread.setLogExportReady(false);
            }
            this.runningLocalExports.put(exportId, exportThread);
            this.runningExports.add(exportId);
            realResponse = this.futureService.runFuture(exportThread, 0L, new TypeToken<FutureResponse<ExportFutureThreadBase.ExportResult>>(){});
        }
        if (status.exportMethod == ExportStatus.ExportMethod.FORMATTER_STREAM) {
            WaitForSourceInitializedThread waitThread = new WaitForSourceInitializedThread(user, exportId);
            FutureResponse<String> waitResponse = this.futureService.runFuture(waitThread, 0L, new TypeToken<FutureResponse<String>>(){});
            initialStatus.futureResponse = waitResponse;
            initialStatus.realFutureResponse = realResponse;
            initialStatus.futureId = waitResponse.jobId;
            initialStatus.realFutureId = realResponse.jobId;
            status.futureId = realResponse.jobId;
        } else {
            initialStatus.futureResponse = realResponse;
            initialStatus.futureId = realResponse.jobId;
            status.futureId = realResponse.jobId;
        }
        return initialStatus;
    }

    private static void fillTargetPath(ExportStatus status, ExportParams params, String exportId, CustomLoadedExporter<?> exporter) {
        if (status.targetFile != null) {
            return;
        }
        File destDir = ((ExportDAO)SpringUtils.getBean(ExportDAO.class)).exportDataDir(exportId);
        MimeTypeUtils.MimeType mt = exporter != null ? exporter.getMimeType(params) : ((ExportUtils)SpringUtils.getBean(ExportUtils.class)).computeMimeType(params);
        String filename = exportId + mt.extension;
        status.targetFile = DKUFileUtils.getWithin((File)destDir, (String[])new String[]{filename}).getAbsolutePath();
    }

    public synchronized void bindInput(String exportId, ExportInput input) throws Exception {
        ExportInput currentInput;
        LocalExportJob job = this.getRunningJobOrNull(exportId);
        if (job != null && (currentInput = job.input) instanceof BindableExportInput) {
            BindableExportInput bindable = (BindableExportInput)currentInput;
            bindable.bind(input);
            logger.info((Object)("Bound export input [" + exportId + "]"));
            return;
        }
        throw new Exception("Unable to bind export " + exportId);
    }

    private synchronized BindableExportOutput bindOutput(String exportId, ExportOutput output) throws Exception {
        ExportOutput currentOutput;
        LocalExportJob job = this.getRunningJobOrNull(exportId);
        if (job != null && (currentOutput = job.output) instanceof BindableExportOutput) {
            BindableExportOutput bindableExportOutput = (BindableExportOutput)currentOutput;
            bindableExportOutput.bind(output);
            logger.info((Object)("Bound export output [" + exportId + "]"));
            return bindableExportOutput;
        }
        throw new Exception("Unable to bind export " + exportId);
    }

    private synchronized LocalExportJob getRunningJobOrNull(String exportId) {
        LocalExportFutureThread exportThread = this.getExportThread(exportId);
        if (exportThread != null) {
            return exportThread.getJob();
        }
        return null;
    }

    public ExportStatus waitForExport(String exportId) throws InterruptedException, IOException {
        ExportStatus status;
        do {
            Thread.sleep(2000L);
            status = this.exportDAO.getStatus(exportId);
        } while (status.state != JobState.ABORTED && status.state != JobState.FAILED && status.state != JobState.DONE);
        return status;
    }

    private boolean waitForSource(String exportId) throws IOException, InterruptedException {
        LocalExportFutureThread exportThread = this.getExportThread(exportId);
        return exportThread.waitForSource();
    }

    public static FuturePayload buildFuturePayload(String exportId) {
        FuturePayload fp = new FuturePayload();
        fp.action = "export";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(exportId, "EXPORT"));
        fp.displayName = "Waiting for export " + exportId + " to initialize";
        return fp;
    }

    public long handleDownloadRequest(String exportId, HttpServletResponse resp, AuthCtx user) throws Exception {
        ExportStatus status = this.exportDAO.getStatus(exportId);
        if (status.exportMethod == ExportStatus.ExportMethod.FORMATTER_STREAM) {
            if (this.waitForSource(exportId)) {
                MimeTypeUtils.MimeType mt = this.exportUtils.getMimeType(status);
                resp.setContentType(mt.mimeType);
                String filename = StringUtils.isBlank((String)status.params.filenameBase) ? status.exportId : status.params.filenameBase;
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + mt.extension + "\"");
                ServletOutputStream os = resp.getOutputStream();
                BindableExportOutput bindableExportOutput = this.bindOutput(exportId, new ExportToStream((OutputStream)os, status.params, -1L));
                status = this.waitForExport(exportId);
                os.flush();
                if (status.state == JobState.DONE) {
                    this.exportDAO.removeExport(exportId);
                }
                return bindableExportOutput.getWrittenBytes();
            }
            throw ErrorContext.iaef((String)"Export '%s' failed", (Object)exportId, (Object[])new Object[0]);
        }
        if (status.exportMethod == ExportStatus.ExportMethod.FORMATTER_TO_FILE || status.exportMethod == ExportStatus.ExportMethod.CUSTOM_TO_FILE) {
            if (status.state != JobState.DONE) {
                throw ErrorContext.iaef((String)"Export '%s' is not DONE, cannot download", (Object)exportId, (Object[])new Object[0]);
            }
            File f = new File(status.targetFile);
            if (!f.isFile()) {
                throw ErrorContext.iaef((String)"Export file '%s' is missing", (Object)exportId, (Object[])new Object[0]);
            }
            long fileLength = f.length();
            MimeTypeUtils.MimeType mt = this.exportUtils.getMimeType(status);
            resp.setHeader("Content-Length", "" + fileLength);
            resp.setContentType(mt.mimeType);
            String filename = StringUtils.isBlank((String)status.params.filenameBase) ? status.exportId : status.params.filenameBase;
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + mt.extension + "\"");
            try (FileInputStream fis = new FileInputStream(f);){
                IOUtils.copyLarge((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
            return fileLength;
        }
        throw ErrorContext.iaef((String)"Export '%s' cannot be downloaded", (Object)exportId, (Object[])new Object[0]);
    }

    public ExportStatus handleExportRequest(AuthCtx user, ExportInput input, ExportParams params) throws Exception {
        return this.newExport(user, input, params);
    }

    private synchronized LocalExportFutureThread getExportThread(String exportId) {
        return this.runningLocalExports.get(exportId);
    }

    public void removeExport(String exportId) throws IOException {
        this.exportDAO.removeExport(exportId);
    }

    public synchronized List<ExportStatus> listExports(String userFilter) throws Exception {
        return this.exportDAO.listExports(userFilter);
    }

    public synchronized ExportStatus getExport(String exportId) throws IOException {
        return this.exportDAO.getStatus(exportId);
    }

    public static ExportOutput buildExportOutput(AuthCtx user, ExportParams params, ExportStatus.ExportMethod exportMethod, ExportStatus status, String exportId) throws IOException {
        ExportOutput output = null;
        switch (exportMethod) {
            case CUSTOM_MANAGED: {
                CustomLoadedExporter<?> exporter = CustomExportersRegistry.getExporter(params.exporterType);
                assert (exporter.getBehavior() == CustomExporterDesc.ExportBehavior.MANAGES_OUTPUT);
                output = exporter.create(user, null, params, null);
                break;
            }
            case CUSTOM_TO_FILE: {
                CustomLoadedExporter<?> exporter = CustomExportersRegistry.getExporter(params.exporterType);
                assert (exporter.getBehavior() == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE);
                ExportService.fillTargetPath(status, params, exportId, exporter);
                output = exporter.create(user, status, params, null);
                break;
            }
            case DATASET: {
                DatasetDeletionService deletionService = (DatasetDeletionService)SpringUtils.getBean(DatasetDeletionService.class);
                ProjectsService projectsService = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
                DatasetAccessService datasetAccessService = (DatasetAccessService)SpringUtils.getBean(DatasetAccessService.class);
                DatasetSaveService datasetSaveService = (DatasetSaveService)SpringUtils.getBean(DatasetSaveService.class);
                TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
                ManagedDatasetsCreationService managedDatasetsCreationService = (ManagedDatasetsCreationService)SpringUtils.getBean(ManagedDatasetsCreationService.class);
                output = new ExportToDataset(user, datasetAccessService, datasetSaveService, deletionService, projectsService, params, transactionService, connectionsDAO, managedDatasetsCreationService);
                break;
            }
            case FORMATTER_STREAM: {
                output = new BindableExportOutput(30000L);
                break;
            }
            case FORMATTER_TO_FILE: {
                ExportService.fillTargetPath(status, params, exportId, null);
                output = new ExportToFile(status, params);
            }
        }
        return output;
    }

    public static class RemoteExportJob {
        public RemotableExportInput input;
        public String exportId;
        public ExportParams params;
        public ExportStatus status;
    }

    public static class LocalExportJob {
        public ExportInput input;
        public ExportOutput output;
        public ExportStatus status;
        public APITicketService.Ticket ticket;
    }

    public class WaitForSourceInitializedThread
    extends SimpleFutureThread<String> {
        private final String exportId;
        private final FuturePayload futurePayload;

        public WaitForSourceInitializedThread(AuthCtx owner, String exportId) {
            super(owner);
            this.exportId = exportId;
            this.futurePayload = ExportService.buildFuturePayload(exportId);
        }

        @Override
        protected String compute() throws Exception {
            logger.info((Object)"Waiting for source to be initialized");
            boolean init = ExportService.this.waitForSource(this.exportId);
            logger.info((Object)("Source properly initialized: " + init));
            return "initialized";
        }

        public void postRunCleanup() {
            ((AuditTrailService)SpringUtils.getBean(AuditTrailService.class)).generic("export-ready").with("exportId", this.exportId).with("exportMethod", ExportStatus.ExportMethod.FORMATTER_STREAM.name()).with("fileSize", (Number)-1).emit();
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }
}

