/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.expressions;

import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.utils.DKULogger;
import io.krakens.grok.api.Converter;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.Match;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class GrokExpression {
    public final String expression;
    public final Grok grok;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.processor.grok.expr");

    public GrokExpression(String expression) {
        if (!StringUtils.isBlank((CharSequence)expression)) {
            GrokCompiler grokCompiler = GrokCompiler.newInstance();
            grokCompiler.registerDefaultPatterns();
            this.grok = grokCompiler.compile(expression);
            this.expression = expression;
        } else {
            this.grok = null;
            this.expression = "";
        }
    }

    public String getString() {
        return this.expression;
    }

    private boolean isEmpty() {
        return this.grok == null;
    }

    public Map<String, Object> capture(String log) {
        if (this.isEmpty()) {
            return null;
        }
        return this.grok.capture(log);
    }

    public List<String> getVariables() {
        ArrayList<String> variableList = new ArrayList<String>();
        if (this.isEmpty()) {
            return variableList;
        }
        LinkedHashSet variableSet = new LinkedHashSet();
        Map namedRegexCollection = this.grok.getNamedRegexCollection();
        logger.debug((Object)("namedRegexCollection: " + String.valueOf(namedRegexCollection)));
        logger.debug((Object)("namedGroups: " + String.valueOf(this.grok.namedGroups)));
        this.grok.namedGroups.forEach(name -> {
            String label = namedRegexCollection.containsKey(name) ? Converter.extractKey((String)((String)namedRegexCollection.get(name))) : name;
            variableSet.add(label);
        });
        variableList.addAll(variableSet);
        return variableList;
    }

    public List<Offset> getCaptureOffsets(String text) {
        ArrayList<Offset> captureOffsets = new ArrayList<Offset>();
        if (this.isEmpty()) {
            return captureOffsets;
        }
        Matcher matcher = this.grok.match((CharSequence)text).getMatch();
        if (matcher == null) {
            return captureOffsets;
        }
        for (int i = 1; i < matcher.groupCount() + 1; ++i) {
            captureOffsets.add(new Offset(matcher.start(i), matcher.end(i)));
        }
        return captureOffsets;
    }

    public Offset getMatchOffset(String text) {
        if (this.isEmpty()) {
            return new Offset(0, 0);
        }
        Match match = this.grok.match((CharSequence)text);
        return new Offset(match.getStart(), match.getEnd());
    }

    public static class Offset {
        public final int start;
        public final int end;

        public Offset(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean noMatch() {
            return this.start == 0 && this.end == 0;
        }
    }

    public static class SampleResponse {
        public List<List<Offset>> captureOffsets;
        public List<Offset> matchOffsets;
        public SerializedTableChunk table;
        public int matchedLines = 0;
        public int processedLines = 0;
    }
}

