/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.snowpark;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDetailedService;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SnowparkYamlTemplateFiller {
    private static final String INDENT_UNIT = "  ";
    private static final String IMAGE_FIELD = "__SNW_ENVIRONMENT_IMAGE__";
    private static final String READINESS_FIELD = "__SNW_READINESS_ROUTE__";
    private static final String PUBLIC_ENDPOINT_FIELD = "__SNW_PUBLIC_ENDPOINT__";
    private static final String ENV_VARS_FIELD = "__SNW_ENV_VARS__";
    private static final String RESOURCES_FIELD = "__SNW_RESOURCES__";
    private static final String LOG_EXPORTERS_FIELD = "__SNW_LOG_EXPORTERS__";

    private SnowparkYamlTemplateFiller() {
    }

    public static String getSpecificationsFromTemplate(@Nonnull SnowparkDetailedService.YamlSpec serviceSpec) throws IOException {
        File serviceYamlTemplate = DKUApp.getResourceFile((String[])new String[]{"api-deployer", "snowpark", "service.yaml.template"});
        SnowparkDetailedService.YamlContainer yamlContainer = serviceSpec.containers.get(0);
        SnowparkDetailedService.YamlEndpoint yamlEndpoint = serviceSpec.endpoints.get(0);
        return DKUFileUtils.readFileToStringUTF8((File)serviceYamlTemplate).replace(IMAGE_FIELD, yamlContainer.image).replace(READINESS_FIELD, yamlContainer.readinessProbe.path).replace(PUBLIC_ENDPOINT_FIELD, String.valueOf(yamlEndpoint.isPublic())).replace(ENV_VARS_FIELD, SnowparkYamlTemplateFiller.getEnvVarsYamlSection(yamlContainer.env, 2)).replace(RESOURCES_FIELD, SnowparkYamlTemplateFiller.getResourcesSection(yamlContainer.resources, 2)).replace(LOG_EXPORTERS_FIELD, SnowparkYamlTemplateFiller.getlogExportersSection(serviceSpec.logExporters, 1));
    }

    private static String getEnvVarsYamlSection(@Nullable Map<String, String> env, int indentationLevel) {
        StringBuilder section = new StringBuilder();
        if (env != null && !env.isEmpty()) {
            section.append(SnowparkYamlTemplateFiller.keyNewLine("env", indentationLevel));
            for (Map.Entry<String, String> entry : env.entrySet()) {
                section.append(SnowparkYamlTemplateFiller.keyValueNewLine(entry.getKey(), entry.getValue(), indentationLevel + 1));
            }
        }
        return section.toString();
    }

    private static String getResourcesSection(@Nullable SnowparkDetailedService.YamlResources resources, int indentationLevel) {
        StringBuilder section = new StringBuilder();
        if (resources != null) {
            section.append(SnowparkYamlTemplateFiller.keyNewLine("resources", indentationLevel));
            SnowparkYamlTemplateFiller.addResourceSection(resources.requests, section, indentationLevel + 1, "requests");
            SnowparkYamlTemplateFiller.addResourceSection(resources.limits, section, indentationLevel + 1, "limits");
        }
        return section.toString();
    }

    private static void addResourceSection(@Nullable SnowparkDetailedService.YamlResource resource, @Nonnull StringBuilder section, int indentationLevel, String key) {
        if (resource != null) {
            section.append(SnowparkYamlTemplateFiller.keyNewLine(key, indentationLevel));
            if (StringUtils.isNotBlank((CharSequence)resource.cpu)) {
                section.append(SnowparkYamlTemplateFiller.keyValueNewLine("cpu", resource.cpu, indentationLevel + 1));
            }
            if (StringUtils.isNotBlank((CharSequence)resource.memory)) {
                section.append(SnowparkYamlTemplateFiller.keyValueNewLine("memory", resource.memory, indentationLevel + 1));
            }
            if (StringUtils.isNotBlank((CharSequence)resource.getNvidiaComGpu())) {
                section.append(SnowparkYamlTemplateFiller.keyValueNewLine("nvidia.com/gpu", resource.getNvidiaComGpu(), indentationLevel + 1));
            }
        }
    }

    private static String getlogExportersSection(@Nullable SnowparkDetailedService.YamlLogExporters logExporters, int indentationLevel) {
        StringBuilder section = new StringBuilder();
        if (logExporters != null) {
            section.append(SnowparkYamlTemplateFiller.keyNewLine("logExporters", indentationLevel));
            if (logExporters.eventTableConfig != null) {
                section.append(SnowparkYamlTemplateFiller.keyNewLine("eventTableConfig", indentationLevel + 1));
                if (StringUtils.isNotBlank((CharSequence)logExporters.eventTableConfig.logLevel)) {
                    section.append(SnowparkYamlTemplateFiller.keyValueNewLine("logLevel", logExporters.eventTableConfig.logLevel, indentationLevel + 2));
                }
            }
        }
        return section.toString();
    }

    private static String keyNewLine(String key, int indentationLevel) {
        return String.format("%s%s:%n", INDENT_UNIT.repeat(indentationLevel), key);
    }

    private static String keyValueNewLine(String key, String value, int indentationLevel) {
        return String.format("%s%s: \"%s\"%n", INDENT_UNIT.repeat(indentationLevel), key, value);
    }
}

