/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.input.formats.CSVParserUtils;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVParser;
import com.dataiku.dip.input.stream.LineReader;
import java.io.IOException;
import java.util.List;

public class RFC4180CSVParser
implements CSVParser {
    private StringBuilder currentField = new StringBuilder();
    private boolean inQuotes;
    private LineReader br;
    private char delimiter;
    private char quote = (char)34;
    private Integer maxRowChars;
    private int currentLine = 1;

    public RFC4180CSVParser(LineReader reader, char delimiter) {
        this(reader, delimiter, null);
    }

    public RFC4180CSVParser(LineReader reader, CSVFormatConfig conf) {
        this(reader, conf.getSeparatorChar(), conf.getMaxRowChars());
    }

    private RFC4180CSVParser(LineReader reader, char delimiter, Integer maxRowChars) {
        this.delimiter = delimiter;
        this.br = reader;
        this.maxRowChars = maxRowChars;
    }

    @Override
    public boolean next(List<String> out) throws IOException {
        if (!this.inQuotes) assert (this.currentField.length() == 0);
        out.clear();
        int currentRowLength = 0;
        do {
            String line;
            if ((line = this.br.readLine()) == null) {
                if (!this.inQuotes) {
                    return false;
                }
                if (this.currentField != null && this.currentField.length() > 0) {
                    String currentStr = this.currentField.toString();
                    if (currentStr.length() > 100) {
                        currentStr = currentStr.substring(0, 100);
                    }
                    throw new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_CSV_UNTERMINATED_QUOTE, "Unterminated quoted field at the end of the file (while reading: '" + currentStr + "...')");
                }
                throw new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_CSV_UNTERMINATED_QUOTE, "Unterminated quoted field at the end of the file");
            }
            for (int i = 0; i < line.length(); ++i) {
                char c2 = line.charAt(i);
                if (c2 == this.quote) {
                    if (!this.inQuotes) {
                        this.inQuotes = true;
                        continue;
                    }
                    if (line.length() > i + 1 && line.charAt(i + 1) == this.quote) {
                        this.currentField.append('\"');
                        ++i;
                        continue;
                    }
                    this.inQuotes = false;
                    continue;
                }
                if (c2 == this.delimiter) {
                    if (this.inQuotes) {
                        this.currentField.append(c2);
                        continue;
                    }
                    out.add(this.currentField.toString());
                    this.currentField.setLength(0);
                    continue;
                }
                this.currentField.append(c2);
            }
            currentRowLength += line.length();
            if (this.inQuotes) {
                this.currentField.append('\n');
                ++currentRowLength;
            } else {
                out.add(this.currentField.toString());
                this.currentField.setLength(0);
            }
            CSVParserUtils.checkRowLength((int)currentRowLength, (Integer)this.maxRowChars, (int)this.currentLine);
        } while (this.inQuotes);
        ++this.currentLine;
        return true;
    }
}

