/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.serde;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.JSONUtils;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveSerdeShimsLoader;
import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.io.BaseEncoding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveBaseCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;

public class DSSRowConverter {
    private static final DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter dateOnlyFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.getDefault());
    private final RowFactory rf;
    private final List<Column> columns = new ArrayList<Column>();
    private final List<SchemaColumn> schemaColumns;
    private final HiveFileFormatConfig config;
    private Class<?> dateWritableV2Class = null;
    private Method getOnDateWritableV2 = null;

    public DSSRowConverter(ColumnFactory cf, RowFactory rf, List<SchemaColumn> schemaColumns, HiveFileFormatConfig config) {
        this.schemaColumns = (List)Preconditions.checkNotNull(schemaColumns);
        this.config = (HiveFileFormatConfig)Preconditions.checkNotNull((Object)config);
        this.rf = (RowFactory)Preconditions.checkNotNull((Object)rf);
        for (SchemaColumn sc : schemaColumns) {
            this.columns.add(cf.column(sc.getName()));
        }
        this.checkSchemaCaseInsensitivityCompatibility(schemaColumns);
    }

    private static void checkUniqueNamesCaseInsensitively(Iterable<String> names) {
        HashSet<String> lowerCaseNames = new HashSet<String>();
        for (String caseSensitiveName : names) {
            String lowerCaseName = caseSensitiveName.toLowerCase();
            if (lowerCaseNames.contains(lowerCaseName)) {
                if (StringUtils.equals((String)caseSensitiveName, (String)lowerCaseName)) {
                    throw new RuntimeException("Duplicate column/field name in schema: " + caseSensitiveName);
                }
                throw new RuntimeException("Case-insensitively duplicate/field column name in schema: " + caseSensitiveName);
            }
            lowerCaseNames.add(lowerCaseName);
        }
    }

    private void checkSchemaCaseInsensitivityCompatibility(Iterable<SchemaColumn> cols) {
        FluentIterable names = FluentIterable.from(cols).transform((Function)new Function<SchemaColumn, String>(){

            public String apply(SchemaColumn schemaColumn) {
                return schemaColumn.getName();
            }
        });
        DSSRowConverter.checkUniqueNamesCaseInsensitively((Iterable<String>)names);
        for (SchemaColumn sc : cols) {
            if (sc.getType() != Type.OBJECT) continue;
            this.checkSchemaCaseInsensitivityCompatibility(sc.objectFields);
        }
    }

    public Row buildRow(Object rowObject, StructObjectInspector rowObjectInspector) {
        Row row = this.rf.row();
        List structFields = rowObjectInspector.getAllStructFieldRefs();
        for (int colIdx = 0; colIdx < this.columns.size(); ++colIdx) {
            SchemaColumn sc = this.schemaColumns.get(colIdx);
            StructField structField = (StructField)structFields.get(colIdx);
            Column col = this.columns.get(colIdx);
            ObjectInspector fieldObjectInspector = structField.getFieldObjectInspector();
            Object fieldObject = rowObjectInspector.getStructFieldData(rowObject, structField);
            StringBuilder sb = new StringBuilder();
            this.buildCell(sb, fieldObject, fieldObjectInspector, sc);
            row.put(col, sb.toString());
        }
        return row;
    }

    private void buildPrimitiveCell(StringBuilder sb, Object o, PrimitiveObjectInspector oi, SchemaColumn sc) {
        switch (oi.getPrimitiveCategory()) {
            case BOOLEAN: {
                sb.append(Boolean.toString(((BooleanObjectInspector)oi).get(o)));
                break;
            }
            case SHORT: {
                sb.append(Short.toString(((ShortObjectInspector)oi).get(o)));
                break;
            }
            case INT: {
                sb.append(Integer.toString(((IntObjectInspector)oi).get(o)));
                break;
            }
            case LONG: {
                sb.append(Long.toString(((LongObjectInspector)oi).get(o)));
                break;
            }
            case FLOAT: {
                sb.append(Float.toString(((FloatObjectInspector)oi).get(o)));
                break;
            }
            case DOUBLE: 
            case DECIMAL: {
                if (o instanceof HiveDecimalWritable) {
                    o = ((HiveDecimalWritable)o).getHiveDecimal();
                }
                if (o instanceof HiveDecimal) {
                    sb.append(Double.toString(((HiveDecimal)o).doubleValue()));
                    break;
                }
                sb.append(Double.toString(((DoubleObjectInspector)oi).get(o)));
                break;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                if (o instanceof HiveBaseCharWritable) {
                    o = ((HiveBaseCharWritable)o).getTextValue();
                }
                if (this.dateWritableV2Class == null) {
                    try {
                        this.dateWritableV2Class = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2");
                    }
                    catch (ClassNotFoundException e) {
                        this.dateWritableV2Class = this.getClass();
                    }
                }
                if (this.dateWritableV2Class.isAssignableFrom(o.getClass())) {
                    try {
                        if (this.getOnDateWritableV2 == null) {
                            this.getOnDateWritableV2 = o.getClass().getMethod("get", new Class[0]);
                        }
                        Object dt = this.getOnDateWritableV2.invoke(o, new Object[0]);
                        sb.append(dt.toString());
                        break;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_SERDE_CLASS_NOT_AVAILABLE, "Unexpected structure of the DateWritableV2 class", (Throwable)e);
                    }
                }
                if (o instanceof DateWritable) {
                    Date dValue = ((DateWritable)o).get();
                    sb.append(dateOnlyFormatter.print(dValue.getTime()));
                    break;
                }
                if (o instanceof HiveBaseChar) {
                    sb.append(((HiveBaseChar)o).getValue());
                    break;
                }
                sb.append(((StringObjectInspector)oi).getPrimitiveJavaObject(o));
                break;
            }
            case TIMESTAMP: {
                sb.append(HiveSerdeShimsLoader.get().readTimestamp((PrimitiveObjectInspector)((TimestampObjectInspector)oi), o));
                break;
            }
            case DATE: {
                sb.append(HiveSerdeShimsLoader.get().readDate((PrimitiveObjectInspector)((DateObjectInspector)oi), o));
                break;
            }
            case BINARY: {
                BinaryObjectInspector boi = (BinaryObjectInspector)oi;
                byte[] bytes = boi.getPrimitiveJavaObject(o);
                sb.append(BaseEncoding.base64().encode(bytes));
                break;
            }
            case BYTE: {
                ByteObjectInspector byoi = (ByteObjectInspector)oi;
                sb.append(byoi.get(o));
                break;
            }
            case VOID: {
                break;
            }
            default: {
                throw new RuntimeException("Type " + String.valueOf(oi.getPrimitiveCategory()) + " is not supported");
            }
        }
    }

    private void buildPrimitiveJSON(StringBuilder sb, Object o, PrimitiveObjectInspector oi, SchemaColumn sc) {
        switch (oi.getPrimitiveCategory()) {
            case BOOLEAN: {
                sb.append(Boolean.toString(((BooleanObjectInspector)oi).get(o)));
                break;
            }
            case SHORT: {
                sb.append(Short.toString(((ShortObjectInspector)oi).get(o)));
                break;
            }
            case INT: {
                sb.append(Integer.toString(((IntObjectInspector)oi).get(o)));
                break;
            }
            case LONG: {
                sb.append(Long.toString(((LongObjectInspector)oi).get(o)));
                break;
            }
            case FLOAT: {
                sb.append(Float.toString(((FloatObjectInspector)oi).get(o)));
                break;
            }
            case DOUBLE: 
            case DECIMAL: {
                if (o instanceof HiveDecimalWritable) {
                    o = ((HiveDecimalWritable)o).getHiveDecimal();
                }
                if (o instanceof HiveDecimal) {
                    sb.append(Double.toString(((HiveDecimal)o).doubleValue()));
                    break;
                }
                sb.append(Double.toString(((DoubleObjectInspector)oi).get(o)));
                break;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                String value;
                if (o instanceof HiveBaseCharWritable) {
                    o = ((HiveBaseCharWritable)o).getTextValue();
                }
                if (this.dateWritableV2Class == null) {
                    try {
                        this.dateWritableV2Class = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2");
                    }
                    catch (ClassNotFoundException e) {
                        this.dateWritableV2Class = this.getClass();
                    }
                }
                if (this.dateWritableV2Class.isAssignableFrom(o.getClass())) {
                    try {
                        if (this.getOnDateWritableV2 == null) {
                            this.getOnDateWritableV2 = o.getClass().getMethod("get", new Class[0]);
                        }
                        Object dt = this.getOnDateWritableV2.invoke(o, new Object[0]);
                        value = dt.toString();
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_SERDE_CLASS_NOT_AVAILABLE, "Unexpected structure of the DateWritableV2 class", (Throwable)e);
                    }
                } else if (o instanceof DateWritable) {
                    Date dValue = ((DateWritable)o).get();
                    value = dateOnlyFormatter.print(dValue.getTime());
                } else {
                    value = o instanceof HiveBaseChar ? ((HiveBaseChar)o).getValue() : ((StringObjectInspector)oi).getPrimitiveJavaObject(o);
                }
                sb.append('\"');
                sb.append(JSONUtils.escapeJSONString(value));
                sb.append('\"');
                break;
            }
            case TIMESTAMP: {
                sb.append('\"');
                sb.append(HiveSerdeShimsLoader.get().readTimestamp((PrimitiveObjectInspector)((TimestampObjectInspector)oi), o));
                sb.append('\"');
                break;
            }
            case DATE: {
                sb.append('\"');
                sb.append(HiveSerdeShimsLoader.get().readDate((PrimitiveObjectInspector)((DateObjectInspector)oi), o));
                sb.append('\"');
                break;
            }
            case BINARY: {
                BinaryObjectInspector boi = (BinaryObjectInspector)oi;
                byte[] bytes = boi.getPrimitiveJavaObject(o);
                sb.append('\"');
                sb.append(BaseEncoding.base64().encode(bytes));
                sb.append('\"');
                break;
            }
            case BYTE: {
                ByteObjectInspector byoi = (ByteObjectInspector)oi;
                sb.append('\"');
                sb.append(byoi.get(o));
                sb.append('\"');
                break;
            }
            case VOID: {
                break;
            }
            default: {
                throw new RuntimeException("Type " + String.valueOf(oi.getPrimitiveCategory()) + " is not supported");
            }
        }
    }

    private void buildCell(StringBuilder sb, Object o, ObjectInspector oi, SchemaColumn sc) {
        ObjectInspector.Category category = oi.getCategory();
        if (o == null) {
            return;
        }
        switch (category) {
            case PRIMITIVE: {
                this.buildPrimitiveCell(sb, o, (PrimitiveObjectInspector)oi, sc);
                break;
            }
            case LIST: 
            case STRUCT: 
            case MAP: {
                this.buildJSON(sb, o, oi, sc, "");
                break;
            }
            case UNION: {
                throw new RuntimeException("Union types are not supported");
            }
            default: {
                throw new RuntimeException("Type category " + String.valueOf(category) + " is not supported");
            }
        }
    }

    private void buildJSON(StringBuilder sb, Object o, ObjectInspector oi, SchemaColumn sc, String nullStr) {
        ObjectInspector.Category category = oi.getCategory();
        if (o == null) {
            sb.append(nullStr);
            return;
        }
        switch (category) {
            case PRIMITIVE: {
                this.buildPrimitiveJSON(sb, o, (PrimitiveObjectInspector)oi, sc);
                break;
            }
            case LIST: {
                this.buildJSONArray(sb, o, (ListObjectInspector)oi, sc, nullStr);
                break;
            }
            case STRUCT: {
                this.buildJSONStruct(sb, o, (StructObjectInspector)oi, sc, nullStr);
                break;
            }
            case MAP: {
                this.buildJSONMap(sb, o, (MapObjectInspector)oi, sc, nullStr);
                break;
            }
            case UNION: {
                throw new RuntimeException("Union types are not supported");
            }
            default: {
                throw new RuntimeException("Type category " + String.valueOf(category) + " is unknown");
            }
        }
    }

    private void buildJSONStruct(StringBuilder sb, Object o, StructObjectInspector soi, SchemaColumn sc, String nullStr) {
        List structFields = soi.getAllStructFieldRefs();
        List fieldsData = soi.getStructFieldsDataAsList(o);
        if (fieldsData == null) {
            sb.append(nullStr);
        } else {
            sb.append("{");
            boolean notFirst = false;
            for (int i = 0; i < structFields.size(); ++i) {
                Object fieldData = fieldsData.get(i);
                if (!this.config.getRepresentsNullFields() && fieldData == null) continue;
                if (notFirst) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(SerDeUtils.escapeString((String)((SchemaColumn)sc.objectFields.get(i)).getName()));
                sb.append("\":");
                this.buildJSON(sb, fieldData, ((StructField)structFields.get(i)).getFieldObjectInspector(), (SchemaColumn)sc.objectFields.get(i), "null");
                notFirst = true;
            }
            sb.append('}');
        }
    }

    private void buildJSONArray(StringBuilder sb, Object o, ListObjectInspector loi, SchemaColumn sc, String nullStr) {
        ObjectInspector listElementObjectInspector = loi.getListElementObjectInspector();
        List olist = loi.getList(o);
        if (olist == null) {
            sb.append(nullStr);
        } else {
            sb.append('[');
            for (int i = 0; i < olist.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                this.buildJSON(sb, olist.get(i), listElementObjectInspector, sc.arrayContent, "null");
            }
            sb.append("]");
        }
    }

    private void buildJSONMap(StringBuilder sb, Object o, MapObjectInspector moi, SchemaColumn sc, String nullStr) {
        ObjectInspector mapKeyObjectInspector = moi.getMapKeyObjectInspector();
        if (mapKeyObjectInspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new RuntimeException("Key must be primitive: " + String.valueOf(mapKeyObjectInspector.getCategory()));
        }
        PrimitiveObjectInspector primitiveMapKeyObjectInspector = (PrimitiveObjectInspector)mapKeyObjectInspector;
        if (primitiveMapKeyObjectInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new RuntimeException("For now, non-string map keys are not supported" + String.valueOf(primitiveMapKeyObjectInspector.getPrimitiveCategory()));
        }
        StringObjectInspector stringMapKeyObjectInspector = (StringObjectInspector)primitiveMapKeyObjectInspector;
        ObjectInspector mapValueObjectInspector = moi.getMapValueObjectInspector();
        Map omap = moi.getMap(o);
        if (omap == null) {
            sb.append(nullStr);
        } else {
            sb.append('{');
            boolean first = true;
            for (Map.Entry entry : omap.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                Map.Entry e = entry;
                if (e.getKey() == null) {
                    throw new RuntimeException("NULL map keys are not allowed");
                }
                this.buildJSON(sb, e.getKey(), (ObjectInspector)stringMapKeyObjectInspector, sc.mapKeys, "null");
                sb.append(':');
                this.buildJSON(sb, e.getValue(), mapValueObjectInspector, sc.mapValues, "null");
            }
            sb.append('}');
        }
    }
}

