/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.misc;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.integrations.AbstractIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.EditableDatasetService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetScenarioIntegrationHandler
extends AbstractIntegrationEventHandler {
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "dataset-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return DatasetMessagingConfiguration.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) {
            return new DatasetScenarioIntegrationHandler(authCtx, messaging.getConfigurationAs(DatasetMessagingConfiguration.class));
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
        }
    };
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private EditableDatasetService editableDatasetService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    private final DatasetMessagingConfiguration params;
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sender.dataset");

    public DatasetScenarioIntegrationHandler(AuthCtx authCtx, DatasetMessagingConfiguration params) {
        this.authCtx = authCtx;
        this.params = params;
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        SchemaColumn column;
        Map contents;
        Dataset dataset;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.projectKey), (Object)"Missing dataset project key for reporter");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.datasetName), (Object)"Missing dataset name for reporter");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.message), (Object)"No message specified for reporter, cannot get values for the dataset's columns");
        ScenarioReportEvent sre = (ScenarioReportEvent)event;
        StringSubstitutor substitutor = new StringSubstitutor((StringLookup)sre.lookup);
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(this.params.projectKey, this.params.datasetName));
        }
        try {
            contents = (Map)JSON.parse((String)this.params.message, (TypeToken)new TypeToken<Map<String, String>>(){});
        }
        catch (Exception ex) {
            throw new Exception("Failed to parse json for row", ex);
        }
        HashMap substitutedContents = Maps.newHashMap();
        for (Map.Entry e : contents.entrySet()) {
            String string = (String)e.getKey();
            String value = (String)e.getValue();
            if (value == null) {
                logger.info((Object)("Null value for column " + string + ". Skipping"));
                continue;
            }
            String substitutedValue = value;
            try {
                substitutedValue = substitutor.replace(value);
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to substitute '" + value + "'"), (Throwable)exception);
            }
            substitutedContents.put(string, substitutedValue);
        }
        Schema schema = dataset.getSchema();
        if (!(StringUtils.isBlank((String)this.params.timestampColumn) || (column = schema.getColumn(this.params.timestampColumn)) != null && column.getType() == Type.DATE)) {
            throw new IllegalArgumentException("Dataset for storing report is lacking a " + this.params.timestampColumn + " date column");
        }
        for (Map.Entry entry : substitutedContents.entrySet()) {
            SchemaColumn column2 = schema.getColumn((String)entry.getKey());
            if (column2 != null && column2.getType() == Type.STRING) continue;
            throw new IllegalArgumentException("Dataset for storing report is lacking a " + (String)entry.getKey() + " string column");
        }
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory streamRowFactory = new StreamRowFactory();
        Row row = streamRowFactory.row();
        if (!StringUtils.isBlank((String)this.params.timestampColumn)) {
            StreamColumn column3 = scf.column(this.params.timestampColumn);
            row.put((Column)column3, DKUtils.isoFormatReadableByDateFormat((long)System.currentTimeMillis()));
        }
        for (Map.Entry entry : substitutedContents.entrySet()) {
            StreamColumn column4 = scf.column((String)entry.getKey());
            row.put((Column)column4, (String)entry.getValue());
        }
        if ("Inline".equals(dataset.getType())) {
            EditableDatasetService.EditableDatasetSaveQuery addition = new EditableDatasetService.EditableDatasetSaveQuery();
            try (RWTransaction rWTransaction = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
                try (InlineDatasetHandler dh = (InlineDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
                    ArrayList<ArrayList<String>> oldData = dh.getDataAsList();
                    addition.data = new ArrayList();
                    addition.changes = new ArrayList();
                    addition.schema = dataset.getSchema();
                    addition.rowMapping = new ArrayList();
                    for (int i = 0; i < oldData.size(); ++i) {
                        addition.data.add(new ArrayList());
                        addition.changes.add(new ArrayList());
                        addition.rowMapping.add(i);
                    }
                    ArrayList<String> newData = new ArrayList<String>();
                    ArrayList<Boolean> newChanges = new ArrayList<Boolean>();
                    for (SchemaColumn c2 : addition.schema.getColumns()) {
                        newChanges.add(true);
                        newData.add(row.get((Column)scf.column(c2.getName())));
                    }
                    addition.data.add(newData);
                    addition.changes.add(newChanges);
                    addition.rowMapping.add(-1);
                }
                this.editableDatasetService.save(dataset, addition, this.authCtx);
                rWTransaction.commit("Added row for scenario run");
            }
            this.datasetDeletionService.clearCacheAndStatus_NT(dataset);
        } else {
            WarningsContext warnContext = new WarningsContext();
            ToDatasetStreamer toDatasetStreamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtx, dataset, new Partition(null), (ColumnFactory)scf, warnContext, Output.WriteMode.APPEND);
            ProcessorOutput output = toDatasetStreamer.getAsOutput();
            output.emitRow(row);
            output.lastRowEmitted();
        }
        logger.info((Object)("Reported run into dataset " + dataset.getFullName()));
    }

    public static class DatasetMessagingConfiguration
    implements IntegrationParams {
        public String projectKey;
        public String datasetName;
        public String timestampColumn;
        public String message;
    }
}

