/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api.completions;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.marshall.LogProbsResponseAdapter;
import com.dataiku.dip.llm.online.openai.api.completions.OpenAICompletionResponse;

public class OpenAICompletionResponseAdapter {
    private OpenAICompletionResponseAdapter() {
    }

    public static LLMClient.SimpleCompletionResponse adapt(OpenAICompletionResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            throw new IllegalArgumentException("Empty completion response");
        }
        OpenAICompletionResponse.Choice choice = response.choices.get(0);
        LLMClient.SimpleCompletionResponse resp = new LLMClient.SimpleCompletionResponse();
        resp.text = choice.text;
        resp.finishReason = FinishReasonResponseAdapter.adapt(choice.finishReason);
        resp.promptTokens = response.usage.promptTokens;
        resp.completionTokens = response.usage.completionTokens;
        if (choice.logProbs != null) {
            resp.logProbs = LogProbsResponseAdapter.adapt(choice.logProbs.tokens, choice.logProbs.tokenLogProbs, choice.logProbs.topLogProbs);
        }
        return resp;
    }
}

