/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.EvaluationMetrics;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.BaseUserMeta;
import com.dataiku.dip.analysis.model.core.CustomEvaluationTrait;
import com.dataiku.dip.analysis.model.core.GenAiCustomEvaluationMetric;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerformanceMetrics;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.AgentModelEvaluation;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.LLMModelEvaluation;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.mec.engine.ModelComparisonCodes;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelComparisonsService {
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private KernelsModelEvaluationStoresService kernelsModelEvaluationStoresService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    SavedModelsDAO savedModelsDAO;
    @Autowired
    KernelsModelEvaluationStoresService modelEvaluationStoresService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.mec");

    public List<ComparableModelItem> listFilteredComparableItems(String projectKey, @Nullable List<MELikesSource> origins, @Nullable ModelComparison.ModelTaskType modelTaskType, boolean filterOnPredictionType, @Nullable List<String> versions, @Nullable InfoMessage.InfoMessages messages, int maxComparables) throws IOException {
        ArrayList<ComparableModelItem> models = new ArrayList<ComparableModelItem>();
        if (origins == null || origins.contains((Object)MELikesSource.FROM_ANALYSIS)) {
            models.addAll(this.listComparableTM(projectKey));
        }
        if (origins == null || origins.contains((Object)MELikesSource.FROM_SAVED_MODELS)) {
            models.addAll(this.listComparableSMV(projectKey));
        }
        if (origins == null || origins.contains((Object)MELikesSource.FROM_MES)) {
            models.addAll(this.listComparableME(projectKey));
        }
        List<ComparableModelItem> res = models.stream().filter(comparable -> !filterOnPredictionType || (comparable instanceof GenAiComparableModelEvaluation || comparable.hasModel) && comparable.modelTaskType == modelTaskType).filter(comparable -> versions == null || ModelComparisonsService.isReferencingSMVs(comparable, versions)).collect(Collectors.toList());
        if (maxComparables > 0 && res.size() > maxComparables) {
            if (null != messages) {
                messages.withWarningV((InfoMessage.MessageCode)ModelComparisonCodes.WARN_TRUNCATED_COMPARABLE_LIST, "Too many comparables (%d) found. The list was truncated to the %d first items.", new Object[]{res.size(), maxComparables});
            }
            res = res.subList(0, maxComparables);
        }
        return res;
    }

    private static boolean isReferencingSMVs(ComparableModelItem comparable, List<String> versions) {
        if (comparable instanceof TabularComparableModelEvaluation) {
            TabularComparableModelEvaluation tabularComparableModelEvaluation = (TabularComparableModelEvaluation)comparable;
            if (tabularComparableModelEvaluation.evaluatedSavedModelVersion != null) {
                return versions.contains(tabularComparableModelEvaluation.evaluatedSavedModelVersion.toString());
            }
        }
        if (comparable instanceof ComparableSavedModelVersion) {
            ComparableSavedModelVersion comparableSavedModelVersion = (ComparableSavedModelVersion)comparable;
            return versions.contains(comparableSavedModelVersion.mli.toString());
        }
        return false;
    }

    private ComparableModelItem comparableItemFromME(ModelEvaluationStore mes, AbstractModelEvaluation evaluation) throws IOException {
        if (evaluation.isTabular()) {
            return this.comparableItemFromTabularME(mes, (TabularModelEvaluation)evaluation);
        }
        if (evaluation.isLLM()) {
            return this.comparableItemFromLlmME(mes, (LLMModelEvaluation)evaluation);
        }
        if (evaluation.isAgent()) {
            return this.comparableItemFromAgentME(mes, (AgentModelEvaluation)evaluation);
        }
        throw new IllegalArgumentException("Only Tabular and LLM Model Evaluations can be used for comparisons.");
    }

    private TabularComparableModelEvaluation comparableItemFromTabularME(ModelEvaluationStore mes, TabularModelEvaluation evaluation) throws IOException {
        TabularComparableModelEvaluation cm = new TabularComparableModelEvaluation();
        cm.evaluationMetric = evaluation.metricParams.evaluationMetric;
        cm.evaluatedSavedModelVersion = evaluation.getBackingFullModelId();
        List<SimpleKeyValue> meLabels = evaluation.userMeta.labels;
        cm.labels = null != meLabels ? meLabels.stream().filter(s -> s.key != null && s.value != null).collect(Collectors.toMap(s -> s.key, s -> s.value, (key1, key2) -> key2)) : new HashMap();
        cm.modelTaskType = ModelComparison.ModelTaskType.from(evaluation.predictionType);
        cm.targetVariable = evaluation.targetVariable;
        cm.mli = evaluation.ref;
        cm.storeName = mes.name + " (" + mes.id + ")";
        cm.evaluationName = evaluation.userMeta.name;
        if (TabularModelEvaluation.ModelType.SAVED_MODEL == evaluation.modelType) {
            cm.isPartitioned = evaluation.getModelParamsAs(TabularModelEvaluation.EvaluatedDSSModel.class).isPartitioned;
            cm.isEnsembled = evaluation.getModelParamsAs(TabularModelEvaluation.EvaluatedDSSModel.class).isEnsembled;
        }
        cm.classes = evaluation.ref.getClasses();
        cm.createdOn = evaluation.created;
        cm.driftSupported = true;
        cm.hasDriftReference = evaluation.hasDriftReference;
        FullModelId backingModel = evaluation.getBackingFullModelId();
        if (backingModel != null) {
            cm.modelUniqueId = backingModel.toString();
        }
        cm.displayName = cm.evaluationName;
        cm.modelType = evaluation.modelType;
        cm.hasModel = evaluation.hasModel;
        return cm;
    }

    private LLMComparableModelEvaluation comparableItemFromLlmME(ModelEvaluationStore mes, LLMModelEvaluation evaluation) throws IOException {
        LLMComparableModelEvaluation cm = new LLMComparableModelEvaluation();
        List<SimpleKeyValue> meLabels = evaluation.userMeta.labels;
        cm.labels = null != meLabels ? meLabels.stream().filter(s -> s.key != null && s.value != null).collect(Collectors.toMap(s -> s.key, s -> s.value, (key1, key2) -> key2)) : new HashMap();
        cm.modelTaskType = ModelComparison.ModelTaskType.LLM;
        cm.mli = evaluation.ref;
        cm.storeName = mes.name + " (" + mes.id + ")";
        cm.evaluationName = evaluation.userMeta.name;
        cm.createdOn = evaluation.created;
        cm.displayName = cm.evaluationName;
        cm.hasModel = false;
        cm.inputColumnName = evaluation.inputColumnName;
        cm.outputColumnName = evaluation.outputColumnName;
        cm.groundTruthColumnName = evaluation.groundTruthColumnName;
        cm.contextColumnName = evaluation.contextColumnName;
        return cm;
    }

    private AgentComparableModelEvaluation comparableItemFromAgentME(ModelEvaluationStore mes, AgentModelEvaluation evaluation) throws IOException {
        AgentComparableModelEvaluation cm = new AgentComparableModelEvaluation();
        List<SimpleKeyValue> meLabels = evaluation.userMeta.labels;
        cm.labels = null != meLabels ? meLabels.stream().filter(s -> s.key != null && s.value != null).collect(Collectors.toMap(s -> s.key, s -> s.value, (key1, key2) -> key2)) : new HashMap();
        cm.modelTaskType = ModelComparison.ModelTaskType.AGENT;
        cm.mli = evaluation.ref;
        cm.storeName = mes.name + " (" + mes.id + ")";
        cm.evaluationName = evaluation.userMeta.name;
        cm.createdOn = evaluation.created;
        cm.displayName = cm.evaluationName;
        cm.hasModel = false;
        cm.inputColumnName = evaluation.inputColumnName;
        cm.outputColumnName = evaluation.outputColumnName;
        cm.groundTruthColumnName = evaluation.groundTruthColumnName;
        cm.actualToolCallsColumnName = evaluation.actualToolCallsColumnName;
        cm.referenceToolCallsColumnName = evaluation.referenceToolCallsColumnName;
        return cm;
    }

    private List<ComparableModelItem> listComparableME(String projectKey) throws IOException {
        List<ModelEvaluationStore> listMES;
        ArrayList<ComparableModelItem> ret = new ArrayList<ComparableModelItem>();
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            listMES = this.modelEvaluationStoresCRUDService.list(projectKey);
        }
        for (ModelEvaluationStore mes : listMES) {
            List<String> evaluationIds;
            try {
                evaluationIds = this.modelEvaluationStoresCRUDService.listRunIds(mes);
            }
            catch (Exception e) {
                logger.error((Object)("Could not list model evaluations in " + mes.getFullName()), (Throwable)e);
                continue;
            }
            for (String currentModelEvaluationId : evaluationIds) {
                try {
                    Transaction t = this.transactionService.retrieveOrBeginRead();
                    try {
                        AbstractModelEvaluation currentModelEvaluation = this.kernelsModelEvaluationStoresService.getEvaluation(mes, currentModelEvaluationId);
                        ret.add(this.comparableItemFromME(mes, currentModelEvaluation));
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Could not get info for model evaluation " + currentModelEvaluationId), (Throwable)e);
                }
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public ComparableModelItem comparableItemFromId(ModelLikeId mli) throws Exception {
        switch (1.$SwitchMap$com$dataiku$dip$analysis$ml$ModelLikeId$ModelLikeType[mli.getModelLikeType().ordinal()]) {
            case 1: {
                mei = (FullModelEvaluationId)mli;
                t = this.transactionService.retrieveOrBeginRead();
                try {
                    mes = this.modelEvaluationStoresCRUDService.getMandatory(mli.getProjectKey(), mli.getId());
                    currentModelEvaluation = this.kernelsModelEvaluationStoresService.getEvaluation(mes, mei.evaluationId);
                    var6_14 = this.comparableItemFromME(mes, (TabularModelEvaluation)currentModelEvaluation);
                    return var6_14;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            case 2: {
                fmi = (FullModelId)mli;
                if (fmi.type != FullModelId.Type.ANALYSIS) ** GOTO lbl30
                t = this.transactionService.retrieveOrBeginRead();
                try {
                    acp = this.analysisCRUDService.getCoreMandatory(fmi.getProjectKey(), fmi.getTaskLoc().analysisId);
                    mlTask = this.analysisCRUDService.getMLTask(fmi.getTaskLoc());
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
                modelDetails = PredictionResultsReader.makeDetails(fmi);
                if (modelDetails.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
                    throw new RuntimeException("Model training is not done");
                }
                return this.comparableItemFromTM(mlTask, acp, fmi, modelDetails);
lbl30:
                // 1 sources

                if (fmi.type != FullModelId.Type.SAVED) break;
                t = this.transactionService.retrieveOrBeginRead();
                try {
                    sm = this.savedModelsCRUDService.getMandatory(mli.getProjectKey(), mli.getId());
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
                return this.comparableItemFromSMV(sm, fmi);
            }
        }
        throw new RuntimeException("Unsupported model type");
    }

    private ComparableSavedModelVersion comparableItemFromSMV(SavedModel sm, FullModelId versionFmi) throws IOException {
        ModelUserMeta userMeta;
        ComparableSavedModelVersion cm = new ComparableSavedModelVersion();
        PredictionMLTask.TabularPredictionMLTask headMLTask = (PredictionMLTask.TabularPredictionMLTask)versionFmi.getHeadMLTask();
        cm.evaluationMetric = headMLTask.modeling.metrics.evaluationMetric;
        if (versionFmi.hasReadableModelFile("user_meta.json")) {
            userMeta = versionFmi.getUserMeta();
        } else {
            logger.debugV("Saved model version %s has no user_meta.json", new Object[]{versionFmi.toString()});
            userMeta = new ModelUserMeta();
        }
        List modelLabels = userMeta.labels;
        cm.labels = null != modelLabels ? modelLabels.stream().collect(Collectors.toMap(s -> s.key, s -> s.value, (key1, key2) -> key2)) : new HashMap();
        TabularPredictionModelDetails modelDetails = (TabularPredictionModelDetails)PredictionResultsReader.makeModelDetails(versionFmi);
        ResolvedPredictionCoreParams coreParams = modelDetails.getCoreParams();
        cm.modelTaskType = ModelComparison.ModelTaskType.from(modelDetails.getCoreParams().prediction_type);
        cm.targetVariable = coreParams.target_variable;
        cm.savedModelName = sm.getDisplayName() + " (" + versionFmi.getId() + ")";
        cm.savedModelVersionName = userMeta.name;
        cm.mli = versionFmi;
        cm.isActive = Objects.equals(versionFmi.getSavedModelVersionID(), sm.activeVersion);
        cm.isPartitioned = coreParams.isPartitioned();
        cm.isEnsembled = null != modelDetails.modeling.ensemble_params;
        cm.createdOn = modelDetails.trainInfo.endTime;
        cm.classes = versionFmi.getClasses();
        cm.driftSupported = true;
        cm.modelUniqueId = versionFmi.toString();
        cm.displayName = cm.savedModelVersionName + (cm.isActive ? " (active version)" : "");
        return cm;
    }

    private List<ComparableModelItem> listComparableSMV(String projectKey) throws IOException {
        List<SavedModel> listSavedModels;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            listSavedModels = this.savedModelsCRUDService.list(projectKey);
        }
        return listSavedModels.stream().filter(sm -> sm.getType() == MLTask.MLTaskType.PREDICTION).flatMap(sm -> {
            try {
                return this.predictionSMMgmtService.listUsableVersions((SavedModel)sm).stream().filter(ModelComparisonsService::isComparableModel).flatMap(versionFmi -> {
                    try {
                        ResolvedCoreParams coreParams = null;
                        if (versionFmi.hasResolvedCoreParams()) {
                            coreParams = versionFmi.getResolvedCoreParams();
                        }
                        if (!(coreParams instanceof ResolvedClassicalPredictionCoreParams || coreParams instanceof ResolvedTimeseriesForecastingCoreParams || coreParams instanceof ResolvedCausalPredictionCoreParams || versionFmi.isExternalMLflowModelVersion())) {
                            return Stream.empty();
                        }
                        return Stream.of(this.comparableItemFromSMV((SavedModel)sm, (FullModelId)versionFmi));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Could not read saved model version " + String.valueOf(versionFmi)), (Throwable)e);
                        return Stream.empty();
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)("Error processing saved model " + sm.getFullId()), (Throwable)e);
                return Stream.empty();
            }
        }).collect(Collectors.toList());
    }

    static boolean isComparableModel(FullModelId versionFmi) {
        try {
            PredictionMLTask.PredictionType predictionType = versionFmi.getPredictionType();
            return predictionType == PredictionMLTask.PredictionType.REGRESSION || predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION || predictionType == PredictionMLTask.PredictionType.MULTICLASS || predictionType == PredictionMLTask.PredictionType.TIMESERIES_FORECAST || predictionType == PredictionMLTask.PredictionType.CAUSAL_REGRESSION || predictionType == PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION;
        }
        catch (Exception e) {
            logger.error((Object)("Error getting prediction type of " + String.valueOf(versionFmi)), (Throwable)e);
            return false;
        }
    }

    private ComparableAnalysisTrainedModel comparableItemFromTM(MLTask mlTask, AnalysisCoreParams acp, FullModelId fullModelId, TabularPredictionModelDetails modelDetails) throws Exception {
        ComparableAnalysisTrainedModel cm = new ComparableAnalysisTrainedModel();
        cm.evaluationMetric = modelDetails.modeling.metrics.evaluationMetric;
        List modelLabels = modelDetails.userMeta.labels;
        cm.labels = null != modelLabels ? modelLabels.stream().collect(Collectors.toMap(s -> s.key, s -> s.value, (key1, key2) -> key2)) : new HashMap();
        ResolvedPredictionCoreParams coreParams = modelDetails.getCoreParams();
        cm.modelTaskType = ModelComparison.ModelTaskType.from(coreParams.prediction_type);
        cm.targetVariable = coreParams.target_variable;
        cm.mli = fullModelId;
        cm.analysisName = acp.name + "(" + fullModelId.getTaskLoc().analysisId + ")";
        cm.mlTaskName = mlTask.name;
        cm.modelName = modelDetails.userMeta.name;
        cm.isPartitioned = coreParams.isPartitioned();
        cm.isEnsembled = null != modelDetails.modeling.ensemble_params;
        cm.createdOn = modelDetails.trainInfo.endTime;
        cm.classes = fullModelId.getClasses();
        cm.driftSupported = true;
        cm.modelUniqueId = fullModelId.toString();
        cm.displayName = cm.modelName;
        return cm;
    }

    private List<ComparableModelItem> listComparableTM(String projectKey) throws IOException {
        List<AnalysisCoreParams> listAnalysisCoreParams;
        ArrayList<ComparableModelItem> ret = new ArrayList<ComparableModelItem>();
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            listAnalysisCoreParams = this.analysisCRUDService.listCoreUnsafe(projectKey, null);
        }
        for (AnalysisCoreParams acp : listAnalysisCoreParams) {
            try {
                List<MLTask> listMLTasks;
                try (Transaction t = this.transactionService.retrieveOrBeginRead();){
                    listMLTasks = this.analysisCRUDService.listRawMLTasks(acp.projectKey, acp.id);
                }
                for (MLTask mlTask2 : listMLTasks.stream().filter(mlTask -> mlTask.taskType == MLTask.MLTaskType.PREDICTION).collect(Collectors.toList())) {
                    Transaction t = this.transactionService.retrieveOrBeginRead();
                    try {
                        MLTaskLoc mlTaskLoc = new MLTaskLoc(acp.projectKey, acp.id, mlTask2.id);
                        for (FullModelId fullModelId : this.predictionService.listTaskModelIds(mlTaskLoc)) {
                            try {
                                if (!ModelComparisonsService.isComparableModel(fullModelId) || fullModelId.isModelPartition()) continue;
                                TabularPredictionModelDetails modelDetails = (TabularPredictionModelDetails)PredictionResultsReader.makeModelDetails(fullModelId);
                                if (modelDetails.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) continue;
                                ret.add(this.comparableItemFromTM(mlTask2, acp, fullModelId, modelDetails));
                            }
                            catch (Exception e) {
                                logger.error((Object)("Could not load trained model " + String.valueOf(fullModelId)), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Could not list ML tasks for analysis " + acp.projectKey + "." + acp.id), (Throwable)e);
            }
        }
        return ret;
    }

    public List<AbstractComparableItemDetails> getComparableItemDetails_NT(List<ModelLikeId> modelLikeIds) {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<AbstractComparableItemDetails> ret = new ArrayList<AbstractComparableItemDetails>();
        for (ModelLikeId modelLikeId : modelLikeIds) {
            try {
                Transaction t = this.transactionService.beginRead();
                try {
                    if (modelLikeId instanceof FullModelId) {
                        FullModelId fmi = (FullModelId)modelLikeId;
                        if (!ModelComparisonsService.isComparableModel(fmi)) {
                            throw new IllegalArgumentException("Unsupported prediction type for model comparison: " + String.valueOf((Object)fmi.getPredictionType()));
                        }
                        TabularPredictionModelDetails details = (TabularPredictionModelDetails)PredictionResultsReader.makeModelDetails(fmi);
                        KernelsModelEvaluationStoresService.ModelTypeAndParams modelTypeAndParams = switch (fmi.getType()) {
                            case FullModelId.Type.SAVED -> {
                                SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatory(fmi.getSavedModelProjectKey(), fmi.getSavedModelID());
                                yield this.modelEvaluationStoresService.makeModelTypeAndParams(fmi.getProjectKey(), sm, fmi, details.trainInfo);
                            }
                            case FullModelId.Type.ANALYSIS -> KernelsModelEvaluationStoresService.makeModelTypeAndParams(fmi.getProjectKey(), fmi, details.trainInfo);
                            default -> throw new NotImplementedException("Unhandled full model id type: " + String.valueOf((Object)fmi.getType()));
                        };
                        SplitDesc splitDesc = ResultsReaderBase.readSplitDesc(fmi);
                        KernelsModelEvaluationStoresService.DataTypeAndParams trainDataTypeAndParams = this.kernelsModelEvaluationStoresService.makeTrainDataTypeAndParams(splitDesc, details.smOrigin == null ? null : details.smOrigin.fullModelId);
                        PredictionModelPerformanceMetrics metrics = new PredictionModelPerformanceMetrics();
                        ResolvedPredictionCoreParams rpcp = details.getCoreParams();
                        if (PredictionMLTask.PredictionType.TIMESERIES_FORECAST.equals((Object)rpcp.prediction_type)) {
                            PredictionResultsReader.fillTimeseriesPerformanceMetrics(metrics, (TimeseriesForecastingModelPerf)details.getPerf());
                        } else if (EnumSet.of(PredictionMLTask.PredictionType.BINARY_CLASSIFICATION, PredictionMLTask.PredictionType.MULTICLASS, PredictionMLTask.PredictionType.REGRESSION).contains((Object)rpcp.prediction_type)) {
                            PredictionResultsReader.fillClassicalPerformanceMetrics(metrics, fmi, (ClassicalPredictionModelDetails)details);
                        } else if (EnumSet.of(PredictionMLTask.PredictionType.CAUSAL_REGRESSION, PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION).contains((Object)rpcp.prediction_type)) {
                            PredictionResultsReader.fillCausalPerformanceMetrics(metrics, (CausalPredictionModelDetails)details);
                        } else {
                            throw new IllegalArgumentException("Unsupported prediction type for model comparison: " + String.valueOf((Object)rpcp.prediction_type));
                        }
                        ret.add(new TabularComparableItemDetails(details, modelLikeId, modelTypeAndParams, trainDataTypeAndParams, metrics, details.getCoreParams().prediction_type));
                        continue;
                    }
                    if (modelLikeId instanceof FullModelEvaluationId) {
                        FullModelEvaluationId fme = (FullModelEvaluationId)modelLikeId;
                        ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getMandatory(fme.getProjectKey(), fme.getId());
                        ModelEvaluationStoresCRUDService.AbstractModelEvaluationDetails evaluationFullInfo = this.modelEvaluationStoresCRUDService.getEvaluationDetails(mes, fme.evaluationId);
                        if (evaluationFullInfo.isTabular()) {
                            ret.add(new TabularComparableItemDetails((ModelEvaluationStoresCRUDService.TabularModelEvaluationDetails)evaluationFullInfo, modelLikeId));
                            continue;
                        }
                        if (evaluationFullInfo.isLLM()) {
                            ret.add(new LLMComparableItemDetails((ModelEvaluationStoresCRUDService.LLMModelEvaluationDetails)evaluationFullInfo, modelLikeId));
                            continue;
                        }
                        if (evaluationFullInfo.isAgent()) {
                            ret.add(new AgentComparableItemDetails((ModelEvaluationStoresCRUDService.AgentEvaluationDetails)evaluationFullInfo, modelLikeId));
                            continue;
                        }
                        throw new IllegalArgumentException("Only Tabular, LLM and Agent Model Evaluations can be used for comparisons.");
                    }
                    throw new RuntimeException("Unsupported model ID");
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Could not load " + modelLikeId.toString()), (Throwable)e);
                ret.add(null);
            }
        }
        return ret;
    }

    public static enum MELikesSource {
        FROM_MES,
        FROM_SAVED_MODELS,
        FROM_ANALYSIS;

    }

    static class TabularComparableModelEvaluation
    extends TabularComparableModelItem {
        public String storeName;
        public String evaluationName;
        public FullModelId evaluatedSavedModelVersion;
        public TabularModelEvaluation.ModelType modelType;

        TabularComparableModelEvaluation() {
        }
    }

    static class ComparableSavedModelVersion
    extends TabularComparableModelItem {
        public String savedModelName;
        public String savedModelVersionName;
        public boolean isActive;

        ComparableSavedModelVersion() {
        }
    }

    static class LLMComparableModelEvaluation
    extends GenAiComparableModelEvaluation {
        @Nullable
        public String contextColumnName;

        LLMComparableModelEvaluation() {
        }
    }

    static class AgentComparableModelEvaluation
    extends GenAiComparableModelEvaluation {
        @Nullable
        public String referenceToolCallsColumnName;
        @Nullable
        public String actualToolCallsColumnName;

        AgentComparableModelEvaluation() {
        }
    }

    @PolyJSON(value={@Mapping(value=ComparableSavedModelVersion.class, type="SAVED_MODEL_VERSION"), @Mapping(value=ComparableAnalysisTrainedModel.class, type="ANALYSIS_TRAINED_MODEL"), @Mapping(value=TabularComparableModelEvaluation.class, type="MODEL_EVALUATION"), @Mapping(value=LLMComparableModelEvaluation.class, type="LLM_MODEL_EVALUATION"), @Mapping(value=AgentComparableModelEvaluation.class, type="AGENT_MODEL_EVALUATION")})
    public static abstract class ComparableModelItem {
        public ModelLikeId mli;
        public String displayName;
        public Map<String, String> labels;
        public ModelComparison.ModelTaskType modelTaskType;
        public long createdOn;
        public boolean isCompatibleReference;
        boolean hasModel = true;

        public abstract boolean canBeUsedToComputeDriftAgainst(ComparableModelItem var1);

        public abstract boolean canBeUsedToComputeDataDriftAgainst(ComparableModelItem var1);

        public abstract boolean canBeUsedToComputePredictionDriftAgainst(ComparableModelItem var1);
    }

    static class ComparableAnalysisTrainedModel
    extends TabularComparableModelItem {
        public MLTaskLoc mlTaskLoc;
        public String analysisName;
        public String mlTaskName;
        public String modelName;

        ComparableAnalysisTrainedModel() {
        }
    }

    public static class TabularComparableItemDetails
    extends AbstractComparableItemDetails {
        public final MetricParams metricParams;
        public final TabularPredictionModelDetails details;
        public final TabularModelEvaluation.ModelType modelType;
        public final JsonObject modelParams;
        public AbstractModelEvaluation.DataType trainDataType;
        public JsonObject trainDataParams;

        TabularComparableItemDetails(TabularPredictionModelDetails details, ModelLikeId ref, KernelsModelEvaluationStoresService.ModelTypeAndParams modelTypeAndParams, KernelsModelEvaluationStoresService.DataTypeAndParams trainDataTypeAndParams, PredictionModelPerformanceMetrics metrics, PredictionMLTask.PredictionType predictionType) {
            super(ref, metrics, ModelComparison.ModelTaskType.from(predictionType));
            this.modelLikeType = ModelLikeId.ModelLikeType.DOCTOR_MODEL;
            this.details = details;
            this.userMeta = details.userMeta;
            this.metricParams = details.modeling == null ? null : details.modeling.metrics;
            this.modelType = modelTypeAndParams.type;
            this.modelParams = modelTypeAndParams.params;
            if (null != trainDataTypeAndParams) {
                this.trainDataType = trainDataTypeAndParams.type;
                this.trainDataParams = trainDataTypeAndParams.params;
            }
        }

        TabularComparableItemDetails(ModelEvaluationStoresCRUDService.TabularModelEvaluationDetails evaluationFullInfo, ModelLikeId ref) {
            super(ref, evaluationFullInfo.metrics, ModelComparison.ModelTaskType.from(((TabularModelEvaluation)evaluationFullInfo.evaluation).predictionType));
            TabularModelEvaluation tabularModelEvaluation = (TabularModelEvaluation)evaluationFullInfo.evaluation;
            this.modelLikeType = ModelLikeId.ModelLikeType.MODEL_EVALUATION;
            this.details = evaluationFullInfo.details;
            this.metricParams = tabularModelEvaluation.metricParams;
            this.userMeta = tabularModelEvaluation.userMeta;
            this.trainDataType = tabularModelEvaluation.trainDataType;
            this.trainDataParams = tabularModelEvaluation.trainDataParams;
            this.dataType = tabularModelEvaluation.dataType;
            this.dataParams = tabularModelEvaluation.dataParams;
            this.modelType = tabularModelEvaluation.modelType;
            this.modelParams = tabularModelEvaluation.modelParams;
        }
    }

    public static class LLMComparableItemDetails
    extends AbstractComparableItemDetails {
        List<GenAiCustomEvaluationMetric> customMetrics;
        List<CustomEvaluationTrait> customTraits;

        LLMComparableItemDetails(ModelEvaluationStoresCRUDService.LLMModelEvaluationDetails evaluationFullInfo, ModelLikeId ref) {
            super(ref, evaluationFullInfo.metrics, ModelComparison.ModelTaskType.LLM);
            LLMModelEvaluation llmModelEvaluation = (LLMModelEvaluation)evaluationFullInfo.evaluation;
            this.modelLikeType = ModelLikeId.ModelLikeType.MODEL_EVALUATION;
            this.customMetrics = llmModelEvaluation.customMetrics;
            this.customTraits = llmModelEvaluation.customTraits;
            this.userMeta = llmModelEvaluation.userMeta;
            this.dataType = llmModelEvaluation.dataType;
            this.dataParams = llmModelEvaluation.dataParams;
        }
    }

    public static class AgentComparableItemDetails
    extends AbstractComparableItemDetails {
        List<GenAiCustomEvaluationMetric> customMetrics;
        List<CustomEvaluationTrait> customTraits;

        AgentComparableItemDetails(ModelEvaluationStoresCRUDService.AgentEvaluationDetails evaluationFullInfo, ModelLikeId ref) {
            super(ref, evaluationFullInfo.metrics, ModelComparison.ModelTaskType.AGENT);
            AgentModelEvaluation agentModelEvaluation = (AgentModelEvaluation)evaluationFullInfo.evaluation;
            this.modelLikeType = ModelLikeId.ModelLikeType.MODEL_EVALUATION;
            this.customMetrics = agentModelEvaluation.customMetrics;
            this.customTraits = agentModelEvaluation.customTraits;
            this.userMeta = agentModelEvaluation.userMeta;
            this.dataType = agentModelEvaluation.dataType;
            this.dataParams = agentModelEvaluation.dataParams;
        }
    }

    static class GenAiComparableModelEvaluation
    extends ComparableModelItem {
        public String storeName;
        public String evaluationName;
        @Nonnull
        public String inputColumnName;
        @Nullable
        public String outputColumnName;
        @Nullable
        public String groundTruthColumnName;

        GenAiComparableModelEvaluation() {
        }

        @Override
        public boolean canBeUsedToComputeDriftAgainst(ComparableModelItem other) {
            return false;
        }

        @Override
        public boolean canBeUsedToComputeDataDriftAgainst(ComparableModelItem other) {
            return false;
        }

        @Override
        public boolean canBeUsedToComputePredictionDriftAgainst(ComparableModelItem other) {
            return false;
        }
    }

    public static abstract class AbstractComparableItemDetails {
        public BaseUserMeta userMeta;
        public final ModelLikeId ref;
        public ModelLikeId.ModelLikeType modelLikeType;
        public AbstractModelEvaluation.DataType dataType;
        public JsonObject dataParams;
        public final EvaluationMetrics metrics;
        public final ModelComparison.ModelTaskType modelTaskType;

        AbstractComparableItemDetails(ModelLikeId ref, EvaluationMetrics metrics, ModelComparison.ModelTaskType modelTaskType) {
            this.ref = ref;
            this.metrics = metrics;
            this.modelTaskType = modelTaskType;
        }
    }

    public static abstract class TabularComparableModelItem
    extends ComparableModelItem {
        public String targetVariable;
        public MetricParams.EvaluationMetric evaluationMetric;
        public boolean isPartitioned;
        public boolean isEnsembled;
        String modelUniqueId;
        Set<String> classes;
        boolean driftSupported;
        boolean hasDriftReference;

        @Override
        public boolean canBeUsedToComputeDriftAgainst(ComparableModelItem other) {
            if (!(other instanceof TabularComparableModelItem)) {
                return false;
            }
            return this.canBeUsedToComputePredictionDriftAgainst(other) && Objects.equals(this.targetVariable, ((TabularComparableModelItem)other).targetVariable);
        }

        @Override
        public boolean canBeUsedToComputeDataDriftAgainst(ComparableModelItem other) {
            if (!(other instanceof TabularComparableModelItem)) {
                return false;
            }
            return this.driftSupported && ((TabularComparableModelItem)other).driftSupported;
        }

        @Override
        public boolean canBeUsedToComputePredictionDriftAgainst(ComparableModelItem other) {
            if (!(other instanceof TabularComparableModelItem)) {
                return false;
            }
            return this.canBeUsedToComputeDataDriftAgainst(other) && Objects.equals((Object)this.modelTaskType, (Object)other.modelTaskType) && Objects.equals(this.classes, ((TabularComparableModelItem)other).classes);
        }
    }
}

