/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notebooks;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.services.JupyterUtils;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JupyterVirtualPathService {
    @Autowired
    private ImpersonationResolverService impersonationService;

    public boolean isNotebookIsolationByDSSUserEnabled() {
        return DKUApp.getParams().getBoolParam("dku.jupyter.security.isolate_per_dss_user", false);
    }

    public String getSessionVirtualPath(String projectKey, String notebookId, AuthCtx authCtx) throws DKUSecurityException, IOException, InterruptedException {
        Object prefix = "";
        if (this.isNotebookIsolationByDSSUserEnabled()) {
            prefix = authCtx.getIdentifier().replaceAll("[^A-Za-z0-9]", "_") + "__DKU__";
        }
        if (this.impersonationService.isEnabled()) {
            String unixUser = this.impersonationService.getTargetUser((String)projectKey, (AuthCtx)authCtx).unixUser;
            return (String)prefix + unixUser + "__DKU__" + projectKey + "__DKU__" + notebookId;
        }
        return (String)prefix + projectKey + "__DKU__" + notebookId;
    }

    public boolean parseVirtualPath(JupyterUtils.ActiveSession as, String virtualPath) {
        String[] pathChunks = virtualPath.split("__DKU__");
        boolean skip = false;
        if (this.isNotebookIsolationByDSSUserEnabled()) {
            if (pathChunks.length == 3) {
                as.projectKey = pathChunks[1];
                as.notebookName = pathChunks[2];
            } else if (pathChunks.length == 4) {
                as.sessionUnixOwner = pathChunks[1];
                as.projectKey = pathChunks[2];
                as.notebookName = pathChunks[3];
            } else {
                skip = true;
            }
        } else if (pathChunks.length == 2) {
            as.projectKey = pathChunks[0];
            as.notebookName = pathChunks[1];
        } else if (pathChunks.length == 3) {
            as.sessionUnixOwner = pathChunks[0];
            as.projectKey = pathChunks[1];
            as.notebookName = pathChunks[2];
        } else {
            skip = true;
        }
        return skip;
    }
}

