/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractCustomAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;

public class TensorCustomAggregator
extends AbstractCustomAggregator {
    public LongDataTensor countTensor;

    public TensorCustomAggregator(Aggregation req, int[] bins, VariablesContext variablesContext, LinoReader linoReader) {
        super(req, bins, variablesContext, linoReader);
    }

    @Override
    public void handleBlock(ColumnBlock aggrColumn, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        long nonNullCount = Long.MIN_VALUE;
        for (AbstractAggregator aggregator : this.otherAggregators) {
            aggregator.handleBlock((ColumnBlock)this.columnsBlock.get(aggregator.req.column), start, rows, coords, bins, filters, fillAxes);
            if (aggregator.getOutDT().hasNullValues) {
                this.getOutDT().hasNullValues = true;
            }
            nonNullCount = Math.max(nonNullCount, aggregator.getNonNullCount(coords));
        }
        this.getOutDT().nonNullCounts[this.getOutDT().loc((int[])coords)] = nonNullCount;
        for (int i = 0; i < this.getOutDT().axesNonNullCounts.length; ++i) {
            long axeNonNullCount = Long.MIN_VALUE;
            for (AbstractAggregator aggregator : this.otherAggregators) {
                axeNonNullCount = Math.max(nonNullCount, aggregator.getAxisNonNullCount(i, coords[i]));
            }
            this.getOutDT().axesNonNullCounts[i][coords[i]] = axeNonNullCount;
        }
    }

    @Override
    public void end() throws IOException {
        int i;
        super.end();
        for (AbstractAggregator otherAggregator : this.otherAggregators) {
            otherAggregator.end();
            otherAggregator.parentReference.getValueForRow = loc -> otherAggregator.getValue(loc, this.countTensor);
        }
        for (i = 0; i < this.getOutDT().tensorSize; ++i) {
            this.getOutDT().set(i, this.doCalculation(this.expression.evaluable, i));
        }
        for (i = 0; i < this.getOutDT().numAxes; ++i) {
            for (AbstractAggregator otherAggregator : this.otherAggregators) {
                int finalI = i;
                otherAggregator.parentReference.getValueForRow = loc -> otherAggregator.getAxisValue(finalI, loc, this.getOutDT().axesNonNullCounts);
            }
            for (int x = 0; x < this.getOutDT().getAxisLength(i); ++x) {
                this.getOutDT().setAxis(i, x, this.doCalculation(this.expression.evaluable, x));
            }
        }
    }

    @Override
    public boolean mergeTensorAndAxes(PivotTableTensorRequest request, int[] origCoordinates, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
        boolean shouldIncrementNonNull = true;
        for (AbstractAggregator otherAggregator : this.otherAggregators) {
            if (otherAggregator.mergeTensorAndAxes(request, origCoordinates, targetCoordinates, axes)) continue;
            shouldIncrementNonNull = false;
        }
        if (shouldIncrementNonNull && this.getOutDT().hasNullValues) {
            this.getMergeDT().incrementNonNullCount(targetCoordinates, this.getOutDT().getNonNullCount(origCoordinates));
        }
        return true;
    }

    @Override
    public void mergeEnd(AxisHandler.Axis[] axes, LongDataTensor countTensor) throws IOException {
        int i;
        for (AbstractAggregator aggregator : this.otherAggregators) {
            aggregator.mergeEnd(axes, countTensor);
            aggregator.parentReference.getValueForRow = loc -> aggregator.getMergeDTValue(loc, true);
        }
        for (i = 0; i < this.getMergeDT().tensorSize; ++i) {
            this.getMergeDT().set(i, this.doCalculation(this.expression.evaluable, i), true);
        }
        for (i = 0; i < this.getMergeDT().numAxes; ++i) {
            int finalI = i;
            for (AbstractAggregator otherAggregator : this.otherAggregators) {
                otherAggregator.parentReference.getValueForRow = loc -> otherAggregator.getMergeDT().getAxis(finalI, loc);
            }
            for (int x = 0; x < this.getMergeDT().getAxisLength(i); ++x) {
                this.getMergeDT().setAxis(i, x, this.doCalculation(this.expression.evaluable, x));
            }
        }
        super.mergeEnd(axes, countTensor);
    }
}

