/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DoubleList;
import com.dataiku.dip.utils.LongList;

public class BinUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.binning");

    public static NiceBounds computeNiceBounds(int nbBins, double min, double max) {
        double span = max - min;
        if (span < Double.MIN_NORMAL) {
            span = 1.0;
            nbBins = 1;
        }
        double m = nbBins;
        double ln10 = 2.30258509299;
        double stepOrig = Math.pow(10.0, Math.floor(Math.log(span / m) / ln10));
        double step = stepOrig;
        double err = m / span * step;
        if (err <= 0.15) {
            step *= 10.0;
        } else if (err <= 0.35) {
            step *= 5.0;
        } else if (err <= 0.75) {
            step *= 2.0;
        }
        double fixedMin = Math.floor(min / step) * step;
        double fixedMax = Math.ceil(max / step) * step;
        step = (fixedMax - fixedMin) / (double)nbBins;
        NiceBounds nb = new NiceBounds();
        fixedMin = Double.isNaN(fixedMin) ? min : fixedMin;
        fixedMax = Double.isNaN(fixedMax) ? max : fixedMax;
        nb.minValue = Math.min(min, fixedMin);
        nb.maxValue = Math.max(max, fixedMax);
        nb.step = step;
        logger.infoV("min=%f max=%f span=%f bins=%d stepOrig=%f step=%f err=%f fixedMin=%f fixedMax=%f", new Object[]{nb.minValue, nb.maxValue, span, nbBins, stepOrig, step, err, fixedMin, fixedMax});
        return nb;
    }

    public static double[][] buildCompactHistogram(int[] histogram, double[] histogramLowerBounds, double[] histogramUpperBounds, int nbBins) {
        double[][] chistogram = new double[nbBins][];
        for (int i = 0; i < nbBins; ++i) {
            chistogram[i] = new double[]{histogramLowerBounds[i], histogramUpperBounds[i], histogram[i]};
        }
        return chistogram;
    }

    public static int[] buildHistogram(DoubleList histogramValues, LongList histogramBars, double[] histogramUpperBounds, int nbBins) {
        int[] histogram = new int[nbBins];
        int nextValueIdx = 0;
        for (int i = 0; i < nbBins; ++i) {
            int count = 0;
            while (nextValueIdx < histogramValues.size() && !(histogramValues.get(nextValueIdx) > histogramUpperBounds[i])) {
                count = (int)((long)count + histogramBars.get(nextValueIdx));
                ++nextValueIdx;
            }
            histogram[i] = count;
        }
        return histogram;
    }

    public static double[] buildLowerBounds(int nbBins, double min, double step) {
        double[] histogramLowerBounds = new double[nbBins];
        for (int i = 0; i < nbBins; ++i) {
            histogramLowerBounds[i] = min + step * (double)i;
        }
        return histogramLowerBounds;
    }

    public static double[] buildUpperBounds(int nbBins, double min, double max, double step) {
        double[] histogramUpperBounds = new double[nbBins];
        for (int i = 0; i < nbBins; ++i) {
            double thisBarMax = min + step * (double)(i + 1);
            if (i == nbBins - 1) {
                thisBarMax = Math.max(thisBarMax, max);
            }
            histogramUpperBounds[i] = thisBarMax;
        }
        return histogramUpperBounds;
    }

    public static HistogramParams getHistogramParams(boolean niceBounds, int nbBins, double min, double max) {
        HistogramParams params = new HistogramParams();
        params.nbBins = nbBins;
        if (max - min < Double.MIN_NORMAL) {
            params.nbBins = 1;
        }
        if (niceBounds) {
            NiceBounds nb = BinUtils.computeNiceBounds(params.nbBins, min, max);
            params.fixedMin = nb.minValue;
            params.fixedMax = nb.maxValue;
            params.step = nb.step;
        } else {
            params.fixedMin = min;
            params.fixedMax = max;
            params.step = (max - min) / (double)params.nbBins;
        }
        return params;
    }

    public static class NiceBounds {
        public double minValue;
        public double maxValue;
        public double step;
    }

    public static class HistogramParams {
        public double fixedMin;
        public double fixedMax;
        public double step;
        public int nbBins;
    }
}

