/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.BorderStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Font;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.IndexedColors;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.VerticalAlignment;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFFont;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class CellStyler {
    private final Workbook workbook;
    private Map<String, CellStyle> styleCache = new HashMap<String, CellStyle>();
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public CellStyler(Workbook workbook) {
        this.workbook = (Workbook)Preconditions.checkNotNull((Object)workbook);
    }

    public CellStyle getHeaderStyle() {
        String key = "HeaderStyle";
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            Font font = this.workbook.createFont();
            font.setBold(true);
            font.setFontHeightInPoints((short)9);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            style.setBorderTop(BorderStyle.THIN);
            this.styleCache.put(key, style);
        }
        return style;
    }

    public CellStyle getValueStyle(boolean isLast, boolean isAxisColumn) {
        return this.getValueStyle(isLast, isAxisColumn, SpecialFormat.NONE);
    }

    public CellStyle getValueStyle(boolean isLast, boolean isAxisColumn, SpecialFormat format) {
        String key = "value" + isLast + isAxisColumn + String.valueOf((Object)format);
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            style = this.workbook.createCellStyle();
            Font font = this.workbook.createFont();
            font.setFontHeightInPoints((short)9);
            if (isAxisColumn) {
                font.setBold(true);
            }
            style.setFont(font);
            style.setBorderRight(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setVerticalAlignment(VerticalAlignment.TOP);
            if (isLast) {
                style.setBorderBottom(BorderStyle.THIN);
            }
            this.setStyleFormat((XSSFCellStyle)style, format);
            this.styleCache.put(key, style);
        }
        return style;
    }

    public void setStyleFormat(XSSFCellStyle style, SpecialFormat format) {
        if (format == SpecialFormat.PERCENTAGE) {
            style.setDataFormat(this.workbook.createDataFormat().getFormat("0.00%"));
        }
        if (format == SpecialFormat.DATE) {
            style.setDataFormat(this.workbook.createDataFormat().getFormat(DATE_FORMAT));
        }
    }

    public void setStyleFormat(XSSFCellStyle style, TensorType format) {
        if (format == TensorType.DATE) {
            this.setStyleFormat(style, SpecialFormat.DATE);
        }
    }

    public XSSFFont getValueFont(XSSFColor color) {
        XSSFFont font;
        String key = "ColorValue" + color.toString();
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            font = (XSSFFont)this.workbook.createFont();
            font.setFontHeightInPoints((short)9);
            font.setColor(color);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            this.styleCache.put(key, style);
        } else {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
            font = xssfStyle.getFont();
        }
        return font;
    }

    public XSSFFont getLightValueFont() {
        XSSFFont font;
        String key = "LightFontStyle";
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            font = (XSSFFont)this.workbook.createFont();
            font.setColor(IndexedColors.WHITE.getIndex());
            font.setFontHeightInPoints((short)9);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            this.styleCache.put(key, style);
        } else {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
            font = xssfStyle.getFont();
        }
        return font;
    }

    public CellStyle getLightValueFontStyle() {
        String key = "LightFontStyle";
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            Font font = this.workbook.createFont();
            font.setColor(IndexedColors.WHITE.getIndex());
            font.setFontHeightInPoints((short)9);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            this.styleCache.put(key, style);
        }
        return style;
    }

    public CellStyle getTitleStyle() {
        String key = "TitleStyle";
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            Font font = this.workbook.createFont();
            font.setBold(true);
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            this.styleCache.put(key, style);
        }
        return style;
    }

    public CellStyle getSubtitleStyle() {
        String key = "SubtitleStyle";
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            Font font = this.workbook.createFont();
            font.setBold(true);
            font.setFontHeightInPoints((short)10);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            this.styleCache.put(key, style);
        }
        return style;
    }

    public CellStyle getSubtitleStyle(SpecialFormat format) {
        String key = "SubtitleStyle_" + String.valueOf((Object)format);
        CellStyle style = this.styleCache.get(key);
        if (style == null) {
            Font font = this.workbook.createFont();
            font.setBold(true);
            font.setFontHeightInPoints((short)10);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            if (format == SpecialFormat.DATE) {
                style.setDataFormat(this.workbook.createDataFormat().getFormat(DATE_FORMAT));
            }
            this.styleCache.put(key, style);
        }
        return style;
    }

    public static enum SpecialFormat {
        NONE,
        PERCENTAGE,
        DATE;

    }
}

