/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport.timeline;

import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.db.SingleH2DatabaseConnectionsFactory;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.timeline.ITimelineImporter;
import com.dataiku.dip.projects.importexport.timeline.TimelineItemToJSONConverter;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.timelines.ProjectTimeline;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.timelines.ProjectTimelineInternalDB;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.Statement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimelineImporterProvider {
    @Autowired
    protected TimelinesService timelinesService;

    public ITimelineImporter importer(File importSourceDirectory, String targetProjectKey, ExportedProject exportedProject) throws Exception {
        File jsonFile = new File(new File(importSourceDirectory, "timelines"), "timeline.txt");
        if (jsonFile.exists()) {
            return new JsonTimelineImporter(jsonFile, targetProjectKey, exportedProject);
        }
        File pageStoreDbFile = new File(new File(importSourceDirectory, "timelines"), "timeline.h2.db");
        if (pageStoreDbFile.exists()) {
            return new H2TimelineImporter(pageStoreDbFile, targetProjectKey, exportedProject);
        }
        File mvStoreDbFile = new File(new File(importSourceDirectory, "timelines"), "timeline.mv.db");
        if (mvStoreDbFile.exists()) {
            return new H2TimelineImporter(mvStoreDbFile, targetProjectKey, exportedProject);
        }
        throw new Exception("No timelines db found (neither h2.db nor mv.db nor json)");
    }

    private class JsonTimelineImporter
    extends AbstractTimelineImporter {
        private final File src;

        JsonTimelineImporter(File src, String targetProjectKey, ExportedProject exportedProject) {
            super(targetProjectKey, exportedProject);
            this.src = src;
        }

        @Override
        public void importTimelineItems() throws Exception {
            logger.info((Object)("Import json timelines: " + this.src.getAbsolutePath()));
            try (FileInputStream fileInputStream = new FileInputStream(this.src);
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));){
                String timelineItemAsJSON;
                while ((timelineItemAsJSON = bufferedReader.readLine()) != null) {
                    TimelineItem timelineItem = new TimelineItemToJSONConverter().convertFromJSON(timelineItemAsJSON);
                    timelineItem.projectKey = this.targetProjectKey;
                    TimelineImporterProvider.this.timelinesService.pushWithoutNotification(timelineItem);
                }
            }
        }
    }

    private class H2TimelineImporter
    extends AbstractTimelineImporter {
        private final File src;

        H2TimelineImporter(File src, String targetProjectKey, ExportedProject exportedProject) {
            super(targetProjectKey, exportedProject);
            this.src = src;
        }

        @Override
        public void importTimelineItems() throws Exception {
            String dbName = this.src.getAbsolutePath().replace(".mv.db", "").replace(".h2.db", "");
            String jdbcUrl = DSSDBConnectionsManagementService.buildH2JdbcUrl("timeline", false, new File(dbName), 1000, "timeline");
            DSSDBConnectionsManagementService.ConnectionPool sourceDBConnectionPool = new DSSDBConnectionsManagementService.ConnectionPool(new SingleH2DatabaseConnectionsFactory("timeline-import", "timeline-import", jdbcUrl));
            ProjectTimeline timeline = new ProjectTimeline();
            ProjectTimelineBehavior behavior = new ProjectTimelineBehavior(this.targetProjectKey, this.dao.resolveTable("TIMELINE_ITEM"), new H2SQLDialect());
            try (DSSDBConnection conn = sourceDBConnectionPool.borrowObject();
                 Statement st2 = conn.createStatement();
                 ResultSet rs2 = st2.executeQuery("SELECT * FROM TIMELINE_ITEM");){
                while (rs2.next()) {
                    try {
                        timeline.items.add(behavior.readTimelineItem(rs2));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to read timeline item", (Throwable)e);
                    }
                }
            }
            for (TimelineItem item : timeline.items) {
                TimelineImporterProvider.this.timelinesService.pushWithoutNotification(item);
            }
        }
    }

    private abstract class AbstractTimelineImporter
    implements ITimelineImporter {
        protected final String targetProjectKey;
        protected ProjectTimelineInternalDB dao;
        private ExportedProject exportedProject;

        AbstractTimelineImporter(String targetProjectKey, ExportedProject exportedProject) {
            this.targetProjectKey = targetProjectKey;
            this.dao = new ProjectTimelineInternalDB(targetProjectKey);
            this.exportedProject = exportedProject;
        }

        @Override
        public void importTimeline() throws Exception {
            this.clearCurrentDBFile();
            this.importTimelineItems();
            this.migrateCommentsToDiscussions();
            this.migrateArticlesToNumericIds();
        }

        void clearCurrentDBFile() throws Exception {
            try (DSSDBConnection conn = this.dao.acquireConnection();){
                this.dao.behavior.delete(conn);
            }
        }

        void migrateCommentsToDiscussions() throws Exception {
            try (DSSDBConnection conn = this.dao.acquireConnection();){
                this.dao.behavior.migrateCommentsToDiscussions(conn);
            }
        }

        void migrateArticlesToNumericIds() throws Exception {
            if (Integer.parseInt(this.exportedProject.generatedWithDSSConfVersion) < 25) {
                try (DSSDBConnection conn = this.dao.acquireConnection();){
                    this.dao.behavior.migrateArticlesToNumericIds(conn);
                }
            }
        }

        abstract void importTimelineItems() throws Exception;
    }
}

