/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport.timeline;

import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class TimelineItemToJSONConverter {
    private static final String LINE_BREAK = "\n";
    private static final String ESCAPED_LINE_BREAK = "_lbrk_";

    public String convertToJSON(TimelineItem timelineItem) {
        return JSON.json((Object)new EscapedTimelineItem(timelineItem));
    }

    TimelineItem convertFromJSON(String timelineItemAsJSON) {
        return this.toTimelineItem((EscapedTimelineItem)JSON.parse((String)timelineItemAsJSON, EscapedTimelineItem.class));
    }

    private TimelineItem toTimelineItem(EscapedTimelineItem escapedTimelineItem) {
        RestoreJsonObject converter = new RestoreJsonObject();
        TimelineItem result = new TimelineItem();
        result.user = converter.restoreLineBreaks(escapedTimelineItem.user);
        result.action = TaggableObjectChangedEvent.ActionType.valueOf(escapedTimelineItem.action);
        result.projectKey = escapedTimelineItem.projectKey;
        result.objectType = ITaggingService.TaggableType.valueOf(escapedTimelineItem.objectType);
        result.objectId = converter.restoreLineBreaks(escapedTimelineItem.objectId);
        result.details = converter.convert(escapedTimelineItem.details);
        result.time = escapedTimelineItem.time;
        return result;
    }

    private class EscapedTimelineItem {
        private final String user;
        private final String action;
        private final String projectKey;
        private final String objectType;
        private final String objectId;
        private final JsonObject details;
        private final long time;

        private EscapedTimelineItem(TimelineItem timelineItem) {
            EscapeJsonObject converter = new EscapeJsonObject();
            this.user = converter.escapeLineBreaks(timelineItem.user);
            this.action = timelineItem.action.name();
            this.projectKey = timelineItem.projectKey;
            this.objectType = timelineItem.objectType.name();
            this.objectId = converter.escapeLineBreaks(timelineItem.objectId);
            this.details = converter.convert(timelineItem.details);
            this.time = timelineItem.time;
        }
    }

    private class RestoreJsonObject
    extends JsonObjectConverter {
        private RestoreJsonObject() {
        }

        @Override
        String convertValue(String value) {
            return this.restoreLineBreaks(value);
        }

        private String restoreLineBreaks(String fieldToRestore) {
            return fieldToRestore.replace(TimelineItemToJSONConverter.ESCAPED_LINE_BREAK, TimelineItemToJSONConverter.LINE_BREAK);
        }
    }

    private class EscapeJsonObject
    extends JsonObjectConverter {
        private EscapeJsonObject() {
        }

        @Override
        String convertValue(String value) {
            return this.escapeLineBreaks(value);
        }

        private String escapeLineBreaks(String fieldToEscape) {
            return fieldToEscape.replace(TimelineItemToJSONConverter.LINE_BREAK, TimelineItemToJSONConverter.ESCAPED_LINE_BREAK);
        }
    }

    private abstract class JsonObjectConverter {
        private JsonObjectConverter() {
        }

        JsonObject convert(JsonObject jsonObject) {
            JsonObject escapedJsonObject = new JsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                escapedJsonObject.add((String)entry.getKey(), this.convertElement((JsonElement)entry.getValue()));
            }
            return escapedJsonObject;
        }

        private JsonElement convertElement(JsonElement fieldToProcess) {
            if (fieldToProcess.isJsonPrimitive() && fieldToProcess.getAsJsonPrimitive().isString()) {
                return new JsonPrimitive(this.convertValue(fieldToProcess.getAsString()));
            }
            return fieldToProcess;
        }

        abstract String convertValue(String var1);
    }
}

