/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.eda.EDARecipeMeta;
import com.dataiku.dip.recipes.eda.PCARecipeCreator;
import com.dataiku.dip.recipes.eda.PCARecipeOutputRole;
import com.dataiku.dip.recipes.eda.PCARecipePayloadParams;
import com.dataiku.dip.recipes.eda.PCARecipeRunner;
import com.dataiku.dip.recipes.eda.PCARecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;

public class PCARecipeMeta
extends EDARecipeMeta {
    private static final String TYPE = "eda_pca";
    public static final PCARecipeMeta META = new PCARecipeMeta();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new PCARecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) throws Exception {
        return new PCARecipeRunner(activity);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new PCARecipeCreator(authCtx, this);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc desc = new RecipeDesc("PCA", "Run PCA on a dataset");
        RecipeDesc.IORoleDef inputDs = RecipeDesc.IORoleDef.newUnaryRequiredDataset("main", "Input");
        desc.inputRoles.add(inputDs);
        RecipeDesc.IORoleDef projections = RecipeDesc.IORoleDef.newUnaryDataset(PCARecipeOutputRole.PROJECTIONS.name, "Projections");
        projections.description = "Holds the projections of the input variables on the principal components";
        desc.outputRoles.add(projections);
        RecipeDesc.IORoleDef eigenvectors = RecipeDesc.IORoleDef.newUnaryDataset(PCARecipeOutputRole.EIGENVECTORS.name, "Eigenvectors");
        eigenvectors.description = "Holds the principal components";
        desc.outputRoles.add(eigenvectors);
        RecipeDesc.IORoleDef eigenvalues = RecipeDesc.IORoleDef.newUnaryDataset(PCARecipeOutputRole.EIGENVALUES.name, "Eigenvalues");
        eigenvalues.description = "Holds the amount of variance in the input dataset explained by each principal component";
        desc.outputRoles.add(eigenvalues);
        return desc;
    }

    @Override
    public PCARecipePayloadParams parsePayload(String payload) {
        return (PCARecipePayloadParams)JSON.parse((String)payload, PCARecipePayloadParams.class);
    }
}

