/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/publicapi/project-folders"})
public class PublicAPIProjectFoldersController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectFoldersService projectFoldersService;

    @AuditedCall(value={"msgType", "project-folders-get-root"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderOneLevelSummary getRoot(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.projectFoldersService.cleanUpProjectFolders_NT(false);
        try (Transaction ignored = this.transactionService.beginRead();){
            ProjectFoldersService.ProjectFolderOneLevelSummary projectFolderOneLevelSummary = this.projectFoldersService.getProjectFolderSummaryOneLevelMandatoryUnsafe_Check(authCtx, null);
            return projectFolderOneLevelSummary;
        }
    }

    @AuditedCall(value={"msgType", "project-folders-hierarchy"})
    @RequestMapping(value={"/hierarchy/"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderSummary listAll(HttpServletRequest req) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.projectFoldersService.cleanUpProjectFolders_NT(false);
        try (Transaction ignored = this.transactionService.beginRead();){
            ProjectFoldersService.ProjectFolderSummary projectFolderSummary = this.projectFoldersService.hierarchyFromRoot_Check(authCtx);
            return projectFolderSummary;
        }
    }

    @AuditedCall(value={"msgType", "project-folders-hierarchy"})
    @RequestMapping(value={"/locate-project/{projectKey}"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderOneLevelSummary locateProject(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.projectFoldersService.cleanUpProjectFolders_NT(false);
        try (Transaction ignored = this.transactionService.beginRead();){
            ProjectFoldersService.ProjectFolderOneLevelSummary projectFolderOneLevelSummary = this.projectFoldersService.locateProject(authCtx, projectKey);
            return projectFolderOneLevelSummary;
        }
    }

    @AuditedCall(value={"msgType", "project-folders-get"})
    @RequestMapping(value={"/{folderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderOneLevelSummary get(HttpServletRequest req, @PathVariable String folderId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction ignored = this.transactionService.beginRead();){
            ProjectFoldersService.ProjectFolderOneLevelSummary projectFolderOneLevelSummary = this.projectFoldersService.getProjectFolderSummaryOneLevelMandatoryUnsafe_Check(authCtx, folderId);
            return projectFolderOneLevelSummary;
        }
    }

    @AuditedCall(value={"msgType", "project-folders-delete"})
    @RequestMapping(value={"/{folderId:.+}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(HttpServletRequest req, @PathVariable String folderId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            ProjectFolder pf = this.projectFoldersService.getMandatoryUnsafe_Uncheck(folderId);
            this.projectFoldersService.deleteFolder_Check(authCtx, folderId);
            t.commitV("Deleted folder %s (%s)", new Object[]{pf.name, folderId});
        }
    }

    @AuditedCall(value={"msgType", "project-folders-get-default-for-project-creation"})
    @RequestMapping(value={"/{folderId}/default-for-project-creation"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderOneLevelSummary getDefaultForProjectCreation(HttpServletRequest req, @PathVariable String folderId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return new ProjectFoldersService.ProjectFolderOneLevelSummary(this.projectFoldersService.getDefaultProjectFolderSummary_Unsafe_NT(authCtx, folderId));
    }

    @AuditedCall(value={"msgType", "project-folders-get-settings"})
    @RequestMapping(value={"/{folderId}/settings"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderSettings getSettings(HttpServletRequest req, @PathVariable String folderId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction ignored = this.transactionService.beginRead();){
            ProjectFoldersService.ProjectFolderSettings projectFolderSettings = this.projectFoldersService.getProjectFolderSettingsMandatoryUnsafe_Check(authCtx, folderId);
            return projectFolderSettings;
        }
    }

    @AuditedCall(value={"msgType", "project-folders-set-settings"})
    @RequestMapping(value={"/{folderId}/settings"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void setSettings(HttpServletRequest req, @PathVariable String folderId, @RequestBody ProjectFoldersService.ProjectFolderSettings projectFolderSettings) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectFoldersService.saveProjectFolder_Check(authCtx, folderId, projectFolderSettings);
            t.commitV("Updated the settings of folder %s", new Object[]{folderId});
        }
    }

    @AuditedCall(value={"msgType", "project-folders-create"})
    @RequestMapping(value={"/{folderId}/children"}, method={RequestMethod.POST})
    @ResponseBody
    public ProjectFolder create(HttpServletRequest req, @PathVariable String folderId, @RequestParam String name) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            ProjectFolder created = this.projectFoldersService.createFolder_Check(authCtx, folderId, name);
            t.commitV("Create a new project folder %s (%s)", new Object[]{created.name, created.id});
            ProjectFolder projectFolder = created;
            return projectFolder;
        }
    }

    @AuditedCall(value={"msgType", "project-folders-project-move", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{folderId}/projects/{projectKey}/move"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void moveProject(HttpServletRequest req, @PathVariable String folderId, @PathVariable String projectKey, @RequestParam String destination) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectFoldersService.moveProjectsFromFolder_Check(authCtx, folderId, destination, Sets.newHashSet((Object[])new String[]{projectKey}));
            ProjectFolder dest = this.projectFoldersService.getMandatoryUnsafe_Uncheck(destination);
            t.commitV("Moved project %s into %s (%s)", new Object[]{projectKey, dest.name, dest.id});
        }
    }

    @AuditedCall(value={"msgType", "project-folders-move"})
    @RequestMapping(value={"/{folderId}/move"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void move(HttpServletRequest req, @PathVariable String folderId, @RequestParam String destination) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectFoldersService.moveFolder_Check(authCtx, folderId, destination);
            ProjectFolder pf = this.projectFoldersService.getMandatoryUnsafe_Uncheck(folderId);
            ProjectFolder dest = this.projectFoldersService.getMandatoryUnsafe_Uncheck(destination);
            t.commitV("Moved project folder %s (%s) into %s (%s)", new Object[]{pf.name, pf.id, dest.name, dest.id});
        }
    }
}

