/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.admin;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.LLMRateLimitingSettingsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AdminLLMRateLimitingController {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private LLMRateLimitingSettingsService settingsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/admin/llm-rate-limit-defaults"})
    public void getRateLimitingDefaults(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            authCtx = this.authService.getMandatoryUser(req);
        }
        catch (Exception e) {
            DIPInternalControllerBase.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        RateLimitDefaultResponse response = new RateLimitDefaultResponse();
        response.baselineSettings = this.settingsService.getBaselineSettings();
        response.models = this.listModelsByProvider(authCtx);
        DatasetWritingService.writeJSON(resp, response);
    }

    private Map<String, Set<String>> listModelsByProvider(AuthCtx authCtx) throws IOException {
        HashMap<String, Set<String>> modelsByProviderIds = new HashMap<String, Set<String>>();
        for (LLMStructuredRef lLMStructuredRef : this.connectionsService.listAvailableConnectionLLMs(authCtx, null)) {
            String providerId = this.settingsService.getSupportedProviderId(lLMStructuredRef);
            if (providerId == null) continue;
            modelsByProviderIds.putIfAbsent(providerId, new HashSet());
            ((Set)modelsByProviderIds.get(providerId)).add(lLMStructuredRef.getModelNameForAudit());
        }
        return modelsByProviderIds;
    }

    public static class RateLimitDefaultResponse {
        public Map<String, GeneralSettingsDAO.RateLimitingProviderSettings> baselineSettings;
        public Map<String, Set<String>> models;
    }
}

