/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code.sql;

import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.server.datasets.renaming.code.CodeRenamer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SqlCodeRenamer
implements CodeRenamer {
    public static final List<String> RECIPE_TYPES = Arrays.asList(SQLScriptRecipeMeta.META.getType(), SQLQueryRecipeMeta.META.getType(), SparkSQLQueryRecipeMeta.META.getType());
    private final Pattern pattern;
    private final String replacementHeader;
    private final String replacement;

    public SqlCodeRenamer(String datasetName) {
        this(datasetName, datasetName);
    }

    public SqlCodeRenamer(String oldDatasetName, String newDatasetName) {
        this(oldDatasetName, newDatasetName, null, null);
    }

    public SqlCodeRenamer(String oldDatasetName, String newDatasetName, String user, Date date) {
        String regex = String.format("\\$\\{(catalog|schema|tbl):%s\\}", oldDatasetName);
        this.pattern = Pattern.compile(regex);
        this.replacement = String.format("\\${$1:%s}", newDatasetName);
        this.replacementHeader = "-- " + CodeRenamer.getReplacementMessage(oldDatasetName, newDatasetName, user, date);
    }

    @Override
    public List<String> getRecipeTypes() {
        return RECIPE_TYPES;
    }

    @Override
    public boolean requiresRenaming(String payload) {
        return payload != null && !this.shouldSkipRenamingForPayload(payload) && Arrays.stream(payload.split("\n")).anyMatch(line -> this.pattern.matcher((CharSequence)line).find());
    }

    @Override
    public String updatePayload(String payload) {
        if (payload == null) {
            return "";
        }
        if (this.shouldSkipRenamingForPayload(payload)) {
            return payload;
        }
        return Arrays.stream(payload.split("\n")).map(line -> {
            Matcher matcher = this.pattern.matcher((CharSequence)line);
            if (matcher.find()) {
                line = this.replacementHeader + matcher.replaceAll(this.replacement);
            }
            return line;
        }).collect(Collectors.joining("\n"));
    }
}

