/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryTool;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.KnowledgeBankDataService;
import com.dataiku.dip.llm.retrieval.KnowledgeBankManagementService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.filefilter.TrueFileFilter;
import com.dataiku.j2py.annotations.PyModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RetrievableKnowledgeIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private KnowledgeBankManagementService kbMgmtService;
    @Autowired
    private KnowledgeBankDataService kbDataService;
    @Autowired
    private SavedModelsDAO smDao;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.knowledgebank");

    private void CheckTrustedObjectReferencesKb(TrustedObject to, AnyLoc toRef, AnyLoc kbRef) throws IOException {
        if (Objects.requireNonNull(to.type) == ITaggingService.TaggableType.SAVED_MODEL) {
            SavedModel sm = (SavedModel)this.smDao.getMandatory(toRef);
            if (sm.savedModelType != SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM) {
                throw new IllegalArgumentException("The trusted object is not a RAG LLM saved model");
            }
            SavedModel.SavedModelInlineVersion smiv = sm.getActiveSaveModelInlineVersion();
            if (smiv == null) {
                throw new IllegalArgumentException("Saved model has no active version");
            }
            if (smiv.ragllmSettings == null || !AnyLoc.resolveSmart(sm.projectKey, smiv.ragllmSettings.kbRef).equals(kbRef)) {
                throw new IllegalArgumentException("The trusted object does not reference the knowledge bank");
            }
        } else if (Objects.requireNonNull(to.type) == ITaggingService.TaggableType.AGENT_TOOL) {
            AgentTool at = (AgentTool)this.agentToolsDAO.getMandatory(toRef);
            VectorStoreQueryTool.VectorStoreQueryToolParams params = at.getParamsCopyAs(VectorStoreQueryTool.VectorStoreQueryToolParams.class);
            if (params == null || !AnyLoc.resolveSmart(at.projectKey, params.knowledgeBankRef).equals(kbRef)) {
                throw new IllegalArgumentException("The trusted object does not reference the knowledge bank");
            }
        } else {
            throw new IllegalArgumentException("Unsupported trusted object type: " + String.valueOf((Object)to.type));
        }
    }

    private void CheckPermissions(AuthCtx authCtx, AnyLoc kbRef, @Nullable String contextProjectKey, @Nullable TrustedObject to) throws IOException, DKUSecurityException {
        try {
            this.projectsService.checkPerm(authCtx, kbRef.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        catch (DKUSecurityException e) {
            if (contextProjectKey == null) {
                throw new DKUSecurityException("Context project key is required to access shared knowledge bank");
            }
            if (to == null) {
                this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(authCtx, kbRef, contextProjectKey);
            }
            AnyLoc toRef = AnyLoc.resolveSmart(contextProjectKey, to.smartRef);
            this.projectsService.failIfNoTaggableObjectReadUseAccess(authCtx, to.type, toRef, contextProjectKey);
            this.projectsService.failIfLocNotAvailableInProject(ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, kbRef, toRef.getProjectKey());
            this.CheckTrustedObjectReferencesKb(to, toRef, kbRef);
        }
    }

    @AuditedCall(value={"msgType", "knowledge-bank-get", "knowledgeBankFullId", "${knowledgeBankFullId}", "contextProjectKey", "${contextProjectKey}", "trustedObject", "${trustedObject}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/knowledge-bank/get"})
    @ResponseBody
    public RetrievableKnowledge get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String knowledgeBankFullId, @RequestParam @Nullable String contextProjectKey, @RequestParam @Nullable TrustedObject trustedObject) throws Exception {
        AnyLoc loc = AnyLoc.resolveFull(knowledgeBankFullId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.CheckPermissions(authCtx, loc, contextProjectKey, trustedObject);
            RetrievableKnowledge retrievableKnowledge = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
            return retrievableKnowledge;
        }
    }

    @AuditedCall(value={"msgType", "knowledge-bank-get", "knowledgeBankFullId", "${knowledgeBankFullId}", "contextProjectKey", "${contextProjectKey}", "trustedObject", "${trustedObject}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/knowledge-bank/get-current-version"})
    @ResponseBody
    public KnowledgeBankVersion getCurrentVersion(HttpServletRequest req, @RequestParam String knowledgeBankFullId, @RequestParam @Nullable String contextProjectKey, @RequestParam @Nullable TrustedObject trustedObject) throws Exception {
        RetrievableKnowledge rk;
        AnyLoc loc = AnyLoc.resolveFull(knowledgeBankFullId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.CheckPermissions(authCtx, loc, contextProjectKey, trustedObject);
            rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
        }
        KnowledgeBankVersion kbv = new KnowledgeBankVersion();
        kbv.version = this.kbMgmtService.getCurrentlyUsedVersion(rk);
        return kbv;
    }

    @AuditedCall(value={"msgType", "knowledge-bank-set-managed-folder", "knowledgeBankFullId", "${knowledgeBankFullId}", "managedFolderId", "${managedFolderId}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/knowledge-bank/set-managed-folder"})
    public void setManagedFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String knowledgeBankFullId, @RequestParam String managedFolderId) throws Exception {
        AnyLoc kbLoc = AnyLoc.resolveFull(knowledgeBankFullId);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, kbLoc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(kbLoc);
            ManagedFolder managedFolder = this.managedFoldersService.getMandatory(kbLoc.getProjectKey(), AnyLoc.resolveFull(managedFolderId).getId());
            if (!managedFolder.id.equals(rk.managedFolderId)) {
                rk.managedFolderId = managedFolderId;
                this.retrievableKnowledgeDAO.save(rk);
                t.commit("Set managed folder id of " + knowledgeBankFullId + " to " + managedFolder.id);
            }
        }
    }

    @AuditedCall(value={"msgType", "knowledge-bank-set-metadata-columns-schema", "knowledgeBankFullId", "${knowledgeBankFullId}", "metadataColumnsSchema", "${metadataColumnsSchema}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/knowledge-bank/set-metadata-columns-schema"})
    public void setMetadataColumnsSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String knowledgeBankFullId, @RequestParam List<SchemaColumn> metadataColumnsSchema) throws Exception {
        AnyLoc kbLoc = AnyLoc.resolveFull(knowledgeBankFullId);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, kbLoc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(kbLoc);
            rk.metadataColumnsSchema = metadataColumnsSchema;
            this.retrievableKnowledgeDAO.save(rk);
            t.commit("Set metadata columns schema of " + knowledgeBankFullId);
        }
    }

    @AuditedCall(value={"msgType", "knowledge-bank-download", "knowledgeBankFullId", "${knowledgeBankFullId}", "version", "{$version}", "contextProjectKey", "${contextProjectKey}", "trustedObject", "{trustedObject}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/knowledge-bank/download-vectorstore-folder"})
    public void downloadVectorStoreFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String knowledgeBankFullId, @RequestParam String version, @RequestParam @Nullable String contextProjectKey, @RequestParam @Nullable TrustedObject trustedObject) throws DKUSecurityException, IOException {
        RetrievableKnowledge rk;
        AnyLoc loc = AnyLoc.resolveFull(knowledgeBankFullId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.CheckPermissions(authCtx, loc, contextProjectKey, trustedObject);
            rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
        }
        this.kbMgmtService.readKnowledgeBankFolder(rk, version, folder -> {
            if (!folder.exists()) {
                throw new NotFoundException(String.format("Knowledge bank folder does not exist: %s", folder.getAbsolutePath()));
            }
            resp.setStatus(200);
            resp.setContentType("application/x-tar");
            resp.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", folder.getName()));
            logger.info((Object)String.format("Serving knowledge bank folder %s", folder.getAbsolutePath()));
            RemoteRunFileExchangeService.archiveDirectoryToOutputStream(folder, (FilenameFilter)TrueFileFilter.INSTANCE, (OutputStream)resp.getOutputStream());
        });
    }

    @AuditedCall(value={"msgType", "knowledge-bank-create-version", "knowledgeBankFullId", "${knowledgeBankFullId}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/knowledge-bank/create-version"}, method={RequestMethod.POST})
    @ResponseBody
    public KnowledgeBankVersion createVersion(HttpServletRequest req, @RequestParam String knowledgeBankFullId) throws DKUSecurityException, IOException {
        RetrievableKnowledge rk;
        AnyLoc loc = AnyLoc.resolveFull(knowledgeBankFullId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
        }
        String version = this.kbDataService.createNewVersion_NT(rk, (InputStream)req.getInputStream());
        KnowledgeBankVersion ret = new KnowledgeBankVersion();
        ret.version = version;
        return ret;
    }

    @PyModel
    public static class TrustedObject {
        public String smartRef;
        public ITaggingService.TaggableType type;
    }

    public static class KnowledgeBankVersion {
        public String version;
    }

    public static class FullIDTransformer
    implements AuditTransformer {
        public void transform(AuditObj obj) {
            if (obj.has(new String[]{"knowledgeBankFullId"})) {
                AnyLoc loc = AnyLoc.resolveFull(obj.get().get("knowledgeBankFullId").getAsString());
                obj.with("projectKey", loc.getProjectKey());
                obj.with("knowledgeBankId", loc.getId());
            }
        }
    }
}

