/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.KernelStreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusherFactory;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class StreamingEndpointsIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private DatasetWritingService datasetWritingService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private KernelStreamingEndpointService kernelStreamingEndpointService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsfService;
    @Autowired
    private FutureService futureService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming");

    @AuditedCall(value={"msgType", "streaming-endpoint-set-schema", "streamingEndpointFullId", "${streamingEndpointFullId}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/streaming-endpoints/set-schema"})
    public void setSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String streamingEndpointFullId, String schemaData) throws Exception {
        Schema ss = (Schema)JSON.parse((String)schemaData, Schema.class);
        AnyLoc loc = AnyLoc.resolveFull(streamingEndpointFullId);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.projectsfService.checkPerm(t.getUser(), loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (this.datasetWritingService.writeStreamingEndpointSchema(t.getUser(), loc, ss)) {
                t.commit("Updated streaming endpoint \"" + loc.getFullName() + "\" schema");
            }
        }
    }

    @AuditedCall(value={"msgType", "streaming-endpoint-read-meta", "streamingEndpointFullId", "${streamingEndpointFullId}"}, transformer=FullIDTransformer.class)
    @RequestMapping(value={"/api/tintercom/streaming-endpoints/get-schema"})
    public void getSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String streamingEndpointFullId) throws Exception {
        AnyLoc loc = AnyLoc.resolveFull(streamingEndpointFullId);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsfService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            StreamingEndpointsIntercomController.writeJSON((HttpServletResponse)resp, (Object)((StreamingEndpoint)this.streamingEndpointsDAO.getMandatory((AnyLoc)loc)).schema);
        }
    }

    @AuditedCall(value={"msgType", "streaming-endpoint-get-info", "projectKey", "${projectKey}", "folderId", "${lookup}"})
    @RequestMapping(value={"/api/tintercom/streaming-endpoints/get-info"})
    @ResponseBody
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getManagedFolderPath(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id, @RequestParam(required=false) boolean sensitiveInfo) throws Exception {
        StreamingEndpoint se;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, id);
        }
        return new CodeBasedRecipeDatasetInfoHelper().getStreamingEndpointLocationInfo_NT(authCtx, se, sensitiveInfo);
    }

    @AuditedCall(value={"msgType", "streaming-endpoint-get-info", "projectKey", "${projectKey}", "folderId", "${lookup}"})
    @RequestMapping(value={"/api/tintercom/streaming-endpoints/read-config"})
    public void getStreamingEndpointConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsfService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, name);
            StreamingEndpointsIntercomController.writeJSON((HttpServletResponse)resp, (Object)se);
        }
    }

    @AuditedCall(value={"msgType", "streaming-endpoint-read-data", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/streaming-endpoints/read-data"})
    public void streamData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam(value="settings") String settingsStr) throws Exception {
        StreamingEndpointSimplePusher driver;
        StreamingEndpoint se;
        KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings settings = new KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings();
        if (StringUtils.isNotBlank((String)settingsStr)) {
            settings = (KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings)JSON.parse((String)settingsStr, KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings.class);
        }
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsfService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, name);
            driver = new StreamingEndpointSimplePusherFactory().build(authCtx, se, false);
        }
        this.kernelStreamingEndpointService.streamEndpointToHttp(resp, settings, se, driver);
    }

    public static class FullIDTransformer
    implements AuditTransformer {
        public void transform(AuditObj obj) {
            if (obj.has(new String[]{"streamingEndpointFullId"})) {
                AnyLoc loc = AnyLoc.resolveFull(obj.get().get("streamingEndpointFullId").getAsString());
                obj.with("projectKey", loc.getProjectKey());
                obj.with("streamingEndpointId", loc.getId());
            }
        }
    }
}

