/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.google.gson.JsonObject;

public class InterestChangedEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
EnrichmentService.Enrichable,
EventWithHumanReadableString,
TaggableObjectEvent,
WorkspaceEvent {
    public static final String NAME = "interest-added";
    public final String user;
    public final ITaggingService.TaggableType objectType;
    public final String projectKey;
    public final String objectId;
    public final String workspaceKey;
    public final boolean watch;
    public final boolean star;
    public final JsonObject details;

    public InterestChangedEvent(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, boolean watch, boolean star) {
        this.user = user;
        this.objectType = objectType;
        this.projectKey = projectKey;
        this.objectId = objectId;
        this.workspaceKey = workspaceKey;
        this.watch = watch;
        this.star = star;
        this.details = new JsonObject();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return this.objectType;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getWorkspaceKey() {
        return this.workspaceKey;
    }

    @Override
    public JsonObject getDetails() {
        return this.details;
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getTaggableObjectRef() {
        return new TaggableObjectsService.TaggableObjectRef(this.projectKey, this.objectType, this.objectId, this.workspaceKey);
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String action = this.star ? " starred " : " is watching ";
        String userDisplayName = this.details.has("userDisplayName") ? this.details.get("userDisplayName").getAsString() : this.user;
        String objectDisplayName = this.details.has("objectDisplayName") ? this.details.get("objectDisplayName").getAsString() : this.objectId;
        return markup.user(this.user, userDisplayName) + action + markup.dssOrWorkspaceObject(this.objectType, this.projectKey, this.objectId, this.workspaceKey, objectDisplayName);
    }
}

