/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.dataquality.rules.ColumnEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnMeaningValidityRule;
import com.dataiku.dip.dataquality.rules.ColumnNotEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnUniqueValuesRule;
import com.dataiku.dip.dataquality.rules.ValuesInRangeRule;
import com.dataiku.dip.dataquality.rules.ValuesInSetRule;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.server.recipes.ExtractFailedRowsQueryGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtractFailedRowsSchemaGenerator {
    private final Dataset inputDS;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.dataquality");

    public ExtractFailedRowsSchemaGenerator(Dataset inputDS) {
        this.inputDS = inputDS;
    }

    public void checkRuleSelectionValidity(ExtractFailedRowsRecipePayloadParams params, boolean isSql) {
        Set ruleTypesUnsupportedBySelectedEngine;
        List<DataQualityRule> selectedRules = this.getSelectedRules(params);
        RulesValidityDetails rulesValidityDetails = ExtractFailedRowsSchemaGenerator.getRulesValidityDetails(selectedRules, this.inputDS, isSql);
        if (isSql && !(ruleTypesUnsupportedBySelectedEngine = selectedRules.stream().filter(rule -> rulesValidityDetails.getRuleValidityType(rule.getId()) == RuleValidityType.RULE_NOT_SUPPORTED_BY_SELECTED_ENGINE).map(DataQualityRule::getType).collect(Collectors.toSet())).isEmpty()) {
            throw new IllegalStateException("Unsupported rule type(s): " + String.join((CharSequence)", ", ruleTypesUnsupportedBySelectedEngine));
        }
        if (params.explicitColumnSelection) {
            for (DataQualityRule rule2 : selectedRules) {
                switch (rulesValidityDetails.getRuleValidityType(rule2.getId())) {
                    case INVALID_RULE_CONFIG: {
                        RuleValidationError validationError = rulesValidityDetails.getRuleValidationError(rule2.getId());
                        throw new IllegalStateException("Rule '" + rule2.getDisplayName() + "' (" + rule2.getId() + ") is invalid", validationError);
                    }
                    case WHOLE_DATASET_RULE_COMPUTATION_SCOPE: {
                        throw new IllegalStateException("Computation scope of rule '" + rule2.getDisplayName() + "' (" + rule2.getId() + ") is the whole partitioned dataset");
                    }
                    case INCOMPATIBLE_RULE: {
                        throw new IllegalStateException("Type " + rule2.getType() + " of rule '" + rule2.getDisplayName() + "' (" + rule2.getId() + ") is incompatible with row-level extraction");
                    }
                }
            }
        }
    }

    public List<DataQualityRule> getSelectedRules(ExtractFailedRowsRecipePayloadParams params) {
        List<DataQualityRule> rules = this.inputDS.getModel().getDataQualityRuleSet().getRules();
        if (params.explicitColumnSelection) {
            Set selectedRuleIds = params.columnRules.stream().filter(desc -> desc.isSelected).map(desc -> desc.ruleId).collect(Collectors.toSet());
            return rules.stream().filter(rule -> selectedRuleIds.contains(rule.getId())).toList();
        }
        RulesValidityDetails rulesValidityDetails = ExtractFailedRowsSchemaGenerator.getRulesValidityDetails(rules, this.inputDS, false);
        return rules.stream().filter(rule -> rulesValidityDetails.getRuleValidityType((String)rule.getId()).isSupported).toList();
    }

    public FailedRowsSchemaDetails generate(ExtractFailedRowsRecipePayloadParams params, Integer identifierMaxLength) {
        Predicate<OutcomeColumnKey> outputColumnKeyPredicate;
        List<DataQualityRule> selectedRules = this.getSelectedRules(params);
        if (params.explicitColumnSelection) {
            Map<OutcomeColumnKey, Boolean> isSelectedByOutcomeColumnKey = params.columnRules.stream().collect(Collectors.toMap(desc -> new OutcomeColumnKey(desc.ruleId, desc.ruleColumn), desc -> desc.isSelected));
            outputColumnKeyPredicate = key -> isSelectedByOutcomeColumnKey.getOrDefault(key, false);
        } else {
            outputColumnKeyPredicate = key -> true;
        }
        Schema outputSchema = new Schema(this.inputDS.getSchema());
        OutcomeColumnsDetails outcomeColumnsDetails = ExtractFailedRowsSchemaGenerator.generateOutcomeColumnDetails(identifierMaxLength, outputSchema, selectedRules, outputColumnKeyPredicate);
        return new FailedRowsSchemaDetails(outputSchema, outcomeColumnsDetails, selectedRules);
    }

    public static OutcomeColumnsDetails generateOutcomeColumnDetails(Integer identifierMaxLength, Schema outputSchema, List<DataQualityRule> rules, Predicate<OutcomeColumnKey> outputColumnKeyPredicate) {
        SchemaUtils.SafeColumnIdentifierSuffixer suffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(identifierMaxLength, outputSchema);
        OutcomeColumnsDetails outcomeColumnsDetails = new OutcomeColumnsDetails();
        for (DataQualityRule rule : rules) {
            String shortRuleType = ExtractFailedRowsSchemaGenerator.getShortRuleType(rule);
            String columnNameSuffix = "_" + rule.getId();
            ArrayList<Pair> outcomeColumns = new ArrayList<Pair>();
            if (rule instanceof AbstractMultiColumnRule) {
                AbstractMultiColumnRule multiColumnRule = (AbstractMultiColumnRule)rule;
                for (String ruleColumn : multiColumnRule.getColumns()) {
                    OutcomeColumnKey outcomeColumnKey = new OutcomeColumnKey(rule.getId(), ruleColumn);
                    if (!outputColumnKeyPredicate.test(outcomeColumnKey)) continue;
                    outcomeColumns.add(new Pair((Object)outcomeColumnKey, (Object)(ruleColumn + "_" + shortRuleType)));
                }
            }
            outcomeColumns.forEach(pair -> {
                OutcomeColumnKey outcomeColumnKey = (OutcomeColumnKey)pair.first;
                String outcomeColumnName = (String)pair.second;
                String outcomeColumnNameWithSuffix = suffixer.addSuffix(outcomeColumnName, columnNameSuffix);
                SchemaColumn outcomeSchemaColumn = new SchemaColumn(outcomeColumnNameWithSuffix, Type.STRING, 32).withComment(rule.getDisplayName());
                outputSchema.addColumn(outcomeSchemaColumn);
                outcomeColumnsDetails.addOutcomeColumn(outcomeColumnKey, outcomeColumnNameWithSuffix);
            });
        }
        return outcomeColumnsDetails;
    }

    public static List<DataQualityRule> getSupportedRules(List<DataQualityRule> inputRules) {
        final ArrayList<DataQualityRule> supportedRules = new ArrayList<DataQualityRule>();
        FailedRowsExtractRuleVisitor visitor = new FailedRowsExtractRuleVisitor(){

            @Override
            public void visit(ValuesInSetRule rule) {
                supportedRules.add(rule);
            }

            @Override
            public void visit(ValuesInRangeRule rule) {
                supportedRules.add(rule);
            }

            @Override
            public void visit(ColumnNotEmptyRule rule) {
                supportedRules.add(rule);
            }

            @Override
            public void visit(ColumnEmptyRule rule) {
                supportedRules.add(rule);
            }

            @Override
            public void visit(ColumnUniqueValuesRule rule) {
                supportedRules.add(rule);
            }

            @Override
            public void visit(ColumnMeaningValidityRule rule) {
                supportedRules.add(rule);
            }
        };
        for (DataQualityRule rule : inputRules) {
            try {
                rule.accept(visitor);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return supportedRules;
    }

    public static RulesValidityDetails getRulesValidityDetails(List<DataQualityRule> rules, Dataset inputDS, boolean isSql) {
        RulesValidityDetails rulesValidityDetails = new RulesValidityDetails();
        List<DataQualityRule> supportedRules = ExtractFailedRowsSchemaGenerator.getSupportedRules(rules);
        Set supportedRuleIds = supportedRules.stream().map(DataQualityRule::getId).collect(Collectors.toSet());
        List<DataQualityRule> rulesUnsupportedBySqlEngine = ExtractFailedRowsQueryGenerator.getUnsupportedRules(supportedRules);
        Set ruleIdsUnsupportedBySqlEngine = rulesUnsupportedBySqlEngine.stream().map(DataQualityRule::getId).collect(Collectors.toSet());
        boolean isInputPartitioned = inputDS.getPartitioningSchema().isPartitioned();
        rules.forEach(rule -> {
            if (!supportedRuleIds.contains(rule.getId())) {
                rulesValidityDetails.addRule(rule.getId(), RuleValidityType.INCOMPATIBLE_RULE);
                return;
            }
            if (isInputPartitioned && rule.computeOnBuildMode == Probe.ComputeMode.WHOLE_DATASET) {
                rulesValidityDetails.addRule(rule.getId(), RuleValidityType.WHOLE_DATASET_RULE_COMPUTATION_SCOPE);
                return;
            }
            if (rule.enabled) {
                RuleValidationError validationError = rule.verifyConfig(inputDS);
                if (validationError != null) {
                    rulesValidityDetails.addRule(rule.getId(), RuleValidityType.INVALID_RULE_CONFIG, validationError);
                    return;
                }
                if (isSql && ruleIdsUnsupportedBySqlEngine.contains(rule.getId())) {
                    rulesValidityDetails.addRule(rule.getId(), RuleValidityType.RULE_NOT_SUPPORTED_BY_SELECTED_ENGINE);
                    return;
                }
            }
        });
        return rulesValidityDetails;
    }

    private static String getShortRuleType(DataQualityRule rule) {
        final String[] res = new String[1];
        FailedRowsExtractRuleVisitor visitor = new FailedRowsExtractRuleVisitor(){

            @Override
            public void visit(ValuesInSetRule rule) {
                res[0] = "ValuesInSet";
            }

            @Override
            public void visit(ValuesInRangeRule rule) {
                res[0] = "ValuesInRange";
            }

            @Override
            public void visit(ColumnNotEmptyRule rule) {
                res[0] = "NotEmpty";
            }

            @Override
            public void visit(ColumnEmptyRule rule) {
                res[0] = "Empty";
            }

            @Override
            public void visit(ColumnUniqueValuesRule rule) {
                res[0] = "Unique";
            }

            @Override
            public void visit(ColumnMeaningValidityRule rule) {
                res[0] = "MeaningValidity";
            }
        };
        rule.accept(visitor);
        return res[0];
    }

    public static class RulesValidityDetails {
        private final Map<String, RuleValidityType> validityTypesByRuleId = new HashMap<String, RuleValidityType>();
        private final Map<String, RuleValidationError> validationErrorsByRuleId = new HashMap<String, RuleValidationError>();

        public void addRule(String ruleId, RuleValidityType ruleValidityType) {
            this.validityTypesByRuleId.put(ruleId, ruleValidityType);
        }

        public void addRule(String ruleId, RuleValidityType ruleValidityType, RuleValidationError ruleValidationError) {
            this.validityTypesByRuleId.put(ruleId, ruleValidityType);
            this.validationErrorsByRuleId.put(ruleId, ruleValidationError);
        }

        public RuleValidityType getRuleValidityType(String ruleId) {
            return this.validityTypesByRuleId.getOrDefault(ruleId, RuleValidityType.VALID);
        }

        public RuleValidationError getRuleValidationError(String ruleId) {
            return this.validationErrorsByRuleId.get(ruleId);
        }
    }

    public static enum RuleValidityType {
        VALID(true),
        WHOLE_DATASET_RULE_COMPUTATION_SCOPE(false),
        RULE_NOT_SUPPORTED_BY_SELECTED_ENGINE(true),
        INVALID_RULE_CONFIG(false),
        INCOMPATIBLE_RULE(false);

        public final boolean isSupported;

        private RuleValidityType(boolean isSupported) {
            this.isSupported = isSupported;
        }
    }

    public static class OutcomeColumnsDetails {
        public final LinkedHashMap<OutcomeColumnKey, String> outcomeColumns;

        public OutcomeColumnsDetails() {
            this.outcomeColumns = new LinkedHashMap();
        }

        public OutcomeColumnsDetails(OutcomeColumnsDetails other) {
            this.outcomeColumns = new LinkedHashMap<OutcomeColumnKey, String>(other.outcomeColumns);
        }

        public void addOutcomeColumn(OutcomeColumnKey key, String outcomeColumn) {
            this.outcomeColumns.put(key, outcomeColumn);
        }

        public String getOutcomeColumn(String ruleId, String ruleColumn) {
            return this.getOutcomeColumn(new OutcomeColumnKey(ruleId, ruleColumn));
        }

        public String getOutcomeColumn(OutcomeColumnKey key) {
            return this.outcomeColumns.get(key);
        }

        public List<String> getSelectedColumnsForRule(AbstractMultiColumnRule rule) {
            return rule.getColumns().stream().filter(column -> this.outcomeColumns.containsKey(new OutcomeColumnKey(rule.getId(), (String)column))).toList();
        }
    }

    public static class FailedRowsSchemaDetails {
        public final Schema outputSchema;
        public final OutcomeColumnsDetails outcomeColumnsDetails;
        public final List<DataQualityRule> rules;

        public FailedRowsSchemaDetails(Schema outputSchema, OutcomeColumnsDetails outcomeColumnsDetails, List<DataQualityRule> rules) {
            this.outputSchema = outputSchema;
            this.outcomeColumnsDetails = outcomeColumnsDetails;
            this.rules = rules;
        }
    }

    public static class OutcomeColumnKey {
        @Nonnull
        public final String ruleId;
        @Nullable
        public final String ruleColumn;

        public OutcomeColumnKey(@Nonnull String ruleId, @Nullable String ruleColumn) {
            this.ruleId = ruleId;
            this.ruleColumn = ruleColumn;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutcomeColumnKey that = (OutcomeColumnKey)o;
            return Objects.equals(this.ruleId, that.ruleId) && Objects.equals(this.ruleColumn, that.ruleColumn);
        }

        public int hashCode() {
            return Objects.hash(this.ruleId, this.ruleColumn);
        }
    }
}

