/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSProviderConnectionFactory;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.DirectoryAware;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRule;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.fs.Globbing;
import com.dataiku.dip.input.remote.RemoteFileUtils;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.recipes.download.DownloadRecipeParams;
import com.dataiku.dip.recipes.download.DownloadRecipeSource;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KernelsDownloadRecipeService {
    private final String lastModifiedProbingPath = ".dku_download_test_set_modification_time";
    private final String lastModifiedStore = ".dku_download_modification_times";
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private VariablesService variablesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.download.service");

    private AbstractFSDatasetHandler.AbstractFSConfig getResolvedParams(String projectKey, AuthCtx authCtx, DownloadRecipeSource sourceDef, Map<String, String> flowVariables) throws IOException, DKUSecurityException {
        AbstractFSDatasetHandler.AbstractFSConfig sourceDefParams = sourceDef.getParams(authCtx, this.connectionsDAO);
        if (sourceDefParams.path != null) {
            logger.info((Object)("Substitute variables in path " + sourceDefParams.path));
            VariablesContext vc = this.variablesService.getForProjectAndUser(authCtx, projectKey);
            sourceDefParams.path = vc.expandAllowUnresolved(sourceDefParams.path);
            sourceDefParams.path = FlowVariables.substitute(flowVariables, sourceDefParams.path);
        }
        return sourceDefParams;
    }

    public AutoCloseableFSProviderAndPath getFSProviderForSource(String projectKey, AuthCtx authCtx, DownloadRecipeSource sourceDef, Map<String, String> flowVariables) throws IOException, DKUSecurityException, CodedException, URISyntaxException {
        if (StringUtils.isBlank((String)sourceDef.providerType)) {
            throw new IllegalArgumentException("No provider type defined for source");
        }
        if (sourceDef.params == null) {
            throw new IllegalArgumentException("No parameters defined for the source");
        }
        if (sourceDef.params.get("path").isJsonNull()) {
            throw new IllegalArgumentException("No path defined for the source");
        }
        AbstractFSDatasetHandler.AbstractFSConfig sourceDefParams = this.getResolvedParams(projectKey, authCtx, sourceDef, flowVariables);
        if (sourceDefParams instanceof DownloadRecipeSource.URLConfig) {
            logger.info((Object)"Check URL source");
            String url = sourceDefParams.path;
            if (StringUtils.isBlank((String)url)) {
                throw new IllegalArgumentException("No url defined");
            }
            if (url.toLowerCase().startsWith("ftp://")) {
                FTPConnection ftpConnection = RemoteFileUtils.ParseFtpConnection(url, sourceDef.useGlobalProxy);
                Pair pathAndFile = PathUtils.splitBasename((String)ftpConnection.params.file);
                BuiltinFSDatasets.FTPDatasetConfig config = new BuiltinFSDatasets.FTPDatasetConfig();
                config.connection = ftpConnection.name;
                config.path = (String)pathAndFile.first;
                FSProvider fsProvider = FSProviderFactory.getProvider("FTP", authCtx, projectKey, config, config.path, ftpConnection);
                return new AutoCloseableFSProviderAndPath(fsProvider, (String)pathAndFile.second, (String)pathAndFile.second, false);
            }
            if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
                URI uri = new URI(url);
                Pair<String, String> splitUrl = KernelsDownloadRecipeService.splitHttpUrl(uri);
                String urlStart = (String)splitUrl.first;
                String urlEnd = (String)splitUrl.second;
                DownloadRecipeSource.URLConfig urlConfig = (DownloadRecipeSource.URLConfig)sourceDefParams;
                FSProvider fsProvider = FSProviderFactory.getProvider("HTTP", authCtx, projectKey, urlConfig, urlStart, null);
                String[] pathElements = StringUtils.defaultIfBlank((String)uri.getPath(), (String)"").split("/");
                String candidateName = pathElements.length > 0 ? pathElements[pathElements.length - 1] : uri.getHost();
                return new AutoCloseableFSProviderAndPath(fsProvider, urlEnd, "/" + candidateName, false);
            }
            throw new CodedException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_HTTP_INVALID_URI, "Only http://, https:// and ftp:// URLs are supported");
        }
        logger.info((Object)"Check source backed by connection");
        FSProviderConnectionFactory connectionFactory = new FSProviderConnectionFactory();
        DSSConnection connection = connectionFactory.getConnectionForProvider(sourceDef.providerType, authCtx, sourceDefParams, "provider of type " + sourceDef.providerType);
        FSProvider fsProvider = FSProviderFactory.getProvider(sourceDef.providerType, authCtx, projectKey, sourceDefParams, "", connection);
        return new AutoCloseableFSProviderAndPath(fsProvider, sourceDefParams.path, sourceDefParams.path, true);
    }

    @VisibleForTesting
    static Pair<String, String> splitHttpUrl(URI uri) throws URISyntaxException {
        int lastSlashIndex;
        boolean needSlash;
        String path = StringUtils.defaultIfBlank((String)uri.getRawPath(), (String)"");
        boolean bl = needSlash = path.endsWith("/") && path.length() > 1;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String startPath = (lastSlashIndex = path.lastIndexOf(47)) < 0 ? path : path.substring(0, lastSlashIndex);
        String endPath = lastSlashIndex < 0 ? "" : path.substring(lastSlashIndex);
        URI startPart = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), startPath, null, null);
        StringBuilder endPart = new StringBuilder();
        endPart.append(endPath);
        if (needSlash) {
            endPart.append("/");
        }
        if (uri.getQuery() != null) {
            endPart.append("?");
            endPart.append(uri.getQuery());
        }
        if (uri.getFragment() != null) {
            endPart.append("#");
            endPart.append(uri.getFragment());
        }
        return new Pair((Object)startPart.toString(), (Object)endPart.toString());
    }

    public FSEnumerationResultAndPrefix enumerateSource(FSProvider provider, String path, String identifyingPath, boolean canGlob) throws IOException, CodedException, DKUSecurityException {
        String identifyingPrefix;
        String prefix;
        FSEnumerationSettings enumerationSettings = new FSEnumerationSettings();
        if (canGlob && Globbing.hasGlobbing((String)path)) {
            Pair split = PathUtils.splitGlobbing((String)path);
            enumerationSettings.selectionRules.mode = FilesSelectionRules.Mode.RULES_INCLUDED_ONLY;
            FilesSelectionRule rule = new FilesSelectionRule();
            rule.expr = path.startsWith("/") ? path.substring(1) : path;
            rule.matchingMode = FilesSelectionRule.MatchingMode.FULL_PATH;
            rule.mode = FilesSelectionRule.Mode.GLOB;
            enumerationSettings.selectionRules.includeRules.add(rule);
            logger.info((Object)("Enumerate '" + identifyingPath + "' : '" + path + "' from '" + (String)split.first + "'"));
            prefix = (String)split.first;
            identifyingPrefix = (String)split.first;
        } else {
            logger.info((Object)("Enumerate '" + identifyingPath + "' : '" + path + "'"));
            prefix = path;
            identifyingPrefix = identifyingPath;
        }
        String prefixLNT = PathUtils.makeLeadingNoTrailing((String)prefix);
        String identifyingPrefixLNT = PathUtils.makeLeadingNoTrailing((String)identifyingPrefix);
        FSEnumerationResult enumerationResult = provider.enumerateRecursive(prefixLNT, enumerationSettings);
        return new FSEnumerationResultAndPrefix(enumerationResult, prefixLNT, identifyingPrefixLNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public List<FSPath> copyFromSourcesToFolder(ManagedFolder managedFolder, String partitionPrefix, String contextProjectKey, AuthCtx authCtx, DownloadRecipeParams recipeParams, boolean simulate, Map<String, String> flowVariables) throws Exception {
        ArrayList copied;
        block61: {
            copied = Lists.newArrayList();
            try (ManagedFolderHandler handler = (ManagedFolderHandler)managedFolder.buildHandler(authCtx);){
                FSProvider targetProvider = handler.getProvider();
                FSEnumerationResult current = targetProvider.enumerateRecursive(partitionPrefix, new FSEnumerationSettings());
                if (!current.isSuccessful()) {
                    if (current.getError() != null) {
                        throw new Exception("Cannot list current state of target folder", current.getError());
                    }
                    if (!current.enumerationPrefixExists()) {
                        logger.info((Object)("Target partition path doesn't exist yet : " + partitionPrefix));
                        if (!simulate && targetProvider instanceof DirectoryAware) {
                            logger.info((Object)"Creating partition path");
                            ((DirectoryAware)targetProvider).ensureDirectory(partitionPrefix);
                        }
                    } else {
                        throw new Exception("Cannot list current state of target folder (no error)");
                    }
                }
                logger.info((Object)"Probe ability to set modificationtime on output");
                boolean targetCanSetLastModified = true;
                long probingTime = System.currentTimeMillis();
                try {
                    OutputStream os = targetProvider.write(".dku_download_test_set_modification_time");
                    if (os != null) {
                        os.close();
                    }
                    targetProvider.setLastModified(".dku_download_test_set_modification_time", probingTime);
                }
                catch (UnsupportedOperationException e) {
                    logger.info((Object)"Target FsProvider doesn't support setting the modification time, ignoring it for comparison purposes");
                    targetCanSetLastModified = false;
                }
                catch (Exception e) {
                    logger.info((Object)"Target FsProvider doesn't seem to support setting the modification time, ignoring it for comparison purposes", (Throwable)e);
                    targetCanSetLastModified = false;
                }
                finally {
                    try {
                        targetProvider.deleteRecursive(".dku_download_test_set_modification_time");
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to cleanup probing path for testing ability to set last modified", (Throwable)e);
                    }
                }
                HashMap currentPaths = Maps.newHashMap();
                if (current.getPaths() != null) {
                    for (FSPath path : current.getPaths()) {
                        if ("/.dku_download_test_set_modification_time".equals(path.path())) {
                            logger.warn((Object)"File for probing ability to set modification time survived a previous execution");
                            continue;
                        }
                        currentPaths.put(path.path(), path);
                    }
                }
                boolean checkLastModified = targetCanSetLastModified;
                if (!targetCanSetLastModified) {
                    logger.info((Object)"Read back modification times if previously stored by download recipe run");
                    if (targetProvider.stat(".dku_download_modification_times") != null) {
                        try {
                            EnrichedInputStream eis = targetProvider.read(".dku_download_modification_times");
                            HashMap previousRun = Maps.newHashMap();
                            try (Iterator is = eis.rawStream();){
                                List previousRunPaths = (List)JSON.parse((InputStream)((Object)is), (TypeToken)new TypeToken<List<FSPath>>(){});
                                for (FSPath path : previousRunPaths) {
                                    previousRun.put(path.path(), path);
                                }
                            }
                            logger.info((Object)"Putting back the real modification times");
                            for (Map.Entry path : currentPaths.entrySet()) {
                                if (!previousRun.containsKey(path.getKey())) continue;
                                FSPath fSPath = (FSPath)previousRun.get(path.getKey());
                                if (fSPath.getSize() != ((FSPath)path.getValue()).getSize()) {
                                    logger.info((Object)("Path '" + (String)path.getKey() + "' has different size from last recipe execution, not reusing modification time"));
                                    continue;
                                }
                                currentPaths.put((String)path.getKey(), new FSPath((String)path.getKey(), ((FSPath)path.getValue()).getSize(), fSPath.getLastModified()));
                            }
                            checkLastModified = true;
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Failed to read modification times from previous run", (Throwable)e);
                        }
                    } else {
                        logger.info((Object)"Modification times store doesn't exist (yet)");
                    }
                }
                SourceCopyContext copyContext = new SourceCopyContext(contextProjectKey, authCtx, currentPaths, recipeParams, partitionPrefix, copied);
                HashSet downloaded = Sets.newHashSet();
                for (Object jo : new VariablesExpansionLoopItemsIterable(authCtx, contextProjectKey, recipeParams.variablesExpansionLoopConfig)) {
                    try {
                        void var21_37;
                        logger.info((Object)("Loop on " + JSON.json((Object)jo)));
                        DynamicLevelsStack.pushLevel((JsonObject)jo);
                        boolean bl = false;
                        while (var21_37 < recipeParams.sources.size()) {
                            DownloadRecipeSource source = recipeParams.sources.get((int)var21_37);
                            String filePrefix = recipeParams.sources.size() > 1 ? Integer.toString((int)(var21_37 + true)) + "_" : "";
                            CopyAction copyAction = this.getCopyAction(targetProvider, targetCanSetLastModified, copyContext, simulate);
                            downloaded.addAll(this.copyFromSourceToFolder(targetProvider, checkLastModified, source, filePrefix, copyContext, copyAction, flowVariables));
                            ++var21_37;
                        }
                    }
                    finally {
                        DynamicLevelsStack.popLevel();
                    }
                }
                if (simulate) break block61;
                HashMap synced = Maps.newHashMap();
                for (FSPath fSPath : downloaded) {
                    synced.put(fSPath.path(), fSPath);
                }
                if (recipeParams.deleteExtraFiles) {
                    this.deleteExtraFiles(targetProvider, currentPaths, downloaded);
                } else {
                    for (Map.Entry entry : currentPaths.entrySet()) {
                        if (synced.containsKey(entry.getKey())) continue;
                        synced.put((String)entry.getKey(), (FSPath)entry.getValue());
                    }
                }
                if (targetCanSetLastModified) break block61;
                logger.info((Object)"Write out modification times");
                try (OutputStream os = targetProvider.write(".dku_download_modification_times");){
                    IOUtils.write((String)JSON.pretty((Object)Lists.newArrayList(synced.values())), (OutputStream)os);
                }
            }
        }
        return copied;
    }

    private void deleteExtraFiles(FSProvider targetProvider, Map<String, FSPath> currentPaths, Set<FSPath> downloaded) throws IOException, CodedException, DKUSecurityException {
        HashMap previousByFolderPaths = Maps.newHashMap();
        HashMap deletedByFolderPaths = Maps.newHashMap();
        HashMap downloadedByFolderPaths = Maps.newHashMap();
        HashMap downloadedByPath = Maps.newHashMap();
        for (FSPath fSPath : downloaded) {
            downloadedByPath.put(fSPath.path(), fSPath);
            String[] stringArray = fSPath.path().split("/+");
            KernelsDownloadRecipeService.putPathInFolders(downloadedByFolderPaths, fSPath.path(), stringArray);
        }
        for (String string : currentPaths.keySet()) {
            String[] stringArray = string.split("/+");
            KernelsDownloadRecipeService.putPathInFolders(previousByFolderPaths, string, stringArray);
            if (downloadedByPath.containsKey(string)) continue;
            targetProvider.deleteRecursive(string);
            KernelsDownloadRecipeService.putPathInFolders(deletedByFolderPaths, string, stringArray);
        }
        ArrayList foldersToDelete = Lists.newArrayList();
        for (Map.Entry entry : previousByFolderPaths.entrySet()) {
            String subPath = (String)entry.getKey();
            if (downloadedByFolderPaths.containsKey(subPath)) continue;
            logger.info((Object)("Check path with no file downloaded : " + subPath));
            if (!deletedByFolderPaths.containsKey(subPath) || ((Set)deletedByFolderPaths.get(subPath)).size() != ((Set)entry.getValue()).size()) continue;
            foldersToDelete.add(subPath);
        }
        Collections.sort(foldersToDelete);
        HashSet hashSet = Sets.newHashSet();
        for (String folder : foldersToDelete) {
            boolean alreadyDeleted = false;
            for (String folderDeleted : hashSet) {
                if (!folder.startsWith(folderDeleted)) continue;
                alreadyDeleted = true;
            }
            if (alreadyDeleted) continue;
            logger.info((Object)("Delete folder at path : " + folder));
            targetProvider.deleteRecursive(folder);
            hashSet.add(folder);
        }
    }

    private static void putPathInFolders(Map<String, Set<String>> deletedByFolderPaths, String path, String[] chunks) {
        StringBuilder subPath = new StringBuilder();
        for (int i = 0; i < chunks.length - 1; ++i) {
            if (chunks[i].length() == 0) continue;
            subPath.append("/");
            subPath.append(chunks[i]);
            String subPathStr = subPath.toString();
            if (!deletedByFolderPaths.containsKey(subPathStr)) {
                deletedByFolderPaths.put(subPathStr, new HashSet());
            }
            deletedByFolderPaths.get(subPathStr).add(path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<FSPath> copyFromSourceToFolder(FSProvider targetProvider, boolean checkLastModified, DownloadRecipeSource source, String filePrefix, SourceCopyContext copyContext, CopyAction copyAction, Map<String, String> flowVariables) throws Exception {
        HashSet downloaded = Sets.newHashSet();
        logger.info((Object)("Handle source on " + source.providerType));
        try (AutoCloseableFSProviderAndPath sourceProviderAndPath = this.getFSProviderForSource(copyContext.projectKey, copyContext.authCtx, source, flowVariables);){
            FSProvider sourceProvider = sourceProviderAndPath.provider;
            FSEnumerationResultAndPrefix enumerationResultAndPrefix = this.enumerateSource(sourceProvider, sourceProviderAndPath.path, sourceProviderAndPath.identifyingPath, sourceProviderAndPath.canGlob);
            FSEnumerationResult enumerationResult = enumerationResultAndPrefix.enumerationResult;
            if (enumerationResult.isSuccessful() && enumerationResult.getPaths() != null) {
                for (FSPath path : enumerationResult.getPaths()) {
                    String sourcePath = path.path();
                    String cleanPrefix = PathUtils.makeLeadingNoTrailing((String)enumerationResultAndPrefix.prefix);
                    int cleanPrefixLength = "/".equals(cleanPrefix) ? 0 : cleanPrefix.length();
                    String sourcePathWithoutPrefix = sourcePath.substring(cleanPrefixLength);
                    String sourcePathForCopy = this.computeSourcePathForCopy(sourcePathWithoutPrefix, enumerationResultAndPrefix.identifyingPrefix);
                    String targetPath = this.computeTargetPath(filePrefix, copyContext, sourcePathForCopy, enumerationResultAndPrefix.identifyingPrefix);
                    downloaded.add(new FSPath(targetPath, path.getSize(), path.getLastModified()));
                    boolean changed = false;
                    boolean exists = copyContext.currentPaths.containsKey(targetPath);
                    if (exists) {
                        FSPath currentPath = copyContext.currentPaths.get(targetPath);
                        boolean bl = changed = currentPath.getSize() != path.getSize();
                        if (checkLastModified && path.getLastModified() > 0L) {
                            changed |= path.getLastModified() >= currentPath.getLastModified() + 2000L;
                        }
                    }
                    logger.info((Object)("Handle '" + sourcePath + "' ('" + sourcePathWithoutPrefix + "' -> '" + sourcePathForCopy + "'): exists=" + exists + " changed=" + changed + " identifying=" + enumerationResultAndPrefix.identifyingPrefix));
                    if (exists && !changed && !copyContext.copyEvenUpToDateFiles) continue;
                    copyAction.copyPathFromSourceToFolder(sourceProvider, path, sourcePath, sourcePathForCopy, targetPath);
                }
                return downloaded;
            } else if (!enumerationResult.isSuccessful()) {
                if (enumerationResult.getError() != null) {
                    throw new Exception("Failed to enumerate source " + JSON.pretty((Object)source), enumerationResult.getError());
                }
                if (enumerationResult.enumerationPrefixExists()) throw new Exception("Could not enumerate source " + JSON.pretty((Object)source));
                logger.warn((Object)("Nothing to download for source " + JSON.pretty((Object)source)));
                return downloaded;
            } else {
                logger.warn((Object)("Nothing found in source " + JSON.pretty((Object)source)));
            }
            return downloaded;
        }
    }

    private String computeSourcePathForCopy(String sourcePathWithoutPrefix, String identifyingPrefix) {
        Object sourcePathForCopy = StringUtils.isBlank((String)sourcePathWithoutPrefix) ? "/" + (String)PathUtils.splitBasename((String)identifyingPrefix).second : sourcePathWithoutPrefix;
        return sourcePathForCopy;
    }

    private String computeTargetPath(String filePrefix, SourceCopyContext copyContext, String sourcePathForCopy, String identifyingPrefix) {
        if (sourcePathForCopy.length() == 0 || "/".equals(sourcePathForCopy)) {
            sourcePathForCopy = identifyingPrefix;
        }
        Object targetPath = StringUtils.isNotBlank((String)copyContext.partitionPrefix) && !"/".equals(copyContext.partitionPrefix) ? PathUtils.concatLNT((String[])new String[]{copyContext.partitionPrefix, sourcePathForCopy}) : sourcePathForCopy;
        if (StringUtils.isNotBlank((String)filePrefix)) {
            Pair fileAndParent = PathUtils.splitBasename((String)targetPath);
            targetPath = (String)fileAndParent.first + "/" + filePrefix + (String)fileAndParent.second;
        }
        return PathUtils.slashes((String)targetPath, null, null, (boolean)true, (String)targetPath);
    }

    private CopyAction getCopyAction(FSProvider targetProvider, boolean targetCanSetLastModified, SourceCopyContext copyContext, boolean simulate) {
        if (simulate) {
            return new TestCopyAction(copyContext);
        }
        return new RealCopyAction(targetProvider, copyContext, targetCanSetLastModified);
    }

    public static class AutoCloseableFSProviderAndPath
    implements AutoCloseable {
        public final FSProvider provider;
        public final String path;
        public final String identifyingPath;
        public final boolean canGlob;

        public AutoCloseableFSProviderAndPath(FSProvider provider, String path, String identifyingPath, boolean canGlob) {
            this.path = path;
            this.provider = provider;
            this.identifyingPath = identifyingPath;
            this.canGlob = canGlob;
        }

        @Override
        public void close() throws Exception {
            this.provider.close();
        }
    }

    public static class FSEnumerationResultAndPrefix {
        public final FSEnumerationResult enumerationResult;
        public final String prefix;
        public final String identifyingPrefix;

        public FSEnumerationResultAndPrefix(FSEnumerationResult enumerationResult, String prefix, String identifyingPrefix) {
            this.enumerationResult = enumerationResult;
            this.prefix = prefix;
            this.identifyingPrefix = identifyingPrefix;
        }
    }

    private static class SourceCopyContext {
        String projectKey;
        AuthCtx authCtx;
        Map<String, FSPath> currentPaths;
        boolean copyEvenUpToDateFiles;
        List<FSPath> copied;
        String partitionPrefix;

        SourceCopyContext(String projectKey, AuthCtx authCtx, Map<String, FSPath> currentPaths, DownloadRecipeParams recipeParams, String partitionPrefix, List<FSPath> copied) {
            this.projectKey = projectKey;
            this.authCtx = authCtx;
            this.currentPaths = currentPaths;
            this.partitionPrefix = partitionPrefix;
            this.copied = copied;
            this.copyEvenUpToDateFiles = recipeParams.copyEvenUpToDateFiles;
        }
    }

    private static interface CopyAction {
        public void copyPathFromSourceToFolder(FSProvider var1, FSPath var2, String var3, String var4, String var5) throws IOException, InterruptedException, DKUSecurityException, CodedException;
    }

    private static class TestCopyAction
    implements CopyAction {
        private final SourceCopyContext copyContext;

        TestCopyAction(SourceCopyContext copyContext) {
            this.copyContext = copyContext;
        }

        @Override
        public void copyPathFromSourceToFolder(FSProvider sourceProvider, FSPath path, String sourcePath, String sourcePathForCopy, String targetPath) throws IOException, InterruptedException, DKUSecurityException {
            logger.info((Object)("Need to copy " + sourcePath + " to " + targetPath));
            this.copyContext.copied.add(new FSPath(sourcePathForCopy, path.getSize(), path.getLastModified()));
        }
    }

    private static class RealCopyAction
    implements CopyAction {
        private final FSProvider targetProvider;
        private final SourceCopyContext copyContext;
        private final boolean targetCanSetLastModified;

        RealCopyAction(FSProvider targetProvider, SourceCopyContext copyContext, boolean targetCanSetLastModified) {
            this.targetProvider = targetProvider;
            this.copyContext = copyContext;
            this.targetCanSetLastModified = targetCanSetLastModified;
        }

        @Override
        public void copyPathFromSourceToFolder(FSProvider sourceProvider, FSPath path, String sourcePath, String sourcePathForCopy, String targetPath) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            logger.info((Object)("Copy " + sourcePath + " to " + targetPath));
            this.copyContext.copied.add(new FSPath(sourcePathForCopy, path.getSize(), path.getLastModified()));
            try (InputStream is = sourceProvider.read(sourcePath).rawStream();
                 OutputStream os = this.targetProvider.write(targetPath);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            if (this.targetCanSetLastModified && path.getLastModified() > 0L) {
                this.targetProvider.setLastModified(targetPath, path.getLastModified());
            }
        }
    }
}

