/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.output.JSONObjectOutputFormatter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.output.StreamOutputWriter;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.DatasetExploreSettingsDAO;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.ShakerStreamService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetStreamService {
    private Cache<String, Exception> readFailures;
    private final ConcurrentHashMap<String, Semaphore> readSessionLocks = new ConcurrentHashMap();
    @Autowired
    private ShakerStreamService shakerStreamService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetExploreSettingsDAO exploreSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.stream.dataset");

    @PostConstruct
    public void init() {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.JEK || DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.CDE || DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.FEK) {
            this.readFailures = CacheBuilder.newBuilder().build();
        } else {
            Params params = ApplicationConfigurator.getParams();
            long cacheMaximumSize = params.getLongParam("dku.caches.dataset.readFailures.maximumSize", 10000L);
            long cacheExpirationSeconds = params.getLongParam("dku.caches.dataset.readFailures.expireAfterWriteS", 3600L);
            this.readFailures = CacheBuilder.newBuilder().maximumSize(cacheMaximumSize).expireAfterWrite(cacheExpirationSeconds, TimeUnit.SECONDS).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamPreparedDataset(HttpServletResponse resp, String fullDatasetName, String script, String requestedOutputSchema, String partitions, String sampling, DatasetLocUtils.DatasetLoc ds, Dataset dataset, AuthCtx authCtx, String contextProjectKey, String readSessionId) throws Exception {
        block11: {
            StreamableDatasetSelection datasetSelection;
            CSVFormatConfig oFP = CSVFormatConfig.getStandardTabExcelFormat();
            OutputFormatter of = FormatFactory.buildFormatter(authCtx, dataset.getProjectKey(), "csv", oFP);
            of.setOutputSchema((Schema)JSON.parse((String)requestedOutputSchema, Schema.class));
            StreamColumnFactory scf = new StreamColumnFactory();
            StreamRowFactory srf = new StreamRowFactory();
            OutputStreamOutputWriter owr = new OutputStreamOutputWriter((OutputStream)resp.getOutputStream(), of);
            owr.init((ColumnFactory)scf);
            SerializedShakerScript scriptObj = (SerializedShakerScript)JSON.parse((String)script, SerializedShakerScript.class);
            if (StringUtils.isNotBlank((String)contextProjectKey)) {
                scriptObj.contextProjectKey = contextProjectKey;
            }
            logger.infoV("Starting to stream dataset %s with output schema %s", new Object[]{fullDatasetName, JSON.json((Object)requestedOutputSchema)});
            ProcessorOutputToSIP pipelineOut = this.shakerStreamService.getProcessorOutput(authCtx, ds.getProjectKey(), scriptObj, (ProcessorOutput)owr, (ColumnFactory)scf, (RowFactory)srf);
            UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, dataset, (ProcessorOutput)pipelineOut, (ColumnFactory)scf, (RowFactory)srf);
            if (StringUtils.isBlank((String)sampling)) {
                datasetSelection = StreamableDatasetSelection.full();
            } else {
                SamplingParam sp = (SamplingParam)JSON.parse((String)sampling, SamplingParam.class);
                datasetSelection = StreamableDatasetSelection.fromSamplingParam(sp);
            }
            DatasetStreamService.updateSelectionWithFilter(datasetSelection, partitions);
            pusher.setDatasetSelection(datasetSelection);
            Semaphore readSessionLock = null;
            if (StringUtils.isNotBlank((String)readSessionId)) {
                readSessionLock = this.acquireReadSessionLock(readSessionId);
            }
            try {
                pusher.push();
                pipelineOut.lastRowEmitted();
            }
            catch (Exception e) {
                if (StringUtils.isNotBlank((String)readSessionId)) {
                    this.readFailures.put((Object)readSessionId, (Object)e);
                    break block11;
                }
                throw e;
            }
            finally {
                if (readSessionLock != null) {
                    readSessionLock.release();
                    this.readSessionLocks.remove(readSessionId);
                }
            }
        }
    }

    private static void updateSelectionWithFilter(DatasetSelection selection, String partitions) {
        if (StringUtils.isBlank((String)partitions)) {
            return;
        }
        if (!StringUtils.isBlank((String)partitions)) {
            Object[] partitionArray = (String[])JSON.parse((String)partitions, String[].class);
            selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
            selection.selectedPartitions = Lists.newArrayList((Object[])partitionArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStream(HttpServletResponse resp, AuthCtx authCtx, Dataset dataset, String format, JsonObject formatParams, List<String> columns, String partitions, String filterExpression, SamplingParam sampling, String readSessionId) throws Exception {
        block32: {
            JSONObjectOutputFormatter formatter;
            Schema datasetSchema = dataset.getSchema();
            Schema outputSchema = DatasetStreamService.getRestrictedSchema(datasetSchema, columns);
            if (sampling == null) {
                sampling = SamplingParam.newFull();
            }
            StreamableDatasetSelection datasetSelection = StreamableDatasetSelection.fromSamplingParam(sampling);
            if (!StringUtils.isBlank((String)partitions)) {
                datasetSelection.withSelectedPartitions(PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), partitions));
            }
            if (!StringUtils.isBlank((String)filterExpression)) {
                datasetSelection.filter = FilterDesc.grelFilter((String)filterExpression);
            }
            String formatType = format;
            if ("memory-json".equals(format)) {
                formatter = new JSONObjectOutputFormatter();
                resp.setContentType("application/json; charset=UTF-8");
            } else {
                DatasetReadAPIUtils.FormatDef fd = DatasetReadAPIUtils.getFormatDef(format, formatParams);
                formatter = FormatFactory.buildFormatter(authCtx, dataset.getProjectKey(), fd.formatMeta.getType(), fd.params);
                if (fd.params != null && fd.params.getApplyColoring()) {
                    DatasetExploreSettings exploreSettings = null;
                    try (Transaction t = this.transactionService.beginRead();){
                        exploreSettings = this.exploreSettingsDAO.getUnsafe(dataset.getProjectKey(), dataset.getName());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to apply coloring to dataset stream", (Throwable)e);
                    }
                    if (exploreSettings != null && exploreSettings.script != null && exploreSettings.script.coloring != null) {
                        if (exploreSettings.script.coloring.scheme == ColoringDefinition.TableColoringScheme.ALL_COLUMNS_VALUES || exploreSettings.script.coloring.scheme == ColoringDefinition.TableColoringScheme.MEANING_AND_STATUS) {
                            if (exploreSettings.script.coloring.coloringGroups != null && exploreSettings.script.coloring.coloringGroups.size() > 0) {
                                exploreSettings.script.coloring.scheme = ColoringDefinition.TableColoringScheme.COLORING_GROUPS;
                            } else if (exploreSettings.script.coloring.individualColumnsRules != null && exploreSettings.script.coloring.individualColumnsRules.size() > 0) {
                                exploreSettings.script.coloring.scheme = ColoringDefinition.TableColoringScheme.INDIVIDUAL_COLUMNS_RULES;
                            }
                        }
                        exploreSettings.script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
                        TableColoring tableColoring = ExportUtils.convertColoring(exploreSettings.script.coloring);
                        formatter.setColoring(tableColoring);
                        exploreSettings.script.contextProjectKey = exploreSettings.script.getProjectKey(dataset);
                        MemScriptRunner.TableWithReport tableWithReport = ((DataService)SpringUtils.getBean(DataService.class)).get_NOTRANSACTION(dataset, exploreSettings.script, null, null, false, authCtx);
                        if (tableWithReport != null && tableWithReport.table != null) {
                            formatter.setMemTable(tableWithReport.table);
                        }
                    }
                }
                formatType = fd.formatMeta.getType();
            }
            formatter.setOutputSchema(outputSchema);
            StreamColumnFactory cf = new StreamColumnFactory();
            StreamRowFactory rf = new StreamRowFactory();
            StreamOutputWriter out = new StreamOutputWriter((OutputStream)resp.getOutputStream(), (OutputFormatter)formatter);
            out.init((ColumnFactory)cf);
            if ("html".equals(format)) {
                resp.setContentType("text/html");
            } else if ("geojson".equals(formatType)) {
                resp.setContentType("application/json");
            }
            Semaphore readSessionLock = null;
            if (StringUtils.isNotBlank((String)readSessionId)) {
                readSessionLock = this.acquireReadSessionLock(readSessionId);
            }
            try {
                UniversalSingleThreadPusher.push(authCtx, dataset, datasetSelection, (ProcessorOutput)out, (ColumnFactory)cf, (RowFactory)rf);
                out.lastRowEmitted();
            }
            catch (Exception e) {
                if (StringUtils.isNotBlank((String)readSessionId)) {
                    this.readFailures.put((Object)readSessionId, (Object)e);
                    break block32;
                }
                throw e;
            }
            finally {
                if (readSessionLock != null) {
                    readSessionLock.release();
                    this.readSessionLocks.remove(readSessionId);
                }
            }
        }
    }

    private static Schema getRestrictedSchema(Schema datasetSchema, List<String> columns) {
        if (columns == null) {
            return datasetSchema;
        }
        Schema restrictedSchema = new Schema();
        for (String colName : columns) {
            if (datasetSchema.getColumn(colName) == null) {
                throw new DKUControllerBase.MalformedRequestException("Column " + colName + " does not exist in dataset");
            }
            restrictedSchema.addColumn(datasetSchema.getColumn(colName));
        }
        return restrictedSchema;
    }

    private Semaphore acquireReadSessionLock(String readSessionId) throws InterruptedException {
        if (this.readSessionLocks.containsKey(readSessionId)) {
            throw ErrorContext.iaef((String)"Read session id %s already in use", (Object)readSessionId, (Object[])new Object[0]);
        }
        Semaphore sessionLock = new Semaphore(1);
        this.readSessionLocks.put(readSessionId, sessionLock);
        sessionLock.acquire();
        return sessionLock;
    }

    public void verifyRead(String readSessionId) throws Exception {
        Exception exception;
        logger.info((Object)("Verification call for " + readSessionId));
        Semaphore readSessionLock = this.readSessionLocks.get(readSessionId);
        if (readSessionLock != null) {
            long readSessionLockAcquireTimeout = ApplicationConfigurator.getParams().getLongParam("dku.datasets.readSessionLockAcquisitionTimeoutS", 30L);
            logger.debugV("Read session lock still exists, trying to acquire it (timeout %d seconds)", new Object[]{readSessionLockAcquireTimeout});
            if (!readSessionLock.tryAcquire(readSessionLockAcquireTimeout, TimeUnit.SECONDS)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Timed out when trying to acquire read session lock during read verification");
            }
        }
        if ((exception = (Exception)this.readFailures.getIfPresent((Object)readSessionId)) != null) {
            logger.info((Object)("Verification has something to say: " + exception.getMessage()));
            throw exception;
        }
    }
}

