/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.staticdata;

import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.server.staticdata.AbstractStaticData;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;

public class CmlDiagnosticsDefinition
implements AbstractStaticData {
    private final String lang;

    public CmlDiagnosticsDefinition(String lang) {
        this.lang = lang;
    }

    @Override
    public String getKey() {
        return "cmlDiagnosticsDefinition";
    }

    @Override
    public Object getData() {
        ArrayList result = new ArrayList();
        Stream.concat(Arrays.stream(MLTask.BackendType.values()), Stream.of((MLTask.BackendType)null)).forEach(backendType -> {
            DiagnosticDefinitionItem item = new DiagnosticDefinitionItem((MLTask.BackendType)((Object)backendType));
            if (!item.definitions.isEmpty()) {
                item.definitions = MLDiagnostics.translateDiagnosticTypes(item.definitions, this.lang);
                result.add(item);
            }
        });
        return result;
    }

    static class DiagnosticDefinitionItem {
        public MLTask.BackendType backendType;
        public Map<WarningsContext.WarningType, MLDiagnostics.DiagnosticDefinition> definitions;

        public DiagnosticDefinitionItem(MLTask.BackendType backendType) {
            this.backendType = backendType;
            this.definitions = MLDiagnostics.getMLTaskDiagnosticsTypes(MLTask.MLTaskType.CLUSTERING, backendType);
        }
    }
}

