/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.DSSIllegalArgumentException;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.io.StringWriter;
import org.geotools.geojson.geom.GeometryJSON;
import org.locationtech.jts.geom.Geometry;

public class GeoJSONUtils {
    private static final GeometryMeaning GEOMETRY_MEANING = new GeometryMeaning();
    private static final GeoPoint GEO_POINT = new GeoPoint();
    private static final int DEFAULT_DECIMALS = DKUApp.getParams().getIntParam("dku.charts.geometry.decimals", Integer.valueOf(5));
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.controller");

    public static String getGeoJSON(Geometry geom) {
        StringWriter sw = new StringWriter();
        try {
            new GeometryJSON(DEFAULT_DECIMALS).write(geom, (Object)sw);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write GeoJSON", e);
        }
        return sw.toString();
    }

    public static String convertSupportedFormatsToGeoJSON(String geometry) throws DSSIllegalArgumentException {
        try {
            Geometry translatedGeom = GEO_POINT.toGeometry(geometry);
            if (translatedGeom == null) {
                translatedGeom = GEOMETRY_MEANING.toGeometry(geometry);
            }
            if (translatedGeom != null) {
                return GeoJSONUtils.getGeoJSON(translatedGeom);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Geometry improperly formatted", (Throwable)e);
            throw new DSSIllegalArgumentException("Geometry improperly formatted", (Throwable)e);
        }
        logger.warn((Object)"Geometry improperly formatted");
        throw new DSSIllegalArgumentException("Geometry improperly formatted");
    }
}

