/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.AbstractSparkSQLDialect;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class DatabricksSQLDialect
extends AbstractSparkSQLDialect {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.databricks");

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.BackTickedNoEscapeFinder.META, QuotedPortionFinders.BackslashEscapedSingleQuotedFinder.META, QuotedPortionFinders.BackslashEscapedDoubleQuotedFinder.META};
    }

    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public String alterQueryForResultSetMetadataOnPreparedStatement(String sql) {
        return "SELECT * FROM (\n" + sql + "\n) _subquery_ LIMIT 0";
    }

    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        return false;
    }

    @Override
    public boolean isCatalogAware() {
        return true;
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return false;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp_ntz", new Integer[]{91, 2014});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_LIKE(" + input + ", " + regex + ")";
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.SHA256, "SHA2(", ", 256)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.SHA512, "SHA2(", ", 512)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "TO_TIMESTAMP(", ")"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_DATE, "TO_DATE(", ")"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "TO_TIMESTAMP(", ")"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = "CAST(" + (String)input + " AS STRING)";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    String timezoneId;
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String string = timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    if (requestedType == Type.DATEONLY) {
                        String sqlFormat = DatabricksSQLDialect.this.toDateFormat(jodaFormat, true);
                        return "TO_DATE(" + (String)input + ",'" + sqlFormat + "')";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        String sqlFormat = DatabricksSQLDialect.this.toDateFormat(jodaFormat, true);
                        return "TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "')";
                    }
                    if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
                        String converted = "CAST(TRANSLATE(TRANSLATE(" + (String)input + ", 'T', ' '), 'Z', '') AS TIMESTAMP)";
                        return StringUtils.equals((String)timezoneId, (String)"UTC") ? converted : "TO_UTC_TIMESTAMP(" + converted + ", '" + timezoneId + "')";
                    }
                    String sqlFormat = DatabricksSQLDialect.this.toDateFormat(jodaFormat, true);
                    String converted = "TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "')";
                    return "TO_UTC_TIMESTAMP(" + converted + ", '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_SUM, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                Object query = "";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "CASE\n        WHEN typeof({0}) = ''string'' AND trim({0}) LIKE ''[%]'' THEN\n            COALESCE(aggregate(from_json(CAST({0} AS STRING) ,''array<string>''), CAST(0 as double), (acc, x) -> acc + coalesce(cast(x as double),0)),0)\n        ELSE\n";
                }
                query = (String)query + "          COALESCE(CAST({0} as DOUBLE),0)\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "    END";
                }
                return MessageFormat.format((String)query, input);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_COUNT, "COUNT", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                Object query = "";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "CASE\n        WHEN typeof({0}) = ''string'' AND trim({0}) LIKE ''[%]'' THEN\n            COALESCE(aggregate(from_json(CAST({0} AS STRING) ,''array<string>''), CAST(0 as double), (acc, x) -> acc + if(cast(x as double) IS NULL,0, 1)),0)\n        ELSE\n";
                }
                query = (String)query + "          IF(CAST({0} as DOUBLE) IS NULL, 0, 1)\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "    END";
                }
                return MessageFormat.format((String)query, input);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    timezoneId = StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC");
                    if (requestedType.isTimestamp() && StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = "FROM_UTC_TIMESTAMP(" + (String)input + ", '" + timezoneId + "')";
                    }
                    String sqlFormat = DatabricksSQLDialect.this.toDateFormat(jodaFormat, false);
                    return "DATE_FORMAT(" + (String)input + ",'" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String interval;
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Object intervalValue = addIntLong;
                String validUnit = unit;
                if ("MILLISECOND".equals(unit)) {
                    validUnit = "SECOND";
                    intervalValue = addIntLong + "/1000";
                }
                if ("YEAR".equals(validUnit)) {
                    interval = "make_interval(" + (String)intervalValue + ", 0, 0, 0, 0, 0, 0)";
                } else if ("MONTH".equals(validUnit)) {
                    interval = "make_interval(0, " + (String)intervalValue + ", 0, 0, 0, 0, 0)";
                } else if ("WEEK".equals(validUnit)) {
                    interval = "make_interval(0, 0, " + (String)intervalValue + ", 0, 0, 0, 0)";
                } else if ("DAY".equals(validUnit)) {
                    interval = "make_interval(0, 0, 0, " + (String)intervalValue + ", 0, 0, 0)";
                } else if ("HOUR".equals(validUnit)) {
                    interval = "make_interval(0, 0, 0, 0, " + (String)intervalValue + ", 0, 0)";
                } else if ("MINUTE".equals(validUnit)) {
                    interval = "make_interval(0, 0, 0, 0, 0, " + (String)intervalValue + ", 0)";
                } else if ("SECOND".equals(validUnit)) {
                    interval = "make_interval(0, 0, 0, 0, 0, 0, " + (String)intervalValue + ")";
                } else {
                    throw new IllegalArgumentException("Datepart " + validUnit + " cannot be used for increment");
                }
                return "(" + datetimeNoTz + " + " + interval + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "PERCENTILE_CONT(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.MEDIAN, "MEDIAN", QueryUtils.Arity.UNARY);
    }

    @Override
    public String datePartExpression(String expr, DatePart part) {
        switch (part) {
            case SECOND_FROM_EPOCH: {
                return "UNIX_TIMESTAMP(" + expr + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(UNIX_TIMESTAMP(" + expr + ") * 1000)";
            }
        }
        return super.datePartExpression(expr, part);
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "CAST(DATE_FORMAT(" + inputDateExpression + ", 'yyyy-MM-dd 00:00:00') AS TIMESTAMP)";
            }
            case HOUR: {
                return "CAST(DATE_FORMAT(" + inputDateExpression + ", 'yyyy-MM-dd HH:00:00') AS TIMESTAMP)";
            }
            case MINUTE: {
                return "CAST(DATE_FORMAT(" + inputDateExpression + ", 'yyyy-MM-dd HH:mm:00') AS TIMESTAMP)";
            }
            case SECOND: {
                return "CAST(DATE_FORMAT(" + inputDateExpression + ", 'yyyy-MM-dd HH:mm:ss') AS TIMESTAMP)";
            }
            case MONTH: {
                return "CAST(DATE_FORMAT(" + inputDateExpression + ", 'yyyy-MM-01') AS TIMESTAMP)";
            }
            case YEAR: {
                return "CAST(DATE_FORMAT(" + inputDateExpression + ", 'yyyy-01-01') AS TIMESTAMP)";
            }
            case WEEK: {
                return this.dateTrunc("CAST(UNIX_TIMESTAMP(DATE_SUB(" + inputDateExpression + "," + this.dayOfWeekExpression(inputDateExpression) + ")) as timestamp)", DateRounding.DAY);
            }
        }
        return super.dateTrunc(inputDateExpression, rounding);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "CAST(DATE_TRUNC('DAY'," + inputDateExpression + ") AS DATE)";
            }
            case WEEK: {
                return "CAST(DATE_TRUNC('WEEK'," + inputDateExpression + ") AS DATE)";
            }
            case MONTH: {
                return "CAST(DATE_TRUNC('MONTH'," + inputDateExpression + ") AS DATE)";
            }
            case YEAR: {
                return "CAST(DATE_TRUNC('YEAR'," + inputDateExpression + ") AS DATE)";
            }
            case QUARTER: {
                return "CAST(DATE_TRUNC('QUARTER'," + inputDateExpression + ") AS DATE)";
            }
        }
        throw new QueryUtils.SQLGenerationException("Local date trunc with unit '" + String.valueOf(rounding) + "' not implemented for " + this.getId());
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "DATE_TRUNC('DAY'," + inputDateExpression + ")";
            }
            case HOUR: {
                return "DATE_TRUNC('HOUR'," + inputDateExpression + ")";
            }
            case WEEK: {
                return "DATE_TRUNC('WEEK'," + inputDateExpression + ")";
            }
            case MONTH: {
                return "DATE_TRUNC('MONTH'," + inputDateExpression + ")";
            }
            case YEAR: {
                return "DATE_TRUNC('YEAR'," + inputDateExpression + ")";
            }
            case QUARTER: {
                return "DATE_TRUNC('QUARTER'," + inputDateExpression + ")";
            }
            case MINUTE: {
                return "DATE_TRUNC('MINUTE'," + inputDateExpression + ")";
            }
            case SECOND: {
                return "DATE_TRUNC('SECOND'," + inputDateExpression + ")";
            }
        }
        throw new QueryUtils.SQLGenerationException("Local date time trunc with unit '" + String.valueOf(rounding) + "' not implemented for " + this.getId());
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case ERA: {
                return "GG";
            }
            case YEAR: 
            case YEAROFERA: {
                return part.shortened ? "yy" : "yyyy";
            }
            case MONTH: {
                if (part.numeric) {
                    if (part.length == 1) {
                        return "M";
                    }
                    return "MM";
                }
                if (part.shortened) {
                    return "MMM";
                }
                return "MMMM";
            }
            case DAY: {
                if (part.length == 1) {
                    return "d";
                }
                return "dd";
            }
            case DAYOFYEAR: {
                return "DD";
            }
            case DAYOFWEEK: {
                if (part.numeric) {
                    return "F";
                }
                if (part.shortened) {
                    return "EEE";
                }
                return "EEEE";
            }
            case HOUR: {
                if (part.length == 1) {
                    return "H";
                }
                return "HH";
            }
            case HALFDAY: {
                return "a";
            }
            case HOUROFHALFDAY: {
                if (part.length == 1) {
                    return "K";
                }
                return "KK";
            }
            case CLOCKHOUR: {
                if (part.length == 1) {
                    return "k";
                }
                return "kk";
            }
            case CLOCKHOUROFHALFDAY: {
                if (part.length == 1) {
                    return "h";
                }
                return "hh";
            }
            case MINUTE: {
                if (part.length == 1) {
                    return "m";
                }
                return "mm";
            }
            case SECOND: {
                if (part.length == 1) {
                    return "s";
                }
                return "ss";
            }
            case MILLISECOND: {
                return "SSS";
            }
            case TIMEZONE: {
                if (part.numeric) {
                    return "X";
                }
                return "Z";
            }
            case TEXT: {
                Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"']");
                if (toEscape.matcher(part.text).matches()) {
                    return "\\'" + part.text.replace("'", "\\'\\'") + "\\'";
                }
                return part.text;
            }
        }
        return part.text;
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.MILLISECOND && forParsing) {
            return SQLCapability.nok("Cannot parse milliseconds");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) {
            return SQLCapability.nok("Cannot use week parts in patterns");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK && forParsing) {
            return SQLCapability.nok("Cannot parse day of week parts");
        }
        return SQLCapability.ok();
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
            return SQLCapability.ok();
        }
        return super.canFormatDate(jodaFormat, forParsing);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        if (dssType == Type.DATE) {
            long timestamp = this.typeDate.msSinceEpoch(dssStrVal);
            if (timestamp == Long.MAX_VALUE) {
                throw new IllegalArgumentException("Invalid date: " + dssStrVal);
            }
            this.ensureThreadLocalsAreHere();
            long offset = ((Calendar)this.localCalendar.get()).getTimeZone().getOffset(timestamp);
            ps2.setTimestamp(colIdx, new Timestamp(timestamp - offset), (Calendar)this.localCalendar.get());
            return;
        }
        super.fill(ps2, dssType, colIdx, dssStrVal);
    }

    @Override
    public String getId() {
        return "Databricks";
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    protected boolean supportsCreateOrReplace() {
        return true;
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        String defaultQuery = super.generateTableStatementSQL(connection, dataset, messages, ifNotExist);
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        String tableCommentClause = this.getTableCommentClause(config, dataset, messages);
        if (tableCommentClause != null) {
            return defaultQuery + tableCommentClause;
        }
        return defaultQuery;
    }

    @Override
    public String getCreateOrReplaceTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n");
        sb.append(this.getCreateTableFieldsSQL(dataset, messages));
        sb.append("\n)");
        String tableCommentClause = this.getTableCommentClause(config, dataset, messages);
        if (tableCommentClause != null) {
            sb.append(tableCommentClause);
        }
        return sb.toString();
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " " + selectExpr};
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ") ";
    }

    @Override
    public void tryDeleteTable(SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table) throws SQLException {
        block2: {
            try {
                SQLUtils.safeExec(conn, "DROP TABLE IF EXISTS " + this.getQuotedTableFullName(catalog, schema, table));
            }
            catch (SQLException e) {
                logger.info((Object)("Drop table failed, table probably did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                if (!this.supportsCommitAndRollback()) break block2;
                conn.rollback();
            }
        }
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.MEDIAN, new SQLAggregateAbility(false, false, true, false));
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        return abilities;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return true;
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, true, false, false, false){

            @Override
            public boolean canUpsertConcurrently() {
                return false;
            }
        };
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.MergeIntoBasedUpdateSelectWriter(this, true, false, false, false);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableLikeMaterializedTemporaryTableWriter(this, true, false);
    }

    @Override
    public String generateTableCommentStatementQuery(DatabaseObjectKey tableKey, String description, InfoMessage.InfoMessages messages) {
        return "COMMENT ON TABLE " + this.getQuotedTableFullName(tableKey.catalog, tableKey.schema, tableKey.name) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(description, tableKey.name, true, messages));
    }

    @Override
    public String generateColumnCommentStatementQuery(DatabaseObjectKey config, SchemaColumn column, InfoMessage.InfoMessages messages) {
        return "ALTER TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.name) + " ALTER COLUMN " + this.quoteIdentifier(column.getName()) + " COMMENT " + this.quoteDescriptionOrEmpty(this.truncateDescription(column.comment, column.getName(), false, messages)) + ";";
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return true;
    }

    @Override
    public boolean supportsCommentsInCreateTableStatement() {
        return true;
    }

    @Override
    public SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, Long seed) {
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            return SQLDialect.RandomSampleClauseLocation.FROM;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            return SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT;
        }
        return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    @Override
    public String getRandomSampleClause(QueryAst.SampleClause sample) {
        StringBuilder sb = new StringBuilder();
        switch (sample.samplingMethod) {
            case RANDOM_FIXED_NB_EXACT: 
            case RANDOM_FIXED_NB: {
                sb.append("RAND(");
                if (sample.seed != null) {
                    sb.append(sample.seed);
                }
                sb.append(")");
                break;
            }
            case RANDOM_FIXED_RATIO: {
                sb.append("TABLESAMPLE (").append(sample.ratio * 100.0).append(" PERCENT)");
                if (sample.seed == null) break;
                sb.append(" REPEATABLE (").append(sample.seed).append(")");
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(sample.samplingMethod) + " sampling is not available for Databricks");
            }
        }
        return sb.toString();
    }

    private String getTableCommentClause(AbstractSQLDatasetHandler.AbstractSQLConfig config, Dataset dataset, InfoMessage.InfoMessages messages) {
        if (config.writeDescriptionsAsSQLComment && dataset.getModel() != null && !StringUtils.isEmpty((String)dataset.getModel().description)) {
            return String.format("\n  COMMENT %s", this.quoteString(this.truncateDescription(dataset.getModel().description, dataset.getName(), true, messages)));
        }
        return null;
    }

    @Override
    public int getMaxTableCommentLengthInChars() {
        return 32766;
    }

    @Override
    public int getMaxColumnCommentLengthInChars() {
        return 32766;
    }
}

