/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class ExasolSQLDialect
extends GenericSQLDialect {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sqldialect.exasol");

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        logger.info((Object)("getSQLType: " + schemaColumn.getName() + " " + String.valueOf(schemaColumn.getType()) + " " + schemaColumn.getTypeString()));
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 3, "tinyint", new Integer[]{-6, 5});
            }
            case SMALLINT: {
                return new DSSTypeSQLMapping(Type.SMALLINT, 3, "smallint", new Integer[]{5, 4});
            }
            case INT: {
                return new DSSTypeSQLMapping(Type.INT, 3, "int", new Integer[]{4, -5});
            }
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.BIGINT, 3, "bigint", new Integer[]{-5, 3});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamp with local time zone", new Integer[]{91});
            }
            case DOUBLE: 
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double", new Integer[]{6});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        logger.info((Object)("fromSQLType: " + name + " " + sqlType + " " + sqlTypeName + " " + sqlPrecision + " " + sqlScale));
        if (sqlType == 5 && sqlPrecision == 3 && sqlScale == 0) {
            return new SchemaColumn(name, Type.TINYINT);
        }
        if (sqlType == 4 && sqlPrecision == 9 && sqlScale == 0) {
            return new SchemaColumn(name, Type.SMALLINT);
        }
        if (sqlType == -5 && sqlPrecision == 18 && sqlScale == 0) {
            return new SchemaColumn(name, Type.INT);
        }
        if (sqlType == 3 && sqlPrecision == 36 && sqlScale == 0) {
            return new SchemaColumn(name, Type.BIGINT);
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        switch (sqlType) {
            case 6: 
            case 8: {
                String v = rs2.getString(colIdx);
                if (StringUtils.isNotEmpty((String)v) && normalizeDoubles && this.needsDoubleNormalization()) {
                    return Double.toString(rs2.getDouble(colIdx));
                }
                return v;
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 2000000;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META};
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.MOD, "MOD", QueryUtils.Arity.BINARY);
        this.addQueryOperator(QueryUtils.OperatorType.INTER, "INTERSECT", QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.UNION.priority);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                String trunc = "TRUNC(%s)";
                String betweenDates = "_BETWEEN(" + end + "," + start + ")";
                switch (unit) {
                    case "YEAR": {
                        return String.format(trunc, "YEARS" + betweenDates);
                    }
                    case "MONTH": {
                        return String.format(trunc, "MONTHS" + betweenDates);
                    }
                    case "WEEK": {
                        return String.format(trunc, "DAYS" + betweenDates + "/7");
                    }
                    case "DAY": {
                        return String.format(trunc, "DAYS" + betweenDates);
                    }
                    case "HOUR": {
                        return String.format(trunc, "HOURS" + betweenDates);
                    }
                    case "MINUTE": {
                        return String.format(trunc, "MINUTES" + betweenDates);
                    }
                    case "SECOND": {
                        return String.format(trunc, "SECONDS" + betweenDates);
                    }
                }
                throw new QueryUtils.SQLGenerationException("Date difference with unit '" + unit + "' not implemented for Exasol");
            }
        });
        this.removeOperator(QueryUtils.OperatorType.ALL);
        this.removeOperator(QueryUtils.OperatorType.CUME_DIST);
        this.removeOperator(QueryUtils.OperatorType.NTILE);
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public boolean supportsNamedWindows() {
        return false;
    }

    @Override
    public boolean supportsWindowNormalRangeFrame() {
        return false;
    }

    @Override
    public boolean supportsWindowTimeRangeFrame() {
        return false;
    }

    @Override
    public void checkWindowForAnalyticFunction(QueryUtils.OperatorType opType, QueryAst.Window window) {
        boolean needsOrdering;
        boolean bl = needsOrdering = opType == QueryUtils.OperatorType.RANK || opType == QueryUtils.OperatorType.DENSE_RANK || opType == QueryUtils.OperatorType.LAG || opType == QueryUtils.OperatorType.LEAD;
        if (needsOrdering && (window == null || !window.isOrdered())) {
            throw new QueryUtils.SQLGenerationException("Operator " + String.valueOf((Object)opType) + " needs to have an ordered over clause in Exasol");
        }
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.NONE;
    }

    @Override
    public String useUTCTimezone() {
        return "ALTER SESSION SET TIME_ZONE = 'UTC'";
    }

    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        return false;
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + "(" + columnListExpr + ")";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return false;
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        String toCharDate = "TO_CHAR(" + inputDateExpression + ", ";
        switch (part) {
            case DAY_OF_MONTH: {
                return toCharDate + "'DD')";
            }
            case HOUR_OF_DAY: {
                return toCharDate + "'HH24')";
            }
            case MINUTE_OF_HOUR: {
                return toCharDate + "'MI')";
            }
            case SECOND_OF_MINUTE: {
                return toCharDate + "'SS')";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(MOD(EXTRACT(SECOND FROM " + inputDateExpression + ") * 1000, 1000))";
            }
            case MONTH_OF_YEAR: {
                return toCharDate + "'MM')";
            }
            case WEEK_OF_YEAR: {
                return toCharDate + "'IW')";
            }
            case QUARTER_OF_YEAR: {
                return toCharDate + "'Q')";
            }
            case YEAR: {
                return toCharDate + "'YYYY')";
            }
            case DAY_OF_WEEK: {
                return toCharDate + "'ID')";
            }
            case SECOND_FROM_EPOCH: {
                return "POSIX_TIME(" + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(" + this.datePartExpression(inputDateExpression, DatePart.SECOND_FROM_EPOCH) + " * 1000)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Exasol", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String truncDate = "TRUNC(" + inputDateExpression + ", ";
        switch (rounding) {
            case DAY: {
                return truncDate + "'DD')";
            }
            case HOUR: {
                return truncDate + "'HH24')";
            }
            case WEEK: {
                return truncDate + "'IW')";
            }
            case MONTH: {
                return truncDate + "'MM')";
            }
            case YEAR: {
                return truncDate + "'YYYY')";
            }
            case QUARTER: {
                return truncDate + "'Q')";
            }
            case MINUTE: {
                return truncDate + "'MI')";
            }
            case SECOND: {
                return truncDate + "'SS')";
            }
        }
        throw new NotImplementedException("Rounding mode not implemented for Exasol: " + String.valueOf(rounding));
    }

    @Override
    public String quoteDate(String str) {
        return "TIMESTAMP " + this.quoteString(str);
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT VIEW_SCHEMA, VIEW_NAME FROM EXA_ALL_VIEWS WHERE VIEW_NAME LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "VIEW_SCHEMA", "");
    }

    @Override
    public String getId() {
        return "Exasol";
    }
}

