/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.VerticaUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NotImplementedException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class VerticaSQLDialect
extends GenericSQLDialect {
    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, -5, "bigint", new Integer[0]);
            }
            case SMALLINT: {
                return new DSSTypeSQLMapping(Type.SMALLINT, -5, "bigint", new Integer[0]);
            }
            case INT: {
                return new DSSTypeSQLMapping(Type.INT, -5, "bigint", new Integer[0]);
            }
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.BIGINT, -5, "bigint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 8, "float", new Integer[]{7, 2, 6});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "float", new Integer[]{7, 2, 6});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamptz", new Integer[0]);
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        if (ifNotExist) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.getQuotedTableFullName(config.catalog, config.schema, config.table)).append(" (\n");
        String partitionColumnName = null;
        if (dataset.getPartitioningSchema().isPartitioned() && "native".equals(config.partitioningType)) {
            if (!PartitioningUtils.isSingleDimension(dataset.getPartitioningSchema())) {
                throw ErrorContext.iae((String)"Input dataset must have 1 dimension");
            }
            Dimension d = dataset.getPartitioningSchema().getSingleDimension();
            partitionColumnName = d.getName();
        }
        int i = 0;
        for (SchemaColumn col : dataset.getSchema().getColumns()) {
            sb.append("\t").append(this.quoteIdentifier(col.getName())).append(" ").append(this.getSQLType((SchemaColumn)col, (Dataset)dataset).sqlDecl);
            if (col.getName().equals(partitionColumnName)) {
                sb.append(" NOT NULL");
            }
            if (i < dataset.getSchema().getColumns().size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
            ++i;
        }
        sb.append(")");
        if (partitionColumnName != null) {
            sb.append(" PARTITION BY ").append(this.quoteIdentifier(partitionColumnName));
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public void dropAndRecreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        if (dataset.getPartitioningSchema().isPartitioned() && "native".equals(config.partitioningType)) {
            String partitionId = partition != null ? partition.id() : null;
            SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, messages, true), messages);
            VerticaUtils.dropPartition(conn, this.getQuotedTableFullName(config.catalog, config.schema, config.table), partitionId);
        } else {
            super.dropAndRecreateTableOrPartition(authCtx, connData, conn, dataset, partition, dropPartitionedTableOnSchemaMismatch, messages);
        }
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TEMPORARY TABLE " + this.getQuotedTableFullName(table) + "(" + columnListExpr + ") ON COMMIT PRESERVE ROWS";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TEMPORARY TABLE " + this.getQuotedTableFullName(table) + " ON COMMIT PRESERVE ROWS AS " + selectExpr};
    }

    @Override
    public String quoteDate(String str) {
        return "(" + this.quoteString(str) + ")::TIMESTAMPTZ";
    }

    @Override
    public String quoteDateOnly(String str) {
        return "(" + this.quoteString(str) + ")::DATE";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "(" + this.quoteString(str) + ")::TIMESTAMP";
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean requiresStrictTypeComparison() {
        return true;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public String useUTCTimezone() {
        return "SET TIME ZONE TO 'UTC'";
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpressionInternal("(" + inputDateExpression + ") AT TIME ZONE 'UTC'", part);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpressionInternal("(" + inputDateExpression + ")", part);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpressionInternal("(" + inputDateExpression + ")", part);
    }

    private String datePartExpressionInternal(String inputExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "FLOOR(EXTRACT(SECOND FROM " + inputExpression + "))";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(EXTRACT(MILLISECONDS FROM " + inputExpression + ")) % 1000";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "WEEK_ISO(" + inputExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "EXTRACT(ISODOW FROM " + inputExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM " + inputExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(EXTRACT(EPOCH FROM " + inputExpression + ") * 1000)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Vertica", part));
    }

    @Override
    public String timeRange(String value, String unit) {
        return this.quoteString(value + " " + unit + "S");
    }

    private String atGmtTimezone(String dateExpression) {
        return dateExpression + " AT TIME ZONE 'GMT'";
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = this.atGmtTimezone(inputDateExpression);
        return "CAST(" + this.dateTruncInternal(dateAtGmt, rounding) + " as TIMESTAMPTZ)";
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return "CAST(" + this.dateTruncInternal(inputDateExpression, rounding) + " as DATE)";
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.dateTruncInternal(inputDateExpression, rounding);
    }

    private String dateTruncInternal(String expressionToTrunc, DateRounding rounding) {
        return "DATE_TRUNC('" + rounding.toString() + "'," + expressionToTrunc + ")";
    }

    @Override
    public boolean hasCaseInsensitiveColumns() {
        return false;
    }

    @Override
    public void executePostConnectTasks(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        if (connData.getSchemaSearchPath() != null && connData.getSchemaSearchPath().length() > 0) {
            SQLUtils.safeExec(conn, "SET search_path TO " + connData.getSchemaSearchPath());
        }
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return ApplicationConfigurator.getParams().getIntParam("dku.sql.vertica.maxVarcharLength", Integer.valueOf(16200));
    }

    @Override
    public int getDefaultVarcharLen() {
        return ApplicationConfigurator.getParams().getIntParam("dku.sql.vertica.defaultVarcharLength", Integer.valueOf(16200));
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.PostgresStringLiteralFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.EscapedStringLiteralFinder.META, QuotedPortionFinders.PostgresDollarQuotedLiteralFinder.META};
    }

    @Override
    public boolean supportsNamedWindows() {
        return false;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.HASH, "HASH", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA256, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                return "SHA256(" + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA512, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                return "SHA512(" + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String second;
                String first = this.toSQLNoBrackets(args[0]);
                if (args.length == 2) {
                    second = this.toSQLNoBrackets(args[1]);
                } else if (args.length > 2) {
                    second = this.apply(Arrays.copyOfRange(args, 1, args.length));
                } else {
                    throw new IllegalArgumentException("CONCAT requires at least two arguments");
                }
                return "CONCAT(" + first + ", " + second + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (args.length > 2) {
                    return "CAST((" + this.toSQLNoBrackets(args[0]) + " AT TIME ZONE " + this.toSQLNoBrackets(args[1]) + ")  AS TIMESTAMP) AT TIME ZONE " + this.toSQLNoBrackets(args[2]);
                }
                if (args.length > 1 && args[1] != null) {
                    return "CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP) AT TIME ZONE " + this.toSQLNoBrackets(args[1]);
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NULL, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs < 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                if (args.length == 0) {
                    return "NULL";
                }
                Type type = this.getParamAs(args[0], Type.class);
                Integer maxLength = this.getParamAs(args[1], Integer.class);
                return VerticaSQLDialect.this.cast("NULL", null, type, maxLength);
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "(", ")::TIMESTAMPTZ"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "(", ")::DATE"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "(", ")::TIMESTAMP"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "YEAR": {
                        String dayDiff = VerticaSQLDialect.this.datePartExpression(end, DatePart.DAY_OF_MONTH) + "-" + VerticaSQLDialect.this.datePartExpression(start, DatePart.DAY_OF_MONTH);
                        String monthDiff = "DATEDIFF(mm, " + start + ", " + end + ")";
                        monthDiff = monthDiff + " - (CASE WHEN (" + dayDiff + ")*" + monthDiff + " < 0 THEN SIGN(" + monthDiff + ") ELSE 0 END)";
                        return VerticaSQLDialect.this.cast("TRUNC((" + monthDiff + ")/12)", null, Type.BIGINT, -1);
                    }
                    case "QUARTER": {
                        String dayDiff = VerticaSQLDialect.this.datePartExpression(end, DatePart.DAY_OF_MONTH) + "-" + VerticaSQLDialect.this.datePartExpression(start, DatePart.DAY_OF_MONTH);
                        String monthDiff = "DATEDIFF(mm, " + start + ", " + end + ")";
                        monthDiff = monthDiff + " - (CASE WHEN (" + dayDiff + ")*" + monthDiff + " < 0 THEN SIGN(" + monthDiff + ") ELSE 0 END)";
                        return VerticaSQLDialect.this.cast("TRUNC((" + monthDiff + ")/3)", null, Type.BIGINT, -1);
                    }
                    case "MONTH": {
                        String dayDiff = VerticaSQLDialect.this.datePartExpression(end, DatePart.DAY_OF_MONTH) + "-" + VerticaSQLDialect.this.datePartExpression(start, DatePart.DAY_OF_MONTH);
                        String monthDiff = "DATEDIFF(mm, " + start + ", " + end + ")";
                        return "(" + monthDiff + " - (CASE WHEN (" + dayDiff + ")*" + monthDiff + " < 0 THEN SIGN(" + monthDiff + ") ELSE 0 END))";
                    }
                    case "WEEK": {
                        return VerticaSQLDialect.this.cast("TRUNC(DATEDIFF(ss, " + start + ", " + end + ")/3600/24/7)", null, Type.BIGINT, -1);
                    }
                    case "DAY": {
                        return VerticaSQLDialect.this.cast("TRUNC(DATEDIFF(ss, " + start + ", " + end + ")/3600/24)", null, Type.BIGINT, -1);
                    }
                    case "HOUR": {
                        return VerticaSQLDialect.this.cast("TRUNC(DATEDIFF(ss, " + start + ", " + end + ")/3600)", null, Type.BIGINT, -1);
                    }
                    case "MINUTE": {
                        return VerticaSQLDialect.this.cast("TRUNC(DATEDIFF(ss, " + start + ", " + end + ")/60)", null, Type.BIGINT, -1);
                    }
                    case "SECOND": {
                        return "DATEDIFF(ss, " + start + ", " + end + ")";
                    }
                }
                throw new IllegalArgumentException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_WIN, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ") OVER ()";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_LIKE(" + input + ", " + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = VerticaSQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "TO_DATE(" + input + ",'" + sqlFormat + "')";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TO_TIMESTAMP(" + input + ",'" + sqlFormat + "')";
                    }
                    return "(TO_TIMESTAMP(" + input + ",'" + sqlFormat + "') AT TIME ZONE '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = VerticaSQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType.isTimestamp() && StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = (String)input + "at time zone '" + timezoneId + "'";
                    }
                    return "to_char(" + (String)input + ",'" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FACT, "FACTORIAL", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "CAST(FACTORIAL(CAST(" + this.toSQLNoBrackets(args[0]) + " AS INTEGER)) AS INTEGER)";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.COSH, "COSH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SINH, "SINH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TANH, "TANH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addGenericFunction(QueryUtils.OperatorType.TRIM, "BTRIM", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(INSTR(", ", COALESCE(", ", '')) - 1)", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.LAST_INDEX_OF, "(INSTR(", ", COALESCE(", ", ''), -1) - 1)", false));
        this.addGenericFunction(QueryUtils.OperatorType.DEC2HEX, "TO_HEX", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRANSLATE, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                boolean hasLower = args[0] instanceof QueryAst.OperatorExpr && ((QueryAst.OperatorExpr)args[0]).op == QueryUtils.OperatorType.LOWER;
                String input = this.toSQLNoBrackets(args[0]);
                String from = this.getParamAs(args[1], String.class);
                String to = this.getParamAs(args[2], String.class);
                return String.format("TRANSLATE(%s, %s, %s)", hasLower ? VerticaSQLDialect.this.cast(input, Type.STRING, Type.STRING, VerticaSQLDialect.this.getMaxPossibleVarcharLen()) : input, VerticaSQLDialect.this.quoteString(from), VerticaSQLDialect.this.quoteString(to));
            }
        });
    }

    @Override
    protected String makeSimpleReplace(QueryUtils.AbstractOperator op, QueryAst.Expr[] args) {
        if (args[1] instanceof QueryAst.ConstExpr && args[2] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[1]).value instanceof String && ((QueryAst.ConstExpr)args[2]).value instanceof String) {
            String replacedStr = (String)((QueryAst.ConstExpr)args[1]).value;
            String replacementStr = (String)((QueryAst.ConstExpr)args[2]).value;
            String expr = op.toSQLNoBrackets(args[0]);
            if (replacedStr.length() > 0 && replacedStr.length() < replacementStr.length()) {
                int maximumInputLength = 65000 * replacedStr.length() / replacementStr.length();
                return "REPLACE(CAST((" + expr + ") AS VARCHAR(" + maximumInputLength + ")), " + this.quoteString(replacedStr) + ", " + this.quoteString(replacementStr) + ")";
            }
        } else if (args[0] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[0]).value instanceof String) {
            String sourceStr = (String)((QueryAst.ConstExpr)args[0]).value;
            int maximumInputLength = 65000;
            return "REPLACE(CAST((" + this.quoteString(sourceStr) + ") AS VARCHAR(" + maximumInputLength + ")), " + op.toSQLNoBrackets(args[1]) + ", " + op.toSQLNoBrackets(args[2]) + ")";
        }
        return super.makeSimpleReplace(op, args);
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return "timestamp".equalsIgnoreCase(sqlTypeName);
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS VARCHAR(100)) = '' THEN NULL ELSE CAST(" + expr + " AS BOOLEAN) END";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.FIRST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.LAST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        return abilities;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"]");
            if (toEscape.matcher(part.text).matches()) {
                return "\"" + part.text.replace("\"", "\\\\\"") + "\"";
            }
            return part.text;
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.MONTH && !part.numeric && !part.shortened) {
            return "FMMonth";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK && !part.numeric && !part.shortened) {
            return "FMDay";
        }
        return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Cannot handle clock hour");
        }
        return SQLCapability.ok();
    }

    @Override
    public String getId() {
        return "Vertica";
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT table_schema, table_name FROM v_catalog.views WHERE table_name LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "table_schema", "");
    }

    @Override
    public String getLogClause(double base, String argument) {
        return this.getLogClauseForSingleArgumentLog(base, argument);
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, false, false, false, false);
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateFromUpdateSelectWriter(this, false, false);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableLikeMaterializedTemporaryTableWriter(this, true, false);
    }
}

