/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.bigquery.simba.BigQueryRetryPolicyExecutorFactory;
import com.dataiku.dip.connections.helpers.RetryPolicyExecutor;
import com.dataiku.dip.connections.helpers.RetryPolicyExecutorFactory;
import com.dataiku.dip.sql.bigquery.BigQueryConflictException;
import com.dataiku.dip.sql.bigquery.BigQueryException;
import com.dataiku.dip.sql.bigquery.BigQueryNotFoundException;
import com.dataiku.dip.sql.bigquery.CancelJobResponse;
import com.dataiku.dip.sql.bigquery.Clustering;
import com.dataiku.dip.sql.bigquery.CreateDatasetInfo;
import com.dataiku.dip.sql.bigquery.CreateTableInfo;
import com.dataiku.dip.sql.bigquery.CreateTemporaryTableInfo;
import com.dataiku.dip.sql.bigquery.DatasetReference;
import com.dataiku.dip.sql.bigquery.DatasetResource;
import com.dataiku.dip.sql.bigquery.EncryptionConfiguration;
import com.dataiku.dip.sql.bigquery.ExtractCsvToCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.ExtractToCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.InsertAllRequest;
import com.dataiku.dip.sql.bigquery.InsertAllRequestRow;
import com.dataiku.dip.sql.bigquery.InsertAllResponse;
import com.dataiku.dip.sql.bigquery.JobConfiguration;
import com.dataiku.dip.sql.bigquery.JobError;
import com.dataiku.dip.sql.bigquery.JobExtractConfiguration;
import com.dataiku.dip.sql.bigquery.JobLoadConfiguration;
import com.dataiku.dip.sql.bigquery.JobQueryConfiguration;
import com.dataiku.dip.sql.bigquery.JobReference;
import com.dataiku.dip.sql.bigquery.JobResource;
import com.dataiku.dip.sql.bigquery.JobStatus;
import com.dataiku.dip.sql.bigquery.JobSummary;
import com.dataiku.dip.sql.bigquery.ListDatasetsResult;
import com.dataiku.dip.sql.bigquery.ListJobsResult;
import com.dataiku.dip.sql.bigquery.ListProjectsResult;
import com.dataiku.dip.sql.bigquery.ListTablesResult;
import com.dataiku.dip.sql.bigquery.LoadAvroFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadCsvFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadORCFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadParquetFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.ProjectSummary;
import com.dataiku.dip.sql.bigquery.RangePartitioning;
import com.dataiku.dip.sql.bigquery.TableDataList;
import com.dataiku.dip.sql.bigquery.TablePartitioning;
import com.dataiku.dip.sql.bigquery.TableReference;
import com.dataiku.dip.sql.bigquery.TableResource;
import com.dataiku.dip.sql.bigquery.TableSummary;
import com.dataiku.dip.sql.bigquery.TimePartitioning;
import com.dataiku.dip.sql.bigquery.TimeoutSettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.GoogleCloudUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.base.Stopwatch;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.AbstractHttpContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.GenericUrl;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpHeaders;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpIOExceptionHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequestFactory;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpResponse;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.ExponentialBackOff;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.escape.CharEscapers;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class BigQueryClient {
    private String jsonApi;
    private static final Map<String, String> EMPTY_MAP = null;
    private static final int CANCEL_JOB_MAX_ATTEMPTS = 5;
    private final String userAgent;
    private final String projectId;
    private final GoogleCredential credentials;
    @Nullable
    private final EncryptionConfiguration encryptionConfiguration;
    private final ProxySettings proxySettings;
    private final TimeoutSettings timeoutSettings;
    private HttpRequestFactory requestFactory;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.client");

    public BigQueryClient(String projectId, GoogleCredential credentials, @Nullable EncryptionConfiguration encryptionConfiguration, ProxySettings proxySettings, TimeoutSettings timeoutSettings, String userAgent, String jsonApiParam) {
        BigQueryClient.checkArgumentNotBlank(projectId, "projectId");
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        this.projectId = projectId;
        this.credentials = this.buildCredentials(credentials);
        this.proxySettings = proxySettings;
        this.timeoutSettings = timeoutSettings;
        this.userAgent = userAgent;
        this.encryptionConfiguration = encryptionConfiguration;
        this.jsonApi = (String)StringUtils.defaultIfBlank((CharSequence)jsonApiParam, (CharSequence)"https://www.googleapis.com/bigquery/v2/");
    }

    public String getProjectId() {
        return this.projectId;
    }

    public List<ProjectSummary> listProjects() throws BigQueryException {
        ListProjectsResult result = this.listProjects(0, null);
        return result.projects;
    }

    public ListProjectsResult listProjects(int maxResults, String pageToken) throws BigQueryException {
        HashMap arguments = Maps.newHashMap();
        if (maxResults > 0) {
            arguments.put("maxResults", String.valueOf(maxResults));
        }
        if (StringUtils.isNotBlank((CharSequence)pageToken)) {
            arguments.put("pageToken", pageToken);
        }
        try {
            return this.sendGet("projects", arguments, ListProjectsResult.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not list projects. Reason: %s", ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public boolean hasDataset(String datasetId) throws BigQueryException {
        try {
            this.getDataset(datasetId);
            return true;
        }
        catch (BigQueryNotFoundException notFoundException) {
            return false;
        }
    }

    public DatasetResource createDataset(CreateDatasetInfo createDatasetInfo) throws BigQueryException {
        Preconditions.checkNotNull((Object)createDatasetInfo, (Object)"createDatasetInfo");
        BigQueryClient.checkArgumentNotBlank(createDatasetInfo.datasetId, "createDatasetInfo.datasetId");
        try {
            String path = BigQueryClient.encodePath("projects", this.projectId, "datasets");
            DatasetResource body = new DatasetResource();
            body.datasetReference = DatasetReference.of(this.projectId, createDatasetInfo.datasetId);
            body.friendlyName = createDatasetInfo.friendlyName;
            body.description = createDatasetInfo.description;
            body.defaultTableExpirationMs = createDatasetInfo.defaultTableExpirationMs;
            body.location = createDatasetInfo.location;
            return this.sendPost(path, body, DatasetResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not create dataset '%s'. Reason: %s", createDatasetInfo.datasetId, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public ListDatasetsResult listDatasets(int maxResults, String pageToken) throws BigQueryException {
        HashMap arguments = Maps.newHashMap();
        if (maxResults > 0) {
            arguments.put("maxResults", String.valueOf(maxResults));
        }
        if (StringUtils.isNotBlank((CharSequence)pageToken)) {
            arguments.put("pageToken", pageToken);
        }
        try {
            String path = BigQueryClient.encodePath("projects", this.projectId, "datasets");
            return this.sendGet(path, arguments, ListDatasetsResult.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not list datasets. Reason: %s", ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public DatasetResource getDataset(String datasetId) throws BigQueryException {
        BigQueryClient.checkArgumentNotBlank(datasetId, "datasetId");
        try {
            String path = BigQueryClient.encodePath("projects", this.projectId, "datasets", datasetId);
            return this.sendGet(path, EMPTY_MAP, DatasetResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not retrieve dataset '%s'. Reason: %s", datasetId, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public InsertAllResponse insertIntoTable(TableRef table, List<? extends Map<String, String>> rows) throws BigQueryException {
        Preconditions.checkNotNull((Object)table, (Object)"table");
        Preconditions.checkNotNull(rows, (Object)"rows");
        Preconditions.checkArgument((!rows.isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < rows.size(); ++i) {
            Map<String, String> row = rows.get(i);
            Preconditions.checkNotNull(row, (Object)("rows[" + i + "]"));
            for (Map.Entry<String, String> entry : row.entrySet()) {
                BigQueryClient.checkArgumentNotBlank(entry.getValue(), "value");
            }
        }
        TableRef tableRef = table.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", tableRef.projectId, "datasets", tableRef.datasetId, "tables", tableRef.tableId, "insertAll");
            InsertAllRequest body = new InsertAllRequest();
            ArrayList<InsertAllRequestRow> insertAllRequestRows = new ArrayList<InsertAllRequestRow>();
            for (Map<String, String> map : rows) {
                insertAllRequestRows.add(new InsertAllRequestRow(map));
            }
            body.rows = insertAllRequestRows;
            return this.sendPost(path, body, InsertAllResponse.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not insert data into table '%s'. Reason: %s", tableRef, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public void deleteDataset(String datasetId) throws BigQueryException {
        BigQueryClient.checkArgumentNotBlank(datasetId, "datasetId");
        try {
            String path = BigQueryClient.encodePath("projects", this.projectId, "datasets", datasetId);
            this.sendDelete(path, DatasetResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not delete dataset '%s'. Reason: %s", datasetId, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public void deleteDatasetIfExist(String datasetId) throws BigQueryException {
        BigQueryClient.checkArgumentNotBlank(datasetId, "datasetId");
        try {
            this.deleteDataset(datasetId);
        }
        catch (BigQueryNotFoundException bigQueryNotFoundException) {
            // empty catch block
        }
    }

    public List<TableSummary> listTables(DatasetRef dataset) throws BigQueryException {
        List<TableSummary> result = this.listTables((DatasetRef)dataset, (int)0, null).tables;
        return result != null ? result : Collections.emptyList();
    }

    public ListTablesResult listTables(DatasetRef dataset, int maxResults, String pageToken) throws BigQueryException {
        Preconditions.checkNotNull((Object)dataset, (Object)"dataset cannot be null");
        HashMap arguments = Maps.newHashMap();
        if (maxResults > 0) {
            arguments.put("maxResults", String.valueOf(maxResults));
        }
        if (StringUtils.isNotBlank((CharSequence)pageToken)) {
            arguments.put("pageToken", pageToken);
        }
        DatasetRef datasetRef = dataset.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", datasetRef.projectId, "datasets", datasetRef.datasetId, "tables");
            return this.sendGet(path, arguments, ListTablesResult.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not list tables in dataset '%s'. Reason: %s", datasetRef, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public boolean hasTable(TableRef table) throws BigQueryException {
        Preconditions.checkNotNull((Object)table, (Object)"table");
        try {
            this.getTable(table);
            return true;
        }
        catch (BigQueryNotFoundException notFoundException) {
            return false;
        }
    }

    public TableResource getTable(TableRef table) throws BigQueryException {
        Preconditions.checkNotNull((Object)table, (Object)"table");
        TableRef tableRef = table.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", tableRef.projectId, "datasets", tableRef.datasetId, "tables", tableRef.tableId);
            return this.sendGet(path, EMPTY_MAP, TableResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not retrieve table '%s'. Reason: %s", tableRef, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public TableResource createTable(DatasetRef dataset, CreateTableInfo createTableInfo) throws BigQueryException {
        Preconditions.checkNotNull((Object)dataset, (Object)"dataset cannot be null");
        this.checkCreateTableInfo(createTableInfo);
        DatasetRef datasetRef = dataset.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", datasetRef.projectId, "datasets", datasetRef.datasetId, "tables");
            TableResource body = new TableResource();
            body.tableReference = TableReference.of(datasetRef.projectId, datasetRef.datasetId, createTableInfo.tableId);
            body.friendlyName = createTableInfo.friendlyName;
            body.description = createTableInfo.description;
            body.schema = createTableInfo.schema;
            body.expirationTime = createTableInfo.expirationTime;
            body.encryptionConfiguration = createTableInfo.encryptionConfiguration;
            if (createTableInfo.partitioning != null) {
                switch (createTableInfo.partitioning.partitionType) {
                    case DATE: {
                        body.timePartitioning = new TimePartitioning();
                        body.timePartitioning.field = createTableInfo.partitioning.field;
                        body.timePartitioning.type = "DAY";
                        break;
                    }
                    case RANGE: {
                        body.rangePartitioning = new RangePartitioning();
                        body.rangePartitioning.field = createTableInfo.partitioning.field;
                        body.rangePartitioning.range = new RangePartitioning.Range();
                        body.rangePartitioning.range.start = String.valueOf(createTableInfo.partitioning.range.start);
                        body.rangePartitioning.range.end = String.valueOf(createTableInfo.partitioning.range.end);
                        body.rangePartitioning.range.interval = String.valueOf(createTableInfo.partitioning.range.interval);
                    }
                }
                List<String> clusteringFields = createTableInfo.partitioning.clusteringFields;
                if (clusteringFields != null && !clusteringFields.isEmpty()) {
                    body.clustering = new Clustering();
                    body.clustering.fields = clusteringFields;
                }
                body.requirePartitionFilter = createTableInfo.partitioning.requirePartitionFilter;
            }
            return this.sendPost(path, body, TableResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not create table in dataset '%s'. Reason: %s", datasetRef, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    @VisibleForTesting
    void checkCreateTableInfo(CreateTableInfo createTableInfo) {
        Preconditions.checkNotNull((Object)createTableInfo, (Object)"createTableInfo cannot be null");
        BigQueryClient.checkArgumentNotBlank(createTableInfo.tableId, "createTableInfo.tableId");
        Preconditions.checkArgument((createTableInfo.tableId.length() <= 1024 ? 1 : 0) != 0, (Object)"createTableInfo.tableId cannot be more than 1024 characters long.");
        if (createTableInfo.schema != null) {
            Preconditions.checkNotNull(createTableInfo.schema.fields, (Object)"createTableInfo.schema.fields cannot be null.");
            Preconditions.checkArgument((!createTableInfo.schema.fields.isEmpty() ? 1 : 0) != 0, (Object)"createTableInfo.schema.fields cannot be empty.");
        }
        if (createTableInfo.partitioning != null) {
            Preconditions.checkNotNull((Object)((Object)createTableInfo.partitioning.partitionType), (Object)"createTableInfo.partitioning.partitionType cannot be null.");
            BigQueryClient.checkArgumentNotBlank(createTableInfo.partitioning.field, "createTableInfo.partitioning.field");
            if (createTableInfo.partitioning.partitionType == TablePartitioning.PartitionType.RANGE) {
                Preconditions.checkNotNull((Object)createTableInfo.partitioning.range, (Object)"createTableInfo.rangePartitioning.range cannot be null when partitionType is RANGE.");
                long start = createTableInfo.partitioning.range.start;
                long end = createTableInfo.partitioning.range.end;
                if (end <= start) {
                    throw new IllegalArgumentException("Range end (" + end + ") must be larger than start (" + start + ")");
                }
                long interval = createTableInfo.partitioning.range.interval;
                if (interval <= 0L) {
                    throw new IllegalArgumentException("Range interval must equal to or greater than 1: " + interval);
                }
            }
        }
    }

    public TableResource createTemporaryTable(DatasetRef dataset, CreateTemporaryTableInfo temporaryTableInfo) throws IOException {
        Preconditions.checkNotNull((Object)dataset, (Object)"dataset cannot be null");
        Preconditions.checkNotNull((Object)temporaryTableInfo, (Object)"temporaryTableInfo cannot be null.");
        Preconditions.checkNotNull((Object)temporaryTableInfo.schema, (Object)"temporaryTableInfo.schema cannot be null.");
        Preconditions.checkArgument((temporaryTableInfo.prefix == null || temporaryTableInfo.prefix.length() <= 992 ? 1 : 0) != 0, (Object)"temporaryTableInfo.prefix cannot be more than 992 characters long.");
        CreateTableInfo tableInfo = new CreateTableInfo();
        tableInfo.description = "Temporary table created by DSS. Can be safely deleted after a few days.";
        tableInfo.schema = temporaryTableInfo.schema;
        tableInfo.expirationTime = BigQueryClient.getExpirationTime(temporaryTableInfo.expirationTime);
        String prefix = StringUtils.isBlank((CharSequence)temporaryTableInfo.prefix) ? "__tmp_DSS_" : temporaryTableInfo.prefix;
        int attemptCount = 100;
        for (int attempt = 0; attempt < attemptCount; ++attempt) {
            tableInfo.tableId = prefix + UUID.randomUUID().toString().replaceAll("-", "");
            try {
                return this.createTable(dataset, tableInfo);
            }
            catch (BigQueryConflictException bigQueryConflictException) {
                continue;
            }
        }
        throw new BigQueryException(String.format("Giving up trying to create a temporary table after %d attempts.", attemptCount));
    }

    public TableDataList getTableData(TableRef table, List<String> selectedFields, long startIndex, int maxResults, String pageToken) throws BigQueryException {
        Preconditions.checkNotNull((Object)table, (Object)"table cannot be null");
        HashMap arguments = Maps.newHashMap();
        if (selectedFields != null && !selectedFields.isEmpty()) {
            arguments.put("selectedFields", Joiner.on((String)",").join(selectedFields));
        }
        if (startIndex > 0L) {
            arguments.put("startIndex", String.valueOf(maxResults));
        }
        if (maxResults > 0) {
            arguments.put("maxResults", String.valueOf(maxResults));
        }
        if (StringUtils.isNotBlank((CharSequence)pageToken)) {
            arguments.put("pageToken", pageToken);
        }
        TableRef tableRef = table.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", tableRef.projectId, "datasets", tableRef.datasetId, "tables", tableRef.tableId, "data");
            return this.sendGet(path, arguments, TableDataList.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not get data about table '%s'. Reason: %s", tableRef, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public void deleteTable(TableRef table) throws BigQueryException, InterruptedException {
        TableRef tableRef = table.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", tableRef.projectId, "datasets", tableRef.datasetId, "tables", tableRef.tableId);
            BigQueryRetryPolicyExecutorFactory.createRetryRateLimitExceptionPolicyExecutor(BigQueryRetryPolicyExecutorFactory.BigQueryClientMode.REST).execute(() -> {
                try {
                    this.sendDelete(path, null);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw BigQueryException.toBigQueryException(e);
                }
            });
        }
        catch (BigQueryException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not delete table '%s'. Reason: %s", tableRef, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public void deleteTableIfExist(TableRef table) throws BigQueryException, InterruptedException {
        try {
            this.deleteTable(table);
        }
        catch (BigQueryNotFoundException bigQueryNotFoundException) {
            // empty catch block
        }
    }

    public JobResource loadFromCloudStorageAsync(TableRef table, List<String> sourceUris, LoadFromCloudStorageOptions options) throws BigQueryException {
        Preconditions.checkNotNull((Object)table, (Object)"table");
        BigQueryClient.checkArgumentNotEmpty(sourceUris, "sourceUris");
        BigQueryClient.checkArgumentGcsUris(sourceUris, "sourceUris");
        if (options instanceof LoadCsvFromCloudStorageOptions) {
            LoadCsvFromCloudStorageOptions csvOptions = (LoadCsvFromCloudStorageOptions)options;
            Preconditions.checkArgument((csvOptions.quote <= '\u007f' ? 1 : 0) != 0, (Object)"options.quote must be a character in the range [0x00,0x7f]");
            Preconditions.checkArgument((csvOptions.fieldDelimiter <= '\u007f' ? 1 : 0) != 0, (Object)"options.fieldDelimiter must be a character in the range [0x00,0x7f]");
        }
        TableRef tableRef = table.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", this.projectId, "jobs");
            JobResource body = new JobResource();
            body.configuration = new JobConfiguration();
            body.configuration.load = this.buildJobLoadConfiguration(tableRef, sourceUris, options);
            return this.sendPost(path, body, JobResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not load data into table in dataset '%s'. Reason: %s", tableRef.datasetId, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public void loadFromCloudStorageSync(TableRef table, List<String> sourceUris, LoadFromCloudStorageOptions options) throws BigQueryException, InterruptedException {
        BigQueryRetryPolicyExecutorFactory.createRetryRateLimitExceptionPolicyExecutor(BigQueryRetryPolicyExecutorFactory.BigQueryClientMode.REST).run(() -> {
            JobResource jobResource = this.loadFromCloudStorageAsync(table, sourceUris, options);
            logger.info((Object)String.format("Job launched with ID %s, waiting for its completion.", jobResource.id));
            return this.waitForJobCompletion(jobResource);
        });
    }

    public JobResource extractToCloudStorageAsync(List<String> destinationUris, TableRef table, ExtractToCloudStorageOptions options) throws BigQueryException {
        BigQueryClient.checkArgumentNotEmpty(destinationUris, "destinationUris");
        Preconditions.checkNotNull((Object)table, (Object)"table");
        BigQueryClient.checkArgumentGcsUris(destinationUris, "destinationUris");
        if (options instanceof ExtractCsvToCloudStorageOptions) {
            ExtractCsvToCloudStorageOptions csvOptions = (ExtractCsvToCloudStorageOptions)options;
            Preconditions.checkArgument((csvOptions.fieldDelimiter <= '\u007f' ? 1 : 0) != 0, (Object)"options.fieldDelimiter must be a character in the range [0x00,0x7f]");
        }
        try {
            TableRef tableRef = table.resolve(this.projectId);
            String path = BigQueryClient.encodePath("projects", this.projectId, "jobs");
            JobResource body = new JobResource();
            body.configuration = new JobConfiguration();
            body.configuration.extract = this.buildJobExtractConfiguration(destinationUris, tableRef, options);
            return this.sendPost(path, body, JobResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not load data into google cloud storage at Uris '%s'. Reason: %s", destinationUris, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public void extractToCloudStorageSync(List<String> destinationUris, TableRef table, ExtractToCloudStorageOptions options) throws BigQueryException, InterruptedException {
        Preconditions.checkNotNull((Object)table, (Object)"table");
        BigQueryRetryPolicyExecutorFactory.createRetryRateLimitExceptionPolicyExecutor(BigQueryRetryPolicyExecutorFactory.BigQueryClientMode.REST).run(() -> {
            JobResource jobResource = this.extractToCloudStorageAsync(destinationUris, table, options);
            logger.info((Object)String.format("Job launched with ID %s, waiting for its completion.", jobResource.id));
            return this.waitForJobCompletion(jobResource);
        });
    }

    public JobResource executeSelectQueryAsync(DatasetRef queryDataSet, String query, TableRef destinationTable) throws BigQueryException {
        return this.executeSelectQueryAsync(queryDataSet, query, destinationTable, false);
    }

    public JobResource executeSelectQueryAsync(DatasetRef queryDataSet, String query, TableRef destinationTable, boolean dryRun) throws BigQueryException {
        DatasetRef queryDatasetRef = queryDataSet == null ? null : queryDataSet.resolve(this.projectId);
        TableRef destinationTableRef = destinationTable == null ? null : destinationTable.resolve(this.projectId);
        try {
            String path = BigQueryClient.encodePath("projects", this.projectId, "jobs");
            JobQueryConfiguration queryConf = new JobQueryConfiguration();
            queryConf.query = query;
            queryConf.useLegacySql = false;
            if (queryDatasetRef != null) {
                queryConf.defaultDataset = DatasetReference.of(queryDatasetRef.projectId, queryDatasetRef.datasetId);
            }
            if (destinationTableRef != null) {
                queryConf.destinationTable = TableReference.of(destinationTableRef.projectId, destinationTableRef.datasetId, destinationTableRef.tableId);
            }
            if (this.encryptionConfiguration != null && !Pattern.compile("^\\s*(CREATE|ALTER|DROP|INSERT|DELETE|TRUNCATE|UPDATE|MERGE)").matcher(query).find()) {
                queryConf.destinationEncryptionConfiguration = this.encryptionConfiguration;
            }
            JobResource body = new JobResource();
            body.configuration = new JobConfiguration();
            body.configuration.dryRun = dryRun;
            body.configuration.query = queryConf;
            return this.sendPost(path, body, JobResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String tableName = destinationTableRef == null ? "<TEMPORARY>" : destinationTableRef.toString();
            String errorMessage = String.format("Could not execute query and dump the result into table '%s'. Reason: %s", tableName, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public JobResource executeSelectQuerySync(DatasetRef queryDataSet, String query, TableRef destinationTable) throws BigQueryException, InterruptedException {
        return this.executeSelectQuerySync(queryDataSet, query, destinationTable, false);
    }

    public JobResource executeSelectQuerySync(DatasetRef queryDataSet, String query, TableRef destinationTable, boolean dryRun) throws BigQueryException, InterruptedException {
        return BigQueryRetryPolicyExecutorFactory.createRetryRateLimitExceptionPolicyExecutor(BigQueryRetryPolicyExecutorFactory.BigQueryClientMode.REST).run(() -> {
            JobResource jobResource = this.executeSelectQueryAsync(queryDataSet, query, destinationTable, dryRun);
            logger.info((Object)String.format("Job launched with ID %s, waiting for its completion.", jobResource.id));
            return this.waitForJobCompletion(jobResource);
        });
    }

    private JobLoadConfiguration buildJobLoadConfiguration(TableRef tableRef, List<String> sourceUris, LoadFromCloudStorageOptions options) {
        Preconditions.checkNotNull((Object)tableRef);
        Preconditions.checkNotNull((Object)tableRef.projectId, (Object)"tableRef must have been resolved");
        if (options == null) {
            options = new LoadCsvFromCloudStorageOptions();
        }
        JobLoadConfiguration jobConf = new JobLoadConfiguration();
        jobConf.sourceUris = sourceUris;
        jobConf.destinationTable = TableReference.of(tableRef.projectId, tableRef.datasetId, tableRef.tableId);
        jobConf.createDisposition = options.createDisposition != null ? options.createDisposition.name() : null;
        jobConf.writeDisposition = options.writeDisposition != null ? options.writeDisposition.name() : null;
        jobConf.schema = options.schema;
        jobConf.ignoreUnknownValues = options.ignoreUnknownValues;
        jobConf.maxBadRecords = options.maxBadRecords;
        if (this.encryptionConfiguration != null) {
            jobConf.destinationEncryptionConfiguration = this.encryptionConfiguration;
        }
        if (options instanceof LoadCsvFromCloudStorageOptions) {
            LoadCsvFromCloudStorageOptions csvOptions = (LoadCsvFromCloudStorageOptions)options;
            jobConf.sourceFormat = "CSV";
            jobConf.autodetect = csvOptions.autodetect;
            jobConf.encoding = csvOptions.encoding;
            jobConf.fieldDelimiter = csvOptions.fieldDelimiter == '\u0000' ? null : String.valueOf(csvOptions.fieldDelimiter);
            jobConf.quote = csvOptions.quote == '\u0000' ? null : String.valueOf(csvOptions.quote);
            jobConf.nullMarker = csvOptions.nullMarker;
            jobConf.allowQuotedNewlines = csvOptions.allowQuotedNewlines;
            jobConf.allowJaggedRows = csvOptions.allowJaggedRows;
            jobConf.skipLeadingRows = csvOptions.skipLeadingRows;
        } else if (options instanceof LoadAvroFromCloudStorageOptions) {
            jobConf.sourceFormat = "AVRO";
        } else if (options instanceof LoadParquetFromCloudStorageOptions) {
            jobConf.sourceFormat = "PARQUET";
        } else if (options instanceof LoadORCFromCloudStorageOptions) {
            jobConf.sourceFormat = "ORC";
        }
        return jobConf;
    }

    private JobExtractConfiguration buildJobExtractConfiguration(List<String> destinationUris, TableRef table, ExtractToCloudStorageOptions options) {
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkNotNull((Object)table.projectId, (Object)"table must have been resolved");
        if (options == null) {
            options = new ExtractCsvToCloudStorageOptions();
        }
        JobExtractConfiguration jobConf = new JobExtractConfiguration();
        jobConf.destinationUris = destinationUris;
        jobConf.printHeader = options.printHeader;
        jobConf.sourceTable = TableReference.of(table.projectId, table.datasetId, table.tableId);
        jobConf.compression = options.createCompression(options.compression);
        jobConf.destinationFormat = options.getDestinationFormat();
        if (options instanceof ExtractCsvToCloudStorageOptions) {
            ExtractCsvToCloudStorageOptions csvOptions = (ExtractCsvToCloudStorageOptions)options;
            jobConf.fieldDelimiter = csvOptions.fieldDelimiter == '\u0000' ? null : String.valueOf(csvOptions.fieldDelimiter);
        }
        return jobConf;
    }

    public List<JobSummary> listJobs() throws BigQueryException {
        ListJobsResult result = this.listJobs(0, null);
        return result.jobs;
    }

    public ListJobsResult listJobs(int maxResults, String pageToken) throws BigQueryException {
        HashMap arguments = Maps.newHashMap();
        if (maxResults > 0) {
            arguments.put("maxResults", String.valueOf(maxResults));
        }
        if (StringUtils.isNotBlank((CharSequence)pageToken)) {
            arguments.put("pageToken", pageToken);
        }
        try {
            String path = BigQueryClient.encodePath("projects", this.projectId, "jobs");
            return this.sendGet(path, arguments, ListJobsResult.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not list jobs. Reason: %s", e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public JobResource getJob(JobReference job) throws BigQueryException {
        Preconditions.checkNotNull((Object)job, (Object)"job cannot be null");
        BigQueryClient.checkArgumentNotBlank(job.jobId, "job.jobId");
        try {
            Object path = BigQueryClient.encodePath("projects", this.projectId, "jobs", job.jobId);
            if (StringUtils.isNotBlank((CharSequence)job.location)) {
                path = (String)path + BigQueryClient.encodeQueryString((Map<String, String>)ImmutableMap.of((Object)"location", (Object)job.location));
            }
            return this.sendGet((String)path, JobResource.class);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not get information about job '%s'. Reason: %s", job.jobId, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    public CancelJobResponse cancelJob(String jobId) throws BigQueryException {
        BigQueryClient.checkArgumentNotBlank(jobId, "jobId");
        try {
            return this.cancelJobWithRetry(jobId);
        }
        catch (BigQueryException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not cancel job '%s'. Reason: %s", jobId, e.getMessage());
            logger.error((Object)errorMessage, (Throwable)e);
            throw new BigQueryException(errorMessage, e);
        }
    }

    private CancelJobResponse cancelJobWithRetry(String jobId) throws IOException, InterruptedException {
        String path = BigQueryClient.encodePath("projects", this.projectId, "jobs", jobId, "cancel");
        RetryPolicyExecutor retryExecutor = RetryPolicyExecutorFactory.createRetryExceptionPolicyExecutor().withMaxRetries(5).withDelay(250).retryOn(e -> {
            if (e != null && e.getCode() == 400 && e.getError() != null && "INVALID_ARGUMENT".equals(e.getError().status)) {
                logger.warn((Object)"Google returned an INVALID_ARGUMENT response to a cancelJob request. Trying again.", (Throwable)e);
                return true;
            }
            return false;
        });
        return retryExecutor.execute(() -> {
            try {
                return this.sendPost(path, null, CancelJobResponse.class);
            }
            catch (IOException | GeneralSecurityException e) {
                String errorMessage = String.format("Could not cancel job '%s'. Reason: %s", jobId, e.getMessage());
                logger.error((Object)errorMessage, (Throwable)e);
                throw new BigQueryException(errorMessage, e);
            }
        });
    }

    public JobResource waitForJobCompletion(JobResource job) throws InterruptedException, BigQueryException {
        return this.waitForJobCompletion(job, null, 0L);
    }

    public JobResource waitForJobCompletion(JobResource job, TimeUnit timeoutUnit, long timeoutValue) throws InterruptedException, BigQueryException {
        Preconditions.checkNotNull((Object)job, (Object)"job cannot be null");
        Stopwatch stopwatch = Stopwatch.createStarted();
        Stopwatch lastLoggedStopwatch = Stopwatch.createStarted();
        while (job.status.isPendingOrRunning() && (timeoutUnit == null || stopwatch.elapsed(timeoutUnit) < timeoutValue)) {
            if (lastLoggedStopwatch.elapsed(TimeUnit.SECONDS) >= 60L) {
                logger.info((Object)("Job is still pending or running... Waiting for completion (already waited for " + String.valueOf(stopwatch) + ")"));
                lastLoggedStopwatch.reset();
            }
            Thread.sleep(1000L);
            job = this.getJob(job.jobReference);
        }
        if (job.status.errorResult != null) {
            throw new BigQueryException(BigQueryClient.formatJobError(job.status));
        }
        return job;
    }

    private static String formatJobError(JobStatus status) {
        StringBuilder result = new StringBuilder();
        result.append(status.errorResult != null && StringUtils.isNotBlank((CharSequence)status.errorResult.message) ? status.errorResult.message : "Unknown error");
        if (status.errors != null) {
            int errorIndex = 0;
            for (JobError error : status.errors) {
                if (errorIndex > 0) {
                    result.append("\nCaused by:");
                    BigQueryClient.appendErrorItem(result, errorIndex, "message", error.message);
                }
                BigQueryClient.appendErrorItem(result, errorIndex, "reason", error.reason);
                BigQueryClient.appendErrorItem(result, errorIndex, "location", error.location);
                BigQueryClient.appendErrorItem(result, errorIndex, "debugInfo", error.debugInfo);
                ++errorIndex;
            }
        }
        return result.toString();
    }

    private static void appendErrorItem(StringBuilder errorMsg, int errorIndex, String itemName, String itemValue) {
        if (StringUtils.isNotBlank((CharSequence)itemValue)) {
            errorMsg.append("\n");
            if (errorIndex > 0) {
                errorMsg.append("  ");
            }
            errorMsg.append(itemName).append(": ").append(itemValue);
        }
    }

    private GoogleCredential buildCredentials(GoogleCredential credential) {
        return credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/bigquery"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequestFactory getRequestFactory() throws GeneralSecurityException, IOException {
        if (this.requestFactory == null) {
            BigQueryClient bigQueryClient = this;
            synchronized (bigQueryClient) {
                this.requestFactory = GoogleCloudUtils.buildRequestFactory(this.proxySettings, this.credentials, false);
            }
        }
        return this.requestFactory;
    }

    private <T> T sendGet(String path, Class<T> clazz) throws IOException, GeneralSecurityException {
        return this.sendGet(path, EMPTY_MAP, clazz);
    }

    private <T> T sendGet(String path, Map<String, String> map, Class<T> clazz) throws IOException, GeneralSecurityException {
        HttpRequest request = this.getRequestFactory().buildGetRequest(this.buildUrl(path, map));
        return this.sendRequest(request, clazz);
    }

    private <T> T sendPost(String path, Object body, Class<T> clazz) throws IOException, GeneralSecurityException {
        return this.sendPost(path, EMPTY_MAP, body, clazz);
    }

    private <T> T sendPost(String path, Map<String, String> map, Object body, Class<T> clazz) throws IOException, GeneralSecurityException {
        HttpRequest request = this.getRequestFactory().buildPostRequest(this.buildUrl(path, map), (HttpContent)new JsonHttpContent(body));
        return this.sendRequest(request, clazz);
    }

    private <T> T sendDelete(String path, Class<T> clazz) throws IOException, GeneralSecurityException {
        return this.sendDelete(path, EMPTY_MAP, clazz);
    }

    private <T> T sendDelete(String path, Map<String, String> map, Class<T> clazz) throws IOException, GeneralSecurityException {
        HttpRequest request = this.getRequestFactory().buildDeleteRequest(this.buildUrl(path, map));
        return this.sendRequest(request, clazz);
    }

    private <T> T sendRequest(HttpRequest request, Class<T> clazz) throws IOException {
        logger.debug((Object)(request.getRequestMethod() + " " + String.valueOf(request.getUrl())));
        request.setThrowExceptionOnExecuteError(false);
        request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
        if (this.timeoutSettings != null) {
            if (this.timeoutSettings.connectionTimeoutInMs >= 0) {
                request.setConnectTimeout(this.timeoutSettings.connectionTimeoutInMs);
            }
            if (this.timeoutSettings.readTimeoutInMs >= 0) {
                request.setReadTimeout(this.timeoutSettings.readTimeoutInMs);
            }
        }
        if (this.userAgent != null) {
            request.setHeaders(new HttpHeaders().setUserAgent(this.userAgent));
        }
        HttpResponse response = request.execute();
        try {
            String responseBody = response.parseAsString();
            if (response.isSuccessStatusCode()) {
                Object object = clazz != null ? JSON.parse((String)responseBody, clazz) : null;
                return (T)object;
            }
            if (responseBody != null && responseBody.startsWith("{")) {
                try {
                    GoogleCloudUtils.GoogleCloudErrorResponse errorResponse = (GoogleCloudUtils.GoogleCloudErrorResponse)JSON.parse((String)responseBody, GoogleCloudUtils.GoogleCloudErrorResponse.class);
                    GoogleCloudUtils.GoogleCloudError error = errorResponse != null ? errorResponse.error : null;
                    int errorCode = error == null ? 0 : errorResponse.error.code;
                    throw BigQueryClient.newBigQueryException(errorCode, GoogleCloudUtils.extractMessage(errorResponse), error);
                }
                catch (RuntimeException e) {
                    logger.info((Object)"Failed to decode JSON error", (Throwable)e);
                }
            }
            throw BigQueryClient.newBigQueryException(response.getStatusCode(), GoogleCloudUtils.extractErrorMessage(response, responseBody), null);
        }
        finally {
            response.disconnect();
        }
    }

    private static BigQueryException newBigQueryException(int errorCode, String errorMesssage, GoogleCloudUtils.GoogleCloudError error) {
        switch (errorCode) {
            case 404: {
                return new BigQueryNotFoundException(errorCode, errorMesssage);
            }
            case 409: {
                return new BigQueryConflictException(errorCode, errorMesssage);
            }
        }
        return new BigQueryException(errorCode, errorMesssage, error);
    }

    private GenericUrl buildUrl(String query, Map<String, String> map) {
        String uri = this.jsonApi + query;
        GenericUrl url = new GenericUrl(uri);
        if (map != null) {
            url.putAll(map);
        }
        return url;
    }

    private static String encodePath(String ... items) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                result.append("/");
            }
            result.append(CharEscapers.escapeUriPath((String)items[i]));
        }
        return result.toString();
    }

    private static String encodeQueryString(Map<String, String> items) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> e : items.entrySet()) {
            result.append(result.length() == 0 ? "?" : "&");
            result.append(CharEscapers.escapeUriQuery((String)e.getKey()));
            result.append("=");
            result.append(CharEscapers.escapeUriQuery((String)e.getValue()));
        }
        return result.toString();
    }

    private static void checkArgumentNotBlank(String paramValue, String paramName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)paramValue), (Object)(paramName + " cannot be null or empty."));
    }

    private static <T> void checkArgumentNotEmpty(List<T> paramValue, String paramName) {
        Preconditions.checkArgument((paramValue != null && !paramValue.isEmpty() ? 1 : 0) != 0, (Object)(paramName + " cannot be null or empty."));
    }

    private static void checkArgumentGcsUris(List<String> gcsUris, String parameterName) {
        for (int i = 0; i < gcsUris.size(); ++i) {
            String uri = gcsUris.get(i);
            BigQueryClient.checkArgumentNotBlank(uri, parameterName + "[" + i + "]");
            Preconditions.checkArgument((boolean)uri.startsWith("gs://"), (Object)(parameterName + "[" + i + "] must start with 'gs://'"));
        }
    }

    private static long getExpirationTime(long expirationTime) {
        long now = System.currentTimeMillis();
        if (expirationTime == 0L) {
            return now + 86400000L;
        }
        if (expirationTime < now) {
            throw new IllegalArgumentException("temporaryTableInfo.schema cannot be set to a date in the past: " + expirationTime);
        }
        return expirationTime;
    }

    public static class TableRef {
        public final String projectId;
        public final String datasetId;
        public final String tableId;

        public TableRef(String datasetId, String tableId) {
            this(null, datasetId, tableId);
        }

        public TableRef(DatasetRef dataset, String tableId) {
            Preconditions.checkNotNull((Object)dataset, (Object)"dataset cannot be null");
            BigQueryClient.checkArgumentNotBlank(tableId, "tableId");
            this.projectId = dataset.projectId;
            this.datasetId = dataset.datasetId;
            this.tableId = tableId;
        }

        public TableRef(String projectId, String datasetId, String tableId) {
            BigQueryClient.checkArgumentNotBlank(datasetId, "datasetId");
            BigQueryClient.checkArgumentNotBlank(tableId, "tableId");
            this.projectId = projectId;
            this.datasetId = datasetId;
            this.tableId = tableId;
        }

        public DatasetRef getDatasetRef() {
            return new DatasetRef(this.projectId, this.datasetId);
        }

        TableRef resolve(String defaultProjectId) {
            return new TableRef(StringUtils.isNotBlank((CharSequence)this.projectId) ? this.projectId : defaultProjectId, this.datasetId, this.tableId);
        }

        public String toString() {
            if (StringUtils.isNotBlank((CharSequence)this.projectId)) {
                return this.projectId + "." + this.datasetId + "." + this.tableId;
            }
            return this.datasetId + "." + this.tableId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableRef tableRef = (TableRef)o;
            return Objects.equals(StringUtils.trimToNull((String)this.projectId), StringUtils.trimToNull((String)tableRef.projectId)) && this.datasetId.equals(tableRef.datasetId) && this.tableId.equals(tableRef.tableId);
        }

        public int hashCode() {
            return Objects.hash(StringUtils.trimToNull((String)this.projectId), this.datasetId, this.tableId);
        }
    }

    public static class DatasetRef {
        public final String projectId;
        public final String datasetId;

        public DatasetRef(String datasetId) {
            this(null, datasetId);
        }

        public DatasetRef(String projectId, String datasetId) {
            BigQueryClient.checkArgumentNotBlank(datasetId, "datasetId");
            this.projectId = projectId;
            this.datasetId = datasetId;
        }

        DatasetRef resolve(String defaultProjectId) {
            return new DatasetRef(StringUtils.isNotBlank((CharSequence)this.projectId) ? this.projectId : defaultProjectId, this.datasetId);
        }

        public String toString() {
            if (StringUtils.isNotBlank((CharSequence)this.projectId)) {
                return this.datasetId;
            }
            return this.projectId + "." + this.datasetId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatasetRef that = (DatasetRef)o;
            return Objects.equals(StringUtils.trimToNull((String)this.projectId), StringUtils.trimToNull((String)that.projectId)) && this.datasetId.equals(that.datasetId);
        }

        public int hashCode() {
            return Objects.hash(StringUtils.trimToNull((String)this.projectId), this.datasetId);
        }
    }

    private static class JsonHttpContent
    extends AbstractHttpContent {
        private final String data;

        public JsonHttpContent(Object data) {
            super("application/json; charset=UTF-8");
            this.data = data != null ? new Gson().toJson(data) : null;
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.data != null) {
                out.write(this.data.getBytes(Charsets.UTF_8));
            }
        }
    }
}

