/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import java.util.List;

public class CombinedSelectQueryBuilder {
    QueryAst.CombinedTableLikes combinedTables = new QueryAst.CombinedTableLikes();

    public static CombinedSelectQueryBuilder newUnion(boolean deduplicate) {
        QueryAst.QuerySetOperator operator = deduplicate ? QueryAst.QuerySetOperator.UNION : QueryAst.QuerySetOperator.UNION_ALL;
        return new CombinedSelectQueryBuilder(operator, null);
    }

    public static CombinedSelectQueryBuilder newIntersect() {
        return new CombinedSelectQueryBuilder(QueryAst.QuerySetOperator.INTERSECT, null);
    }

    CombinedSelectQueryBuilder(QueryAst.QuerySetOperator operator, List<SelectQueryBuilder> qbs) {
        this.combinedTables.operator = operator;
        if (qbs != null) {
            for (SelectQueryBuilder qb : qbs) {
                this.combinedTables.tables.add(qb.query);
            }
        }
    }

    public void add(SelectQueryBuilder qb) {
        this.combinedTables.tables.add(qb.query);
    }

    public String toSQL(SQLDialect dialect) {
        return QuerySQLWriter.generateSafeSQL(dialect, this.combinedTables);
    }
}

