/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.regex;

import com.dataiku.dip.antlrgrammars.RegexJava;
import com.dataiku.dip.antlrgrammars.RegexJavaLexer;
import com.dataiku.dip.antlrgrammars.RegexJavaVisitor;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringUtils;

public class RegexParser {
    Pattern POSIX_PREDICATE = Pattern.compile("Alpha|Alnum|Upper|Lower|Digit|XDigit|Space|Punct|Blank|Print|Graph|Cntrl", 2);
    Pattern UNICODE_CATEGORY = Pattern.compile("L[lutmo]?|M[nec]?|Z[lsp]?|S[mcko]?|N[dlo]?|P[dseifc]?|C[cfn]?");
    Pattern UNICODE_PREDICATE = Pattern.compile("Alphabetic|Assigned|Control|Hex_?Digit|Ideographic|Join_?Control|Letter|Lowercase|Titlecase|Uppercase|Punctuation|Noncharacter_?Code_?Point|White_?Space", 2);
    private final String pattern;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.regex.parser");

    public RegexParser(String pattern) {
        this.pattern = pattern;
    }

    public Set<Capability> listCapabilitiesNeeded() {
        RegexJava parser = this.initializeParser();
        RegexJava.RootContext root = parser.root();
        return root.accept(new CapabilitiesVisitor(parser));
    }

    protected RegexJava initializeParser() {
        logger.info((Object)("Initialize regex parser for : " + this.pattern));
        RegexJavaLexer lexer = new RegexJavaLexer((CharStream)CharStreams.fromString((String)this.pattern));
        RegexJava parser = new RegexJava((TokenStream)new CommonTokenStream((TokenSource)lexer));
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                Object message;
                IntervalSet expectedTokens = ((RegexJava)recognizer).getExpectedTokens();
                if (((CommonToken)offendingSymbol).getType() == -1) {
                    TreeSet<String> expectedTokensNames = new TreeSet<String>();
                    for (Integer expectedToken : expectedTokens.toSet()) {
                        expectedTokensNames.add(recognizer.getVocabulary().getDisplayName(expectedToken.intValue()));
                    }
                    message = "Unexpected end of expression, expected : " + String.join((CharSequence)", ", expectedTokensNames);
                } else {
                    message = String.format("Did not recognize expression \"%s\" at %d:%d", ((CommonToken)offendingSymbol).getText(), line, charPositionInLine);
                }
                logger.warnV("Regex parsing error : %s at %d:%d, original message:%s", new Object[]{message, line, charPositionInLine, msg});
                throw new RuntimeException((String)message);
            }
        };
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        return parser;
    }

    private class CapabilitiesVisitor
    extends AbstractParseTreeVisitor<Set<Capability>>
    implements RegexJavaVisitor<Set<Capability>> {
        private final RegexJava parser;

        public CapabilitiesVisitor(RegexJava parser) {
            this.parser = parser;
        }

        protected Set<Capability> defaultResult() {
            return Sets.newHashSet();
        }

        protected Set<Capability> aggregateResult(Set<Capability> aggregate, Set<Capability> nextResult) {
            HashSet ret = Sets.newHashSet();
            if (aggregate != null) {
                ret.addAll(aggregate);
            }
            if (nextResult != null) {
                ret.addAll(nextResult);
            }
            return ret;
        }

        @Override
        public Set<Capability> visitRoot(RegexJava.RootContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitRegex(RegexJava.RegexContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitBranch(RegexJava.BranchContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitPiece(RegexJava.PieceContext ctx) {
            HashSet<Capability> ret = new HashSet<Capability>();
            ret.addAll((Collection)this.visitChildren((RuleNode)ctx));
            List<RegexJava.QuantifierContext> quantifiers = ctx.quantifier();
            if (quantifiers != null && quantifiers.size() > 1) {
                RegexJava.QuantifierContext second = quantifiers.get(1);
                if (second.PLUS() != null) {
                    ret.add(new Capability(CapabilityType.POSSESSIVE_QUANTIFIER));
                } else if (second.QUESTION() != null) {
                    ret.add(new Capability(CapabilityType.RELUCTANT_QUANTIFIER));
                }
            }
            return ret;
        }

        @Override
        public Set<Capability> visitQuantifier(RegexJava.QuantifierContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitQuantity(RegexJava.QuantityContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitProperty_char_class(RegexJava.Property_char_classContext ctx) {
            String name = ctx.Category().getText();
            if (RegexParser.this.UNICODE_CATEGORY.matcher(name).matches()) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_UNICODE_CATEGORY)});
            }
            if (name.startsWith("gc=") || name.startsWith("general_category=")) {
                String propName = name.substring(name.indexOf(61) + 1);
                if (RegexParser.this.UNICODE_CATEGORY.matcher(propName).matches()) {
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_EQ_UNICODE_CATEGORY)});
                }
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_CLASS)});
            }
            if (RegexParser.this.POSIX_PREDICATE.matcher(name).matches()) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_POSIX_PREDICATE)});
            }
            if (name.startsWith("Is")) {
                String propName = name.substring(2);
                if (RegexParser.this.UNICODE_PREDICATE.matcher(propName).matches()) {
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_IS_UNICODE_PREDICATE)});
                }
                if (RegexParser.this.POSIX_PREDICATE.matcher(propName).matches()) {
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_IS_POSIX_PREDICATE)});
                }
                if (RegexParser.this.UNICODE_CATEGORY.matcher(propName).matches()) {
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_IS_UNICODE_CATEGORY)});
                }
                try {
                    Character.UnicodeScript.forName(propName);
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_IS_UNICODE_SCRIPT)});
                }
                catch (Exception e) {
                    logger.warn((Object)("Did not find unicode script for " + name));
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_CLASS, name)});
                }
            }
            if (name.startsWith("In") || name.startsWith("blk=") || name.startsWith("block=")) {
                boolean usesIn = name.startsWith("In");
                String propName = name.startsWith("In") ? name.substring(2) : name.substring(name.indexOf(61) + 1);
                try {
                    Character.UnicodeBlock.forName(propName);
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(usesIn ? CapabilityType.PROPERTY_IN_UNICODE_BLOCK : CapabilityType.PROPERTY_EQ_UNICODE_BLOCK)});
                }
                catch (Exception e) {
                    logger.warn((Object)("Did not find unicode block for " + name));
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_CLASS, name)});
                }
            }
            if (name.startsWith("sc=") || name.startsWith("script=")) {
                String propName = name.substring(name.indexOf(61) + 1);
                try {
                    Character.UnicodeScript.forName(propName);
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_EQ_UNICODE_SCRIPT)});
                }
                catch (Exception e) {
                    logger.warn((Object)("Did not find unicode script for " + name));
                    return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_CLASS, name)});
                }
            }
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PROPERTY_CLASS, name)});
        }

        @Override
        public Set<Capability> visitNamedCapture(RegexJava.NamedCaptureContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitNamedRef(RegexJava.NamedRefContext ctx) {
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.NAMED_REFERENCE)});
        }

        @Override
        public Set<Capability> visitQuote(RegexJava.QuoteContext ctx) {
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.QUOTE)});
        }

        @Override
        public Set<Capability> visitPredefClass(RegexJava.PredefClassContext ctx) {
            String name = ctx.getText();
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.PREDEF_CLASS, name.substring(1))});
        }

        @Override
        public Set<Capability> visitBoundary(RegexJava.BoundaryContext ctx) {
            String name = ctx.getText();
            if (name.startsWith("\\")) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.BOUNDARY, name.substring(1))});
            }
            return new HashSet<Capability>();
        }

        @Override
        public Set<Capability> visitLinebreak(RegexJava.LinebreakContext ctx) {
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.LINEBREAK)});
        }

        @Override
        public Set<Capability> visitFlagSwitch(RegexJava.FlagSwitchContext ctx) {
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.FLAG_SWITCH)});
        }

        @Override
        public Set<Capability> visitBackRef(RegexJava.BackRefContext ctx) {
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.BACK_REFERENCE)});
        }

        @Override
        public Set<Capability> visitVanillaChar(RegexJava.VanillaCharContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitNestedSingleCharEsc(RegexJava.NestedSingleCharEscContext ctx) {
            if ("\\-".equals(ctx.getText())) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.ESCAPED_DASH)});
            }
            return new HashSet<Capability>();
        }

        @Override
        public Set<Capability> visitAtom(RegexJava.AtomContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitGroup(RegexJava.GroupContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            if (ctx.StartNonCapturing() != null) {
                if (ctx.StartNonCapturing().getText().startsWith("(?:")) {
                    ret.add(new Capability(CapabilityType.NON_CAPTURING));
                } else {
                    ret.add(new Capability(CapabilityType.NON_CAPTURING_SWITCH));
                }
            } else if (ctx.namedCapture() != null) {
                ret.add(new Capability(CapabilityType.NAMED_GROUP));
            } else if (ctx.PositiveLookahead() != null) {
                ret.add(new Capability(CapabilityType.POSITIVE_LOOKAHEAD));
            } else if (ctx.NegativeLookahead() != null) {
                ret.add(new Capability(CapabilityType.NEGATIVE_LOOKAHEAD));
            } else if (ctx.PositiveLookbehind() != null) {
                ret.add(new Capability(CapabilityType.POSITIVE_LOOKBEHIND));
            } else if (ctx.NegativeLookbehind() != null) {
                ret.add(new Capability(CapabilityType.NEGATIVE_LOOKBEHIND));
            }
            return ret;
        }

        @Override
        public Set<Capability> visitChar_class(RegexJava.Char_classContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitChar_group(RegexJava.Char_groupContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitChar_group_full_expr(RegexJava.Char_group_full_exprContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            if (ctx.children.get(0) instanceof TerminalNode) {
                ret.add(new Capability(CapabilityType.LEADING_DASH));
            }
            if (ctx.children.size() > 1 && ctx.children.get(ctx.children.size() - 1) instanceof TerminalNode) {
                if (ctx.children.size() > 2 && ctx.children.get(ctx.children.size() - 2) instanceof TerminalNode) {
                    ret.add(new Capability(CapabilityType.TRAILING_DOUBLE_DASH));
                } else {
                    ret.add(new Capability(CapabilityType.TRAILING_DASH));
                }
            }
            return ret;
        }

        @Override
        public Set<Capability> visitFirstrange(RegexJava.FirstrangeContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            if (ret.contains(new Capability(CapabilityType.NONLEADING_RANGE_FROM_DASH))) {
                ret.remove(new Capability(CapabilityType.NONLEADING_RANGE_FROM_DASH));
                ret.add(new Capability(CapabilityType.LEADING_RANGE_FROM_DASH));
            }
            return ret;
        }

        @Override
        public Set<Capability> visitConcatchar(RegexJava.ConcatcharContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitChar_range(RegexJava.Char_rangeContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            if ("-".equals(((ParseTree)ctx.children.get(0)).getText())) {
                ret.add(new Capability(CapabilityType.NONLEADING_RANGE_FROM_DASH));
            }
            if ("-".equals(((ParseTree)ctx.children.get(2)).getText())) {
                ret.add(new Capability(CapabilityType.RANGE_TO_DASH));
            }
            return ret;
        }

        @Override
        public Set<Capability> visitConcatcharrange(RegexJava.ConcatcharrangeContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitUnion(RegexJava.UnionContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            ret.add(new Capability(CapabilityType.CHARGROUP_UNION));
            return ret;
        }

        @Override
        public Set<Capability> visitNonleadingdash(RegexJava.NonleadingdashContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            ret.add(new Capability(CapabilityType.MIDDLE_DASH));
            return ret;
        }

        @Override
        public Set<Capability> visitFirstchar(RegexJava.FirstcharContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitIntersection(RegexJava.IntersectionContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            ret.add(new Capability(CapabilityType.CHARGROUP_INTERSECTION));
            return ret;
        }

        @Override
        public Set<Capability> visitNonleadingdashchargroup(RegexJava.NonleadingdashchargroupContext ctx) {
            Set ret = (Set)this.visitChildren((RuleNode)ctx);
            ret.add(new Capability(CapabilityType.MIDDLE_DASH));
            return ret;
        }

        @Override
        public Set<Capability> visitChar_group_char(RegexJava.Char_group_charContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Set<Capability> visitOctal(RegexJava.OctalContext ctx) {
            return CapabilitiesVisitor.getOctalCapability(ctx);
        }

        @Override
        public Set<Capability> visitHexadecimal(RegexJava.HexadecimalContext ctx) {
            return CapabilitiesVisitor.getHexadecimalCapability(ctx);
        }

        @Override
        public Set<Capability> visitSingle_char(RegexJava.Single_charContext ctx) {
            return (Set)this.visitChildren((RuleNode)ctx);
        }

        private static HashSet<Capability> getHexadecimalCapability(ParserRuleContext ctx) {
            if (ctx.getText().contains("\\u")) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.HEXADECIMAL_4)});
            }
            if (ctx.getText().contains("\\x{")) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.HEXADECIMAL_N)});
            }
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.HEXADECIMAL_2)});
        }

        private static HashSet<Capability> getOctalCapability(ParserRuleContext ctx) {
            String octalValue = ctx.getText().substring(2);
            if (octalValue.length() == 1) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.OCTAL_1)});
            }
            if (octalValue.length() == 2) {
                return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.OCTAL_2)});
            }
            return Sets.newHashSet((Object[])new Capability[]{new Capability(CapabilityType.OCTAL_3)});
        }
    }

    public static class Capability {
        public final CapabilityType type;
        public final String name;

        Capability(CapabilityType type) {
            this(type, null);
        }

        Capability(CapabilityType type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Capability that = (Capability)o;
            return this.type == that.type && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.name});
        }

        public String desc() {
            return this.type.desc.replace("_", StringUtils.defaultIfEmpty((String)this.name, (String)"_"));
        }
    }

    public static enum CapabilityType {
        OCTAL_1("\\0."),
        OCTAL_2("\\0.."),
        OCTAL_3("\\0..."),
        HEXADECIMAL_2("\\x.."),
        HEXADECIMAL_4("\\u...."),
        HEXADECIMAL_N("\\x{..}"),
        LEADING_RANGE_FROM_DASH("[--."),
        NONLEADING_RANGE_FROM_DASH("--."),
        RANGE_TO_DASH(".--"),
        ESCAPED_DASH("[...\\-...]"),
        PROPERTY_CLASS("\\p{_}"),
        PROPERTY_POSIX_PREDICATE("\\p{posixPredicate}"),
        PROPERTY_IS_POSIX_PREDICATE("\\p{IsPosixPredicate}"),
        PROPERTY_IS_UNICODE_PREDICATE("\\p{unicodePredicate}"),
        PROPERTY_UNICODE_CATEGORY("\\p{unicodeCategory}"),
        PROPERTY_IS_UNICODE_CATEGORY("\\p{IsUnicodeCategory}"),
        PROPERTY_EQ_UNICODE_CATEGORY("\\p{gc=unicodeCategory}"),
        PROPERTY_IS_UNICODE_SCRIPT("\\p{IsUnicodeScript}"),
        PROPERTY_EQ_UNICODE_SCRIPT("\\p{sc=unicodeScript}"),
        PROPERTY_IN_UNICODE_BLOCK("\\p{InUnicodeBlock}"),
        PROPERTY_EQ_UNICODE_BLOCK("\\p{blk=unicodeBlock}"),
        PREDEF_CLASS("\\_"),
        LEADING_DASH("[-...]"),
        MIDDLE_DASH("[a-z-...]"),
        TRAILING_DASH("[...-]"),
        TRAILING_DOUBLE_DASH("[...--]"),
        CHARGROUP_INTERSECTION("[...&&[...]]"),
        CHARGROUP_UNION("[...[...]]"),
        QUOTE("\\Q..\\E"),
        BOUNDARY("\\b"),
        LINEBREAK("\\n"),
        RELUCTANT_QUANTIFIER(".*?"),
        POSSESSIVE_QUANTIFIER(".*+"),
        FLAG_SWITCH("(?i)"),
        NON_CAPTURING("(?:...)"),
        NON_CAPTURING_SWITCH("(?i:...)"),
        NAMED_GROUP("(?<...>)"),
        POSITIVE_LOOKAHEAD("(?=...)"),
        NEGATIVE_LOOKAHEAD("(?!...)"),
        POSITIVE_LOOKBEHIND("(?<=...)"),
        NEGATIVE_LOOKBEHIND("(?<!...)"),
        BACK_REFERENCE("\\1"),
        NAMED_REFERENCE("\\k<...>");

        private final String desc;

        private CapabilityType(String desc) {
            this.desc = desc;
        }
    }
}

