/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeParams;
import com.dataiku.dip.streaming.crecipes.sync.SparkCSyncRecipeDef;
import com.dataiku.dip.utils.JSON;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkCSyncRecipeDefBuilder {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ComputableFromRefService cfrService;
    private final JobActivity activity;
    private static final Logger logger = Logger.getLogger((String)"dku.spark.shaker");

    public SparkCSyncRecipeDefBuilder(JobActivity activity) {
        this.activity = activity;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public SparkCSyncRecipeDef build() throws Exception {
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        FlowRecipe recipe = ((RecipeRunnableSubgraph)subgraph).getRecipe();
        SparkCSyncRecipeDef recipeDef = new SparkCSyncRecipeDef();
        recipeDef.recipeProjectKey = recipe.getProjectKey();
        CSyncRecipeParams recipeParams = RecipeRegistry.getParamsAs(this.activity, CSyncRecipeParams.class);
        recipeDef.sparkParams = (CSyncRecipeParams.SparkParams)JSON.deepCopy((Object)recipeParams.engineParams.spark);
        SerializedRecipe.RecipeInput ri = recipe.getModel().getSingleInput("main");
        FlowComputable inputComputable = this.cfrService.get(recipe.getProjectKey(), ri.ref);
        SerializedRecipe.RecipeOutput ro = recipe.getModel().getSingleOutput("main");
        FlowComputable outputComputable = this.cfrService.get(recipe.getProjectKey(), ro.ref);
        recipeDef.input = SparkRecipeUtils.getInputFlowStreamingEndpointRef(((FlowStreamingEndpoint)inputComputable).getStreamingEndpoint(), recipe.getProjectKey());
        if (outputComputable instanceof FlowStreamingEndpoint) {
            recipeDef.outputSE = SparkRecipeUtils.getOutputFlowStreamingEndpointRef(((FlowStreamingEndpoint)outputComputable).getStreamingEndpoint(), recipe.getProjectKey());
        } else if (outputComputable instanceof FlowDataset) {
            recipeDef.outputDS = SparkRecipeUtils.getOutputFlowDatasetRef((FlowDataset)outputComputable, recipe.getProjectKey(), this.activity, this.datasetsDAO);
        } else {
            throw new IllegalArgumentException("CSync only accepts datasets and streaming endpoints as output");
        }
        recipeDef.useGlobalMetastore = recipeParams.engineParams.spark.useGlobalMetastore;
        if (recipeParams.engineParams.spark.useGlobalMetastore) {
            recipeDef.metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
            if (recipeDef.metastoreDatabase == null) {
                logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default");
                recipeDef.metastoreDatabase = "";
            }
        }
        return recipeDef;
    }
}

